/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.List;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.HashMutableDirectedGraph;
import soot.toolkits.graph.ReversibleGraph;

public class HashReversibleGraph<N>
extends HashMutableDirectedGraph<N>
implements ReversibleGraph<N> {
    protected boolean reversed = false;

    public HashReversibleGraph(DirectedGraph<N> dg) {
        this();
        for (N s2 : dg) {
            this.addNode(s2);
        }
        for (N s2 : dg) {
            List<N> succs = dg.getSuccsOf(s2);
            for (N t : succs) {
                this.addEdge(s2, t);
            }
        }
        this.heads.clear();
        this.heads.addAll(dg.getHeads());
        this.tails.clear();
        this.tails.addAll(dg.getTails());
    }

    public HashReversibleGraph() {
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public ReversibleGraph<N> reverse() {
        this.reversed = !this.reversed;
        return this;
    }

    @Override
    public void addEdge(N from2, N to2) {
        if (this.reversed) {
            super.addEdge(to2, from2);
        } else {
            super.addEdge(from2, to2);
        }
    }

    @Override
    public void removeEdge(N from2, N to2) {
        if (this.reversed) {
            super.removeEdge(to2, from2);
        } else {
            super.removeEdge(from2, to2);
        }
    }

    @Override
    public boolean containsEdge(N from2, N to2) {
        return this.reversed ? super.containsEdge(to2, from2) : super.containsEdge(from2, to2);
    }

    @Override
    public List<N> getHeads() {
        return this.reversed ? super.getTails() : super.getHeads();
    }

    @Override
    public List<N> getTails() {
        return this.reversed ? super.getHeads() : super.getTails();
    }

    @Override
    public List<N> getPredsOf(N s2) {
        return this.reversed ? super.getSuccsOf(s2) : super.getPredsOf(s2);
    }

    @Override
    public List<N> getSuccsOf(N s2) {
        return this.reversed ? super.getPredsOf(s2) : super.getSuccsOf(s2);
    }
}

