/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.G;
import soot.toolkits.graph.HashMutableDirectedGraph;
import soot.toolkits.graph.MutableDirectedGraph;
import soot.toolkits.graph.MutableEdgeLabelledDirectedGraph;

public class HashMutableEdgeLabelledDirectedGraph<N, L>
implements MutableEdgeLabelledDirectedGraph<N, L> {
    protected Map<N, List<N>> nodeToPreds = new HashMap<N, List<N>>();
    protected Map<N, List<N>> nodeToSuccs = new HashMap<N, List<N>>();
    protected Map<DGEdge<N>, List<L>> edgeToLabels = new HashMap<DGEdge<N>, List<L>>();
    protected Map<L, List<DGEdge<N>>> labelToEdges = new HashMap<L, List<DGEdge<N>>>();
    protected Set<N> heads = new HashSet<N>();
    protected Set<N> tails = new HashSet<N>();

    private static <T> List<T> getCopy(Collection<? extends T> c) {
        return Collections.unmodifiableList(new ArrayList<T>(c));
    }

    public void clearAll() {
        this.nodeToPreds.clear();
        this.nodeToSuccs.clear();
        this.edgeToLabels.clear();
        this.labelToEdges.clear();
        this.heads.clear();
        this.tails.clear();
    }

    public HashMutableEdgeLabelledDirectedGraph<N, L> clone() {
        HashMutableEdgeLabelledDirectedGraph<N, L> g = new HashMutableEdgeLabelledDirectedGraph<N, L>();
        g.nodeToPreds.putAll(this.nodeToPreds);
        g.nodeToSuccs.putAll(this.nodeToSuccs);
        g.edgeToLabels.putAll(this.edgeToLabels);
        g.labelToEdges.putAll(this.labelToEdges);
        g.heads.addAll(this.heads);
        g.tails.addAll(this.tails);
        return g;
    }

    @Override
    public List<N> getHeads() {
        return HashMutableEdgeLabelledDirectedGraph.getCopy(this.heads);
    }

    @Override
    public List<N> getTails() {
        return HashMutableEdgeLabelledDirectedGraph.getCopy(this.tails);
    }

    @Override
    public List<N> getPredsOf(N s2) {
        List<N> preds = this.nodeToPreds.get(s2);
        if (preds != null) {
            return Collections.unmodifiableList(preds);
        }
        throw new RuntimeException(s2 + "not in graph!");
    }

    @Override
    public List<N> getSuccsOf(N s2) {
        List<N> succs = this.nodeToSuccs.get(s2);
        if (succs != null) {
            return Collections.unmodifiableList(succs);
        }
        throw new RuntimeException(s2 + "not in graph!");
    }

    @Override
    public int size() {
        return this.nodeToPreds.keySet().size();
    }

    @Override
    public Iterator<N> iterator() {
        return this.nodeToPreds.keySet().iterator();
    }

    @Override
    public void addEdge(N from2, N to2, L label) {
        DGEdge<N> edge;
        if (from2 == null || to2 == null) {
            throw new RuntimeException("edge from or to null");
        }
        if (label == null) {
            throw new RuntimeException("edge with null label");
        }
        if (this.containsEdge(from2, to2, label)) {
            return;
        }
        List<N> succsList = this.nodeToSuccs.get(from2);
        if (succsList == null) {
            throw new RuntimeException(from2 + " not in graph!");
        }
        List<N> predsList = this.nodeToPreds.get(to2);
        if (predsList == null) {
            throw new RuntimeException(to2 + " not in graph!");
        }
        this.heads.remove(to2);
        this.tails.remove(from2);
        if (!succsList.contains(to2)) {
            succsList.add(to2);
        }
        if (!predsList.contains(from2)) {
            predsList.add(from2);
        }
        if (!this.edgeToLabels.containsKey(edge = new DGEdge<N>(from2, to2))) {
            this.edgeToLabels.put(edge, new ArrayList());
        }
        List<L> labels = this.edgeToLabels.get(edge);
        if (!this.labelToEdges.containsKey(label)) {
            this.labelToEdges.put(label, new ArrayList());
        }
        List<DGEdge<N>> edges = this.labelToEdges.get(label);
        labels.add(label);
        edges.add(edge);
    }

    @Override
    public List<L> getLabelsForEdges(N from2, N to2) {
        DGEdge<N> edge = new DGEdge<N>(from2, to2);
        return this.edgeToLabels.get(edge);
    }

    @Override
    public MutableDirectedGraph<N> getEdgesForLabel(L label) {
        List<DGEdge<N>> edges = this.labelToEdges.get(label);
        HashMutableDirectedGraph<N> ret = new HashMutableDirectedGraph<N>();
        if (edges == null) {
            return ret;
        }
        for (DGEdge<N> edge : edges) {
            if (!ret.containsNode(edge.from())) {
                ret.addNode(edge.from());
            }
            if (!ret.containsNode(edge.to())) {
                ret.addNode(edge.to());
            }
            ret.addEdge(edge.from(), edge.to());
        }
        return ret;
    }

    @Override
    public void removeEdge(N from2, N to2, L label) {
        if (!this.containsEdge(from2, to2, label)) {
            return;
        }
        DGEdge<N> edge = new DGEdge<N>(from2, to2);
        List<L> labels = this.edgeToLabels.get(edge);
        if (labels == null) {
            throw new RuntimeException("edge " + edge + " not in graph!");
        }
        List<DGEdge<N>> edges = this.labelToEdges.get(label);
        if (edges == null) {
            throw new RuntimeException("label " + label + " not in graph!");
        }
        labels.remove(label);
        edges.remove(edge);
        if (labels.isEmpty()) {
            this.edgeToLabels.remove(edge);
            List<N> succsList = this.nodeToSuccs.get(from2);
            if (succsList == null) {
                throw new RuntimeException(from2 + " not in graph!");
            }
            List<N> predsList = this.nodeToPreds.get(to2);
            if (predsList == null) {
                throw new RuntimeException(to2 + " not in graph!");
            }
            succsList.remove(to2);
            predsList.remove(from2);
            if (succsList.isEmpty()) {
                this.tails.add(from2);
            }
            if (predsList.isEmpty()) {
                this.heads.add(to2);
            }
        }
        if (edges.isEmpty()) {
            this.labelToEdges.remove(label);
        }
    }

    @Override
    public void removeAllEdges(N from2, N to2) {
        if (!this.containsAnyEdge(from2, to2)) {
            return;
        }
        DGEdge<N> edge = new DGEdge<N>(from2, to2);
        List<L> labels = this.edgeToLabels.get(edge);
        if (labels == null) {
            throw new RuntimeException("edge " + edge + " not in graph!");
        }
        for (L label : labels) {
            this.removeEdge(from2, to2, label);
        }
    }

    @Override
    public void removeAllEdges(L label) {
        if (!this.containsAnyEdge(label)) {
            return;
        }
        List<DGEdge<N>> edges = this.labelToEdges.get(label);
        if (edges == null) {
            throw new RuntimeException("label " + label + " not in graph!");
        }
        for (DGEdge<N> edge : edges) {
            this.removeEdge(edge.from(), edge.to(), label);
        }
    }

    @Override
    public boolean containsEdge(N from2, N to2, L label) {
        DGEdge<N> edge = new DGEdge<N>(from2, to2);
        return this.edgeToLabels.get(edge) != null && this.edgeToLabels.get(edge).contains(label);
    }

    @Override
    public boolean containsAnyEdge(N from2, N to2) {
        DGEdge<N> edge = new DGEdge<N>(from2, to2);
        return this.edgeToLabels.get(edge) == null || !this.edgeToLabels.get(edge).isEmpty();
    }

    @Override
    public boolean containsAnyEdge(L label) {
        return this.labelToEdges.get(label) == null || !this.labelToEdges.get(label).isEmpty();
    }

    @Override
    public boolean containsNode(N node) {
        return this.nodeToPreds.keySet().contains(node);
    }

    @Override
    public List<N> getNodes() {
        return HashMutableEdgeLabelledDirectedGraph.getCopy(this.nodeToPreds.keySet());
    }

    @Override
    public void addNode(N node) {
        if (this.containsNode(node)) {
            throw new RuntimeException("Node already in graph");
        }
        this.nodeToSuccs.put(node, new ArrayList());
        this.nodeToPreds.put(node, new ArrayList());
        this.heads.add(node);
        this.tails.add(node);
    }

    @Override
    public void removeNode(N node) {
        for (Object n : new ArrayList(this.nodeToSuccs.get(node))) {
            this.removeAllEdges(node, n);
        }
        this.nodeToSuccs.remove(node);
        for (Object n : new ArrayList(this.nodeToPreds.get(node))) {
            this.removeAllEdges(n, node);
        }
        this.nodeToPreds.remove(node);
        this.heads.remove(node);
        this.tails.remove(node);
    }

    public void printGraph() {
        for (N node : this) {
            List<L> labels;
            DGEdge<N> edge;
            System.out.println("****************");
            G.v().out.println("Node = " + node);
            System.out.println("########");
            G.v().out.println("Preds:");
            for (N pred : this.getPredsOf(node)) {
                edge = new DGEdge<N>(pred, node);
                labels = this.edgeToLabels.get(edge);
                G.v().out.println("     " + pred + " [" + labels + "]");
            }
            System.out.println("########");
            G.v().out.println("Succs:");
            for (N succ : this.getSuccsOf(node)) {
                edge = new DGEdge<N>(node, succ);
                labels = this.edgeToLabels.get(edge);
                G.v().out.println("     " + succ + " [" + labels + "]");
            }
            System.out.println("########");
            System.out.println("****************");
        }
    }

    private static class DGEdge<N> {
        N from;
        N to;

        public DGEdge(N from2, N to2) {
            this.from = from2;
            this.to = to2;
        }

        public N from() {
            return this.from;
        }

        public N to() {
            return this.to;
        }

        public boolean equals(Object o) {
            if (o instanceof DGEdge) {
                DGEdge other = (DGEdge)o;
                return this.from.equals(other.from) && this.to.equals(other.to);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(new Object[]{this.from, this.to});
        }
    }
}

