/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.exceptions;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.AnySubType;
import soot.FastHierarchy;
import soot.G;
import soot.RefLikeType;
import soot.RefType;
import soot.Scene;
import soot.Singletons;
import soot.options.Options;

public final class ThrowableSet {
    private static final boolean INSTRUMENTING = true;
    private final Set<RefLikeType> exceptionsIncluded;
    private final Set<AnySubType> exceptionsExcluded;
    private Map<Object, ThrowableSet> memoizedAdds;

    private ThrowableSet getMemoizedAdds(Object key2) {
        if (this.memoizedAdds == null) {
            this.memoizedAdds = new HashMap<Object, ThrowableSet>();
        }
        return this.memoizedAdds.get(key2);
    }

    private ThrowableSet(Set<RefLikeType> include2, Set<AnySubType> exclude) {
        this.exceptionsIncluded = Collections.unmodifiableSet(include2);
        this.exceptionsExcluded = Collections.unmodifiableSet(exclude);
    }

    public ThrowableSet add(RefType e) throws AlreadyHasExclusionsException {
        Manager.v().addsOfRefType++;
        if (this.exceptionsIncluded.contains(e)) {
            Manager.v().addsInclusionFromMap++;
            Manager.v().addsExclusionWithoutSearch++;
            return this;
        }
        ThrowableSet result2 = this.getMemoizedAdds(e);
        if (result2 != null) {
            Manager.v().addsInclusionFromMemo++;
            Manager.v().addsExclusionWithoutSearch++;
            return result2;
        }
        Manager.v().addsInclusionFromSearch++;
        if (this.exceptionsExcluded.size() != 0) {
            Manager.v().addsExclusionWithSearch++;
        } else {
            Manager.v().addsExclusionWithoutSearch++;
        }
        FastHierarchy hierarchy = Scene.v().getOrMakeFastHierarchy();
        for (AnySubType excludedType : this.exceptionsExcluded) {
            RefType exclusionBase = excludedType.getBase();
            if ((!e.getSootClass().isPhantom() || !exclusionBase.equals(e)) && (e.getSootClass().isPhantom() || !hierarchy.canStoreType(e, exclusionBase))) continue;
            throw new AlreadyHasExclusionsException("ThrowableSet.add(RefType): adding" + e.toString() + " to the set [ " + this.toString() + "] where " + exclusionBase.toString() + " is excluded.");
        }
        if (!e.getSootClass().isPhantom()) {
            for (RefLikeType incumbent : this.exceptionsIncluded) {
                if (incumbent instanceof AnySubType) {
                    RefType incumbentBase = ((AnySubType)incumbent).getBase();
                    if (!hierarchy.canStoreType(e, incumbentBase)) continue;
                    this.memoizedAdds.put(e, this);
                    return this;
                }
                if (incumbent instanceof RefType) continue;
                throw new IllegalStateException("ThrowableSet.add(RefType): Set element " + incumbent.toString() + " is neither a RefType nor an AnySubType.");
            }
        }
        HashSet<RefLikeType> resultSet = new HashSet<RefLikeType>(this.exceptionsIncluded);
        resultSet.add(e);
        result2 = Manager.v().registerSetIfNew(resultSet, this.exceptionsExcluded);
        this.memoizedAdds.put(e, result2);
        return result2;
    }

    public ThrowableSet add(AnySubType e) throws AlreadyHasExclusionsException {
        Manager.v().addsOfAnySubType++;
        ThrowableSet result2 = this.getMemoizedAdds(e);
        if (result2 != null) {
            Manager.v().addsInclusionFromMemo++;
            Manager.v().addsExclusionWithoutSearch++;
            return result2;
        }
        FastHierarchy hierarchy = Scene.v().getOrMakeFastHierarchy();
        RefType newBase = e.getBase();
        if (this.exceptionsExcluded.size() != 0) {
            Manager.v().addsExclusionWithSearch++;
        } else {
            Manager.v().addsExclusionWithoutSearch++;
        }
        for (AnySubType excludedType : this.exceptionsExcluded) {
            RefType exclusionBase = excludedType.getBase();
            boolean isExcluded = exclusionBase.getSootClass().isPhantom() && exclusionBase.equals(newBase);
            if (!(isExcluded |= !exclusionBase.getSootClass().isPhantom() && (hierarchy.canStoreType(newBase, exclusionBase) || hierarchy.canStoreType(exclusionBase, newBase)))) continue;
            Manager.v().addsInclusionInterrupted++;
            throw new AlreadyHasExclusionsException("ThrowableSet.add(" + e.toString() + ") to the set [ " + this.toString() + "] where " + exclusionBase.toString() + " is excluded.");
        }
        if (this.exceptionsIncluded.contains(e)) {
            Manager.v().addsInclusionFromMap++;
            return this;
        }
        Manager.v().addsInclusionFromSearch++;
        int changes = 0;
        boolean addNewException = true;
        HashSet<RefLikeType> resultSet = new HashSet<RefLikeType>();
        for (RefLikeType incumbent : this.exceptionsIncluded) {
            if (incumbent instanceof RefType) {
                if (hierarchy.canStoreType(incumbent, newBase)) {
                    ++changes;
                    continue;
                }
                resultSet.add(incumbent);
                continue;
            }
            if (incumbent instanceof AnySubType) {
                RefType incumbentBase = ((AnySubType)incumbent).getBase();
                if (newBase.getSootClass().isPhantom()) {
                    if (incumbentBase.equals(newBase)) continue;
                    resultSet.add(incumbent);
                    continue;
                }
                if (hierarchy.canStoreType(newBase, incumbentBase)) {
                    addNewException = false;
                    resultSet.add(incumbent);
                    continue;
                }
                if (hierarchy.canStoreType(incumbentBase, newBase)) {
                    ++changes;
                    continue;
                }
                resultSet.add(incumbent);
                continue;
            }
            throw new IllegalStateException("ThrowableSet.add(AnySubType): Set element " + incumbent.toString() + " is neither a RefType nor an AnySubType.");
        }
        if (addNewException) {
            resultSet.add(e);
            ++changes;
        }
        result2 = changes > 0 ? Manager.v().registerSetIfNew(resultSet, this.exceptionsExcluded) : this;
        this.memoizedAdds.put(e, result2);
        return result2;
    }

    public ThrowableSet add(ThrowableSet s2) throws AlreadyHasExclusionsException {
        Manager.v().addsOfSet++;
        if (this.exceptionsExcluded.size() > 0 || s2.exceptionsExcluded.size() > 0) {
            throw new AlreadyHasExclusionsException("ThrowableSet.Add(ThrowableSet): attempt to add to [" + this.toString() + "] after removals recorded.");
        }
        ThrowableSet result2 = this.getMemoizedAdds(s2);
        if (result2 == null) {
            Manager.v().addsInclusionFromSearch++;
            Manager.v().addsExclusionWithoutSearch++;
            result2 = this.add(s2.exceptionsIncluded);
            this.memoizedAdds.put(s2, result2);
        } else {
            Manager.v().addsInclusionFromMemo++;
            Manager.v().addsExclusionWithoutSearch++;
        }
        return result2;
    }

    private ThrowableSet add(Set<RefLikeType> addedExceptions) {
        HashSet<RefLikeType> resultSet = new HashSet<RefLikeType>(this.exceptionsIncluded);
        int changes = 0;
        FastHierarchy hierarchy = Scene.v().getOrMakeFastHierarchy();
        for (RefLikeType newType : addedExceptions) {
            if (resultSet.contains(newType)) continue;
            boolean addNewType = true;
            if (newType instanceof RefType) {
                for (RefLikeType incumbentType : resultSet) {
                    if (incumbentType instanceof RefType) {
                        if (newType != incumbentType) continue;
                        throw new IllegalStateException("ThrowableSet.add(Set): resultSet.contains() failed to screen duplicate RefType " + newType);
                    }
                    if (incumbentType instanceof AnySubType) {
                        RefType incumbentBase = ((AnySubType)incumbentType).getBase();
                        if (!hierarchy.canStoreType(newType, incumbentBase)) continue;
                        addNewType = false;
                        continue;
                    }
                    throw new IllegalStateException("ThrowableSet.add(Set): incumbent Set element " + incumbentType + " is neither a RefType nor an AnySubType.");
                }
            } else if (newType instanceof AnySubType) {
                RefType newBase = ((AnySubType)newType).getBase();
                Iterator j = resultSet.iterator();
                while (j.hasNext()) {
                    RefType incumbentBase;
                    RefLikeType incumbentType = (RefLikeType)j.next();
                    if (incumbentType instanceof RefType) {
                        incumbentBase = (RefType)incumbentType;
                        if (!hierarchy.canStoreType(incumbentBase, newBase)) continue;
                        j.remove();
                        ++changes;
                        continue;
                    }
                    if (incumbentType instanceof AnySubType) {
                        incumbentBase = ((AnySubType)incumbentType).getBase();
                        if (newBase == incumbentBase) {
                            throw new IllegalStateException("ThrowableSet.add(Set): resultSet.contains() failed to screen duplicate AnySubType " + newBase);
                        }
                        if (hierarchy.canStoreType(incumbentBase, newBase)) {
                            j.remove();
                            ++changes;
                            continue;
                        }
                        if (!hierarchy.canStoreType(newBase, incumbentBase)) continue;
                        addNewType = false;
                        continue;
                    }
                    throw new IllegalStateException("ThrowableSet.add(Set): old Set element " + incumbentType + " is neither a RefType nor an AnySubType.");
                }
            } else {
                throw new IllegalArgumentException("ThrowableSet.add(Set): new Set element " + newType + " is neither a RefType nor an AnySubType.");
            }
            if (!addNewType) continue;
            ++changes;
            resultSet.add(newType);
        }
        ThrowableSet result2 = null;
        result2 = changes > 0 ? Manager.v().registerSetIfNew(resultSet, this.exceptionsExcluded) : this;
        return result2;
    }

    public boolean catchableAs(RefType catcher) {
        Manager.v().catchableAsQueries++;
        FastHierarchy h = Scene.v().getOrMakeFastHierarchy();
        if (this.exceptionsExcluded.size() > 0) {
            Manager.v().catchableAsFromSearch++;
            for (AnySubType exclusion : this.exceptionsExcluded) {
                if (!(catcher.getSootClass().isPhantom() ? exclusion.getBase().equals(catcher) : h.canStoreType(catcher, exclusion.getBase()))) continue;
                return false;
            }
        }
        if (this.exceptionsIncluded.contains(catcher)) {
            if (this.exceptionsExcluded.size() == 0) {
                Manager.v().catchableAsFromMap++;
            } else {
                Manager.v().catchableAsFromSearch++;
            }
            return true;
        }
        if (this.exceptionsExcluded.size() == 0) {
            Manager.v().catchableAsFromSearch++;
        }
        for (RefLikeType thrownType : this.exceptionsIncluded) {
            if (thrownType instanceof RefType) {
                if (thrownType == catcher) {
                    throw new IllegalStateException("ThrowableSet.catchableAs(RefType): exceptions.contains() failed to match contained RefType " + catcher);
                }
                if (catcher.getSootClass().isPhantom() || !h.canStoreType(thrownType, catcher)) continue;
                return true;
            }
            RefType thrownBase = ((AnySubType)thrownType).getBase();
            if (!(catcher.getSootClass().isPhantom() ? thrownBase.equals(catcher) || thrownBase.getClassName().equals("java.lang.Throwable") : h.canStoreType(thrownBase, catcher) || h.canStoreType(catcher, thrownBase))) continue;
            return true;
        }
        return false;
    }

    public Pair whichCatchableAs(RefType catcher) {
        Manager.v().removesOfAnySubType++;
        FastHierarchy h = Scene.v().getOrMakeFastHierarchy();
        Set<RefLikeType> caughtIncluded = null;
        Set<AnySubType> caughtExcluded = null;
        Set<RefLikeType> uncaughtIncluded = null;
        Set<AnySubType> uncaughtExcluded = null;
        Manager.v().removesFromSearch++;
        for (AnySubType exclusion : this.exceptionsExcluded) {
            RefType exclusionBase = exclusion.getBase();
            if (catcher.getSootClass().isPhantom() && exclusionBase.equals(catcher)) {
                return new Pair(Manager.v().EMPTY, this);
            }
            if (h.canStoreType(catcher, exclusionBase)) {
                return new Pair(Manager.v().EMPTY, this);
            }
            if (h.canStoreType(exclusionBase, catcher)) {
                caughtExcluded = this.addExceptionToSet(exclusion, caughtExcluded);
                continue;
            }
            uncaughtExcluded = this.addExceptionToSet(exclusion, uncaughtExcluded);
        }
        for (RefLikeType inclusion : this.exceptionsIncluded) {
            if (inclusion instanceof RefType) {
                if (catcher.getSootClass().isPhantom()) {
                    if (inclusion.equals(catcher)) {
                        caughtIncluded = this.addExceptionToSet(inclusion, caughtIncluded);
                        continue;
                    }
                    uncaughtIncluded = this.addExceptionToSet(inclusion, uncaughtIncluded);
                    continue;
                }
                if (h.canStoreType(inclusion, catcher)) {
                    caughtIncluded = this.addExceptionToSet(inclusion, caughtIncluded);
                    continue;
                }
                uncaughtIncluded = this.addExceptionToSet(inclusion, uncaughtIncluded);
                continue;
            }
            RefType base = ((AnySubType)inclusion).getBase();
            if (catcher.getSootClass().isPhantom()) {
                if (base.equals(catcher)) {
                    caughtIncluded = this.addExceptionToSet(inclusion, caughtIncluded);
                    continue;
                }
                if (base.getClassName().equals("java.lang.Throwable")) {
                    caughtIncluded = this.addExceptionToSet(catcher, caughtIncluded);
                }
                uncaughtIncluded = this.addExceptionToSet(inclusion, uncaughtIncluded);
                continue;
            }
            if (h.canStoreType(base, catcher)) {
                caughtIncluded = this.addExceptionToSet(inclusion, caughtIncluded);
                continue;
            }
            if (h.canStoreType(catcher, base)) {
                uncaughtIncluded = this.addExceptionToSet(inclusion, uncaughtIncluded);
                uncaughtExcluded = this.addExceptionToSet(AnySubType.v(catcher), uncaughtExcluded);
                caughtIncluded = this.addExceptionToSet(AnySubType.v(catcher), caughtIncluded);
                continue;
            }
            uncaughtIncluded = this.addExceptionToSet(inclusion, uncaughtIncluded);
        }
        ThrowableSet caughtSet = Manager.v().registerSetIfNew(caughtIncluded, caughtExcluded);
        ThrowableSet uncaughtSet = Manager.v().registerSetIfNew(uncaughtIncluded, uncaughtExcluded);
        return new Pair(caughtSet, uncaughtSet);
    }

    private <T> Set<T> addExceptionToSet(T e, Set<T> set2) {
        if (set2 == null) {
            set2 = new HashSet<T>();
        }
        set2.add(e);
        return set2;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.toBriefString());
        buffer.append(":\n  ");
        for (RefLikeType refLikeType : this.exceptionsIncluded) {
            buffer.append('+');
            buffer.append(refLikeType == null ? "null" : refLikeType.toString());
        }
        for (RefLikeType refLikeType : this.exceptionsExcluded) {
            buffer.append('-');
            buffer.append(refLikeType.toString());
        }
        return buffer.toString();
    }

    public String toBriefString() {
        return super.toString();
    }

    private static <T extends RefLikeType> Iterator<T> sortedThrowableIterator(Collection<T> coll) {
        if (coll.size() <= 1) {
            return coll.iterator();
        }
        RefLikeType[] array = (RefLikeType[])coll.toArray(new Object[0]);
        Arrays.sort(array, new ThrowableComparator());
        return Arrays.asList(array).iterator();
    }

    public String toAbbreviatedString() {
        return this.toAbbreviatedString(this.exceptionsIncluded, '+') + this.toAbbreviatedString(this.exceptionsExcluded, '-');
    }

    private String toAbbreviatedString(Set<? extends RefLikeType> s2, char connector) {
        String JAVA_LANG = "java.lang.";
        int JAVA_LANG_LENGTH = "java.lang.".length();
        String EXCEPTION = "Exception";
        int EXCEPTION_LENGTH = "Exception".length();
        Set<RefLikeType> vmErrorThrowables = Manager.v().VM_ERRORS.exceptionsIncluded;
        boolean containsAllVmErrors = s2.containsAll(vmErrorThrowables);
        StringBuffer buf = new StringBuffer();
        if (containsAllVmErrors) {
            buf.append(connector);
            buf.append("vmErrors");
        }
        Iterator<? extends RefLikeType> it = ThrowableSet.sortedThrowableIterator(s2);
        while (it.hasNext()) {
            RefLikeType reflikeType = it.next();
            RefType baseType = null;
            if (reflikeType instanceof RefType) {
                baseType = (RefType)reflikeType;
                if (vmErrorThrowables.contains(baseType) && containsAllVmErrors) continue;
                buf.append(connector);
            } else if (reflikeType instanceof AnySubType) {
                buf.append(connector);
                buf.append('(');
                baseType = ((AnySubType)reflikeType).getBase();
            } else {
                throw new RuntimeException("Unsupported type " + reflikeType.getClass().getName());
            }
            String typeName = baseType.toString();
            if (typeName.startsWith("java.lang.")) {
                typeName = typeName.substring(JAVA_LANG_LENGTH);
            }
            if (typeName.length() > EXCEPTION_LENGTH && typeName.endsWith("Exception")) {
                typeName = typeName.substring(0, typeName.length() - EXCEPTION_LENGTH);
            }
            buf.append(typeName);
            if (!(reflikeType instanceof AnySubType)) continue;
            buf.append(')');
        }
        return buf.toString();
    }

    Collection<RefLikeType> typesIncluded() {
        return new AbstractCollection<RefLikeType>(){

            @Override
            public Iterator<RefLikeType> iterator() {
                return new Iterator<RefLikeType>(){
                    private final Iterator<RefLikeType> i;
                    {
                        this.i = ThrowableSet.this.exceptionsIncluded.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public RefLikeType next() {
                        return this.i.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return ThrowableSet.this.exceptionsIncluded.size();
            }
        };
    }

    Collection<AnySubType> typesExcluded() {
        return new AbstractCollection<AnySubType>(){

            @Override
            public Iterator<AnySubType> iterator() {
                return new Iterator<AnySubType>(){
                    private final Iterator<AnySubType> i;
                    {
                        this.i = ThrowableSet.this.exceptionsExcluded.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public AnySubType next() {
                        return this.i.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return ThrowableSet.this.exceptionsExcluded.size();
            }
        };
    }

    Map<Object, ThrowableSet> getMemoizedAdds() {
        if (this.memoizedAdds == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.memoizedAdds);
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.exceptionsExcluded == null ? 0 : this.exceptionsExcluded.hashCode());
        result2 = 31 * result2 + (this.exceptionsIncluded == null ? 0 : this.exceptionsIncluded.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThrowableSet other = (ThrowableSet)obj;
        if (this.exceptionsExcluded == null ? other.exceptionsExcluded != null : !this.exceptionsExcluded.equals(other.exceptionsExcluded)) {
            return false;
        }
        return !(this.exceptionsIncluded == null ? other.exceptionsIncluded != null : !this.exceptionsIncluded.equals(other.exceptionsIncluded));
    }

    private static class ThrowableComparator<T extends RefLikeType>
    implements Comparator<T> {
        private ThrowableComparator() {
        }

        private static RefType baseType(RefLikeType o) {
            if (o instanceof AnySubType) {
                return ((AnySubType)o).getBase();
            }
            return (RefType)o;
        }

        @Override
        public int compare(T o1, T o2) {
            RefType t2;
            RefType t1 = ThrowableComparator.baseType(o1);
            if (t1.equals(t2 = ThrowableComparator.baseType(o2))) {
                if (o1 instanceof AnySubType) {
                    if (o2 instanceof AnySubType) {
                        return 0;
                    }
                    return -1;
                }
                if (o2 instanceof AnySubType) {
                    return 1;
                }
                return 0;
            }
            return t1.toString().compareTo(t2.toString());
        }
    }

    public static class Pair {
        private ThrowableSet caught;
        private ThrowableSet uncaught;

        protected Pair(ThrowableSet caught, ThrowableSet uncaught) {
            this.caught = caught;
            this.uncaught = uncaught;
        }

        public ThrowableSet getCaught() {
            return this.caught;
        }

        public ThrowableSet getUncaught() {
            return this.uncaught;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pair)) {
                return false;
            }
            Pair tsp = (Pair)o;
            return this.caught.equals(tsp.caught) && this.uncaught.equals(tsp.uncaught);
        }

        public int hashCode() {
            int result2 = 31;
            result2 = 37 * result2 + this.caught.hashCode();
            result2 = 37 * result2 + this.uncaught.hashCode();
            return result2;
        }
    }

    public static class AlreadyHasExclusionsException
    extends IllegalStateException {
        public AlreadyHasExclusionsException(String s2) {
            super(s2);
        }
    }

    public static class Manager {
        private final Map<Integer, List<ThrowableSet>> sizeToSets = new HashMap<Integer, List<ThrowableSet>>();
        public final ThrowableSet EMPTY;
        final ThrowableSet ALL_THROWABLES;
        final ThrowableSet VM_ERRORS;
        final ThrowableSet RESOLVE_CLASS_ERRORS;
        final ThrowableSet RESOLVE_FIELD_ERRORS;
        final ThrowableSet RESOLVE_METHOD_ERRORS;
        final ThrowableSet INITIALIZATION_ERRORS;
        public final RefType RUNTIME_EXCEPTION = Scene.v().getRefType("java.lang.RuntimeException");
        public final RefType ARITHMETIC_EXCEPTION = Scene.v().getRefType("java.lang.ArithmeticException");
        public final RefType ARRAY_STORE_EXCEPTION = Scene.v().getRefType("java.lang.ArrayStoreException");
        public final RefType CLASS_CAST_EXCEPTION = Scene.v().getRefType("java.lang.ClassCastException");
        public final RefType ILLEGAL_MONITOR_STATE_EXCEPTION = Scene.v().getRefType("java.lang.IllegalMonitorStateException");
        public final RefType INDEX_OUT_OF_BOUNDS_EXCEPTION = Scene.v().getRefType("java.lang.IndexOutOfBoundsException");
        public final RefType ARRAY_INDEX_OUT_OF_BOUNDS_EXCEPTION = Scene.v().getRefType("java.lang.ArrayIndexOutOfBoundsException");
        public final RefType NEGATIVE_ARRAY_SIZE_EXCEPTION = Scene.v().getRefType("java.lang.NegativeArraySizeException");
        public final RefType NULL_POINTER_EXCEPTION = Scene.v().getRefType("java.lang.NullPointerException");
        public final RefType INSTANTIATION_ERROR = Scene.v().getRefType("java.lang.InstantiationError");
        private int registeredSets = 0;
        private int addsOfRefType = 0;
        private int addsOfAnySubType = 0;
        private int addsOfSet = 0;
        private int addsInclusionFromMap = 0;
        private int addsInclusionFromMemo = 0;
        private int addsInclusionFromSearch = 0;
        private int addsInclusionInterrupted = 0;
        private int addsExclusionWithSearch = 0;
        private int addsExclusionWithoutSearch = 0;
        private int removesOfAnySubType = 0;
        private final int removesFromMap = 0;
        private final int removesFromMemo = 0;
        private int removesFromSearch = 0;
        private int registrationCalls = 0;
        private int catchableAsQueries = 0;
        private int catchableAsFromMap = 0;
        private int catchableAsFromSearch = 0;

        public Manager(Singletons.Global g) {
            this.EMPTY = this.registerSetIfNew(null, null);
            HashSet<RefLikeType> allThrowablesSet = new HashSet<RefLikeType>();
            allThrowablesSet.add(AnySubType.v(Scene.v().getRefType("java.lang.Throwable")));
            this.ALL_THROWABLES = this.registerSetIfNew(allThrowablesSet, null);
            HashSet<RefLikeType> vmErrorSet = new HashSet<RefLikeType>();
            vmErrorSet.add(Scene.v().getRefType("java.lang.InternalError"));
            vmErrorSet.add(Scene.v().getRefType("java.lang.OutOfMemoryError"));
            vmErrorSet.add(Scene.v().getRefType("java.lang.StackOverflowError"));
            vmErrorSet.add(Scene.v().getRefType("java.lang.UnknownError"));
            vmErrorSet.add(Scene.v().getRefType("java.lang.ThreadDeath"));
            this.VM_ERRORS = this.registerSetIfNew(vmErrorSet, null);
            HashSet<RefLikeType> resolveClassErrorSet = new HashSet<RefLikeType>();
            resolveClassErrorSet.add(Scene.v().getRefType("java.lang.ClassCircularityError"));
            if (!Options.v().j2me()) {
                resolveClassErrorSet.add(AnySubType.v(Scene.v().getRefType("java.lang.ClassFormatError")));
            }
            resolveClassErrorSet.add(Scene.v().getRefType("java.lang.IllegalAccessError"));
            resolveClassErrorSet.add(Scene.v().getRefType("java.lang.IncompatibleClassChangeError"));
            resolveClassErrorSet.add(Scene.v().getRefType("java.lang.LinkageError"));
            resolveClassErrorSet.add(Scene.v().getRefType("java.lang.NoClassDefFoundError"));
            resolveClassErrorSet.add(Scene.v().getRefType("java.lang.VerifyError"));
            this.RESOLVE_CLASS_ERRORS = this.registerSetIfNew(resolveClassErrorSet, null);
            HashSet<RefLikeType> resolveFieldErrorSet = new HashSet<RefLikeType>(resolveClassErrorSet);
            resolveFieldErrorSet.add(Scene.v().getRefType("java.lang.NoSuchFieldError"));
            this.RESOLVE_FIELD_ERRORS = this.registerSetIfNew(resolveFieldErrorSet, null);
            HashSet<RefLikeType> resolveMethodErrorSet = new HashSet<RefLikeType>(resolveClassErrorSet);
            resolveMethodErrorSet.add(Scene.v().getRefType("java.lang.AbstractMethodError"));
            resolveMethodErrorSet.add(Scene.v().getRefType("java.lang.NoSuchMethodError"));
            resolveMethodErrorSet.add(Scene.v().getRefType("java.lang.UnsatisfiedLinkError"));
            this.RESOLVE_METHOD_ERRORS = this.registerSetIfNew(resolveMethodErrorSet, null);
            HashSet<RefLikeType> initializationErrorSet = new HashSet<RefLikeType>();
            initializationErrorSet.add(AnySubType.v(Scene.v().getRefType("java.lang.Error")));
            this.INITIALIZATION_ERRORS = this.registerSetIfNew(initializationErrorSet, null);
        }

        public static Manager v() {
            return G.v().soot_toolkits_exceptions_ThrowableSet_Manager();
        }

        private ThrowableSet registerSetIfNew(Set<RefLikeType> include2, Set<AnySubType> exclude) {
            int size2;
            Integer sizeKey;
            List<ThrowableSet> sizeList;
            ++this.registrationCalls;
            if (include2 == null) {
                include2 = Collections.emptySet();
            }
            if (exclude == null) {
                exclude = Collections.emptySet();
            }
            if ((sizeList = this.sizeToSets.get(sizeKey = new Integer(size2 = include2.size() + exclude.size()))) == null) {
                sizeList = new LinkedList<ThrowableSet>();
                this.sizeToSets.put(sizeKey, sizeList);
            }
            for (ThrowableSet set2 : sizeList) {
                if (!set2.exceptionsIncluded.equals(include2) || !set2.exceptionsExcluded.equals(exclude)) continue;
                return set2;
            }
            ++this.registeredSets;
            ThrowableSet result2 = new ThrowableSet(include2, exclude);
            sizeList.add(result2);
            return result2;
        }

        public String reportInstrumentation() {
            int setCount = 0;
            for (List<ThrowableSet> sizeList : this.sizeToSets.values()) {
                setCount += sizeList.size();
            }
            if (setCount != this.registeredSets) {
                throw new IllegalStateException("ThrowableSet.reportInstrumentation() assertion failure: registeredSets != list count");
            }
            StringBuffer buf = new StringBuffer("registeredSets: ").append(setCount).append("\naddsOfRefType: ").append(this.addsOfRefType).append("\naddsOfAnySubType: ").append(this.addsOfAnySubType).append("\naddsOfSet: ").append(this.addsOfSet).append("\naddsInclusionFromMap: ").append(this.addsInclusionFromMap).append("\naddsInclusionFromMemo: ").append(this.addsInclusionFromMemo).append("\naddsInclusionFromSearch: ").append(this.addsInclusionFromSearch).append("\naddsInclusionInterrupted: ").append(this.addsInclusionInterrupted).append("\naddsExclusionWithoutSearch: ").append(this.addsExclusionWithoutSearch).append("\naddsExclusionWithSearch: ").append(this.addsExclusionWithSearch).append("\nremovesOfAnySubType: ").append(this.removesOfAnySubType).append("\nremovesFromMap: ").append(0).append("\nremovesFromMemo: ").append(0).append("\nremovesFromSearch: ").append(this.removesFromSearch).append("\nregistrationCalls: ").append(this.registrationCalls).append("\ncatchableAsQueries: ").append(this.catchableAsQueries).append("\ncatchableAsFromMap: ").append(this.catchableAsFromMap).append("\ncatchableAsFromSearch: ").append(this.catchableAsFromSearch).append('\n');
            return buf.toString();
        }

        Map<Integer, List<ThrowableSet>> getSizeToSets() {
            return Manager.v().sizeToSets;
        }
    }
}

