/*
 * Decompiled with CFR 0.152.
 */
package soot.tagkit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import soot.tagkit.Host;
import soot.tagkit.LineNumberTag;
import soot.tagkit.SourceLnPosTag;
import soot.tagkit.Tag;

public class AbstractHost
implements Host {
    protected int line;
    protected int col;
    private List<Tag> mTagList = null;

    @Override
    public List<Tag> getTags() {
        return this.mTagList == null ? Collections.emptyList() : this.mTagList;
    }

    @Override
    public void removeTag(String aName) {
        int tagIndex = this.searchForTag(aName);
        if (tagIndex != -1) {
            this.mTagList.remove(tagIndex);
        }
    }

    private int searchForTag(String aName) {
        if (this.mTagList == null) {
            return -1;
        }
        int i = 0;
        for (Tag tag : this.mTagList) {
            if (tag.getName().equals(aName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Tag getTag(String aName) {
        int tagIndex = this.searchForTag(aName);
        if (tagIndex != -1) {
            return this.mTagList.get(tagIndex);
        }
        return null;
    }

    @Override
    public boolean hasTag(String aName) {
        return this.searchForTag(aName) != -1;
    }

    @Override
    public void addTag(Tag t) {
        if (this.mTagList == null) {
            this.mTagList = new ArrayList<Tag>(1);
        }
        this.mTagList.add(t);
    }

    @Override
    public void removeAllTags() {
        this.mTagList = null;
    }

    @Override
    public void addAllTagsOf(Host h) {
        List<Tag> tags2 = h.getTags();
        if (tags2.isEmpty()) {
            return;
        }
        if (this.mTagList == null) {
            this.mTagList = new ArrayList<Tag>(tags2.size());
        }
        this.mTagList.addAll(tags2);
    }

    @Override
    public int getJavaSourceStartLineNumber() {
        if (this.line == 0) {
            LineNumberTag tag2;
            SourceLnPosTag tag = (SourceLnPosTag)this.getTag("SourceLnPosTag");
            this.line = tag != null ? tag.startLn() : ((tag2 = (LineNumberTag)this.getTag("LineNumberTag")) != null ? tag2.getLineNumber() : -1);
        }
        return this.line;
    }

    @Override
    public int getJavaSourceStartColumnNumber() {
        if (this.col == 0) {
            SourceLnPosTag tag = (SourceLnPosTag)this.getTag("SourceLnPosTag");
            this.col = tag != null ? tag.startPos() : -1;
        }
        return this.col;
    }
}

