/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.validation;

import java.util.List;
import soot.Body;
import soot.Unit;
import soot.jimple.GotoStmt;
import soot.jimple.RetStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.ThrowStmt;
import soot.validation.BodyValidator;
import soot.validation.ValidationException;

public enum ReturnStatementsValidator implements BodyValidator
{
    INSTANCE;


    public static ReturnStatementsValidator v() {
        return INSTANCE;
    }

    @Override
    public void validate(Body body, List<ValidationException> exception) {
        for (Unit u : body.getUnits()) {
            if (!(u instanceof ReturnStmt) && !(u instanceof ReturnVoidStmt) && !(u instanceof RetStmt) && !(u instanceof ThrowStmt)) continue;
            return;
        }
        Object last2 = body.getUnits().getLast();
        if (last2 instanceof GotoStmt || last2 instanceof ThrowStmt) {
            return;
        }
        exception.add(new ValidationException(body.getMethod(), "The method does not contain a return statement", "Body of method " + body.getMethod().getSignature() + " does not contain a return statement"));
    }

    @Override
    public boolean isBasicValidator() {
        return true;
    }
}

