/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.validation;

import java.util.List;
import soot.Body;
import soot.ResolutionFailedException;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.util.Chain;
import soot.validation.BodyValidator;
import soot.validation.UnitValidationException;
import soot.validation.ValidationException;

public enum FieldRefValidator implements BodyValidator
{
    INSTANCE;


    public static FieldRefValidator v() {
        return INSTANCE;
    }

    @Override
    public void validate(Body body, List<ValidationException> exception) {
        SootMethod method = body.getMethod();
        if (method.isAbstract()) {
            return;
        }
        Chain<Unit> units = body.getUnits().getNonPatchingChain();
        for (Unit unit : units) {
            SootField field2;
            FieldRef v;
            Stmt s2 = (Stmt)unit;
            if (!s2.containsFieldRef()) continue;
            FieldRef fr = s2.getFieldRef();
            if (fr instanceof StaticFieldRef) {
                v = (StaticFieldRef)fr;
                try {
                    field2 = ((StaticFieldRef)v).getField();
                    if (field2.isStatic() || field2.isPhantom()) continue;
                    exception.add(new UnitValidationException(unit, body, "Trying to get a static field which is non-static: " + v));
                }
                catch (ResolutionFailedException e) {
                    exception.add(new UnitValidationException(unit, body, "Trying to get a static field which is non-static: " + v));
                }
                continue;
            }
            if (fr instanceof InstanceFieldRef) {
                v = (InstanceFieldRef)fr;
                try {
                    field2 = v.getField();
                    if (!field2.isStatic() || field2.isPhantom()) continue;
                    exception.add(new UnitValidationException(unit, body, "Trying to get an instance field which is static: " + v));
                }
                catch (ResolutionFailedException e) {
                    exception.add(new UnitValidationException(unit, body, "Trying to get an instance field which is static: " + v));
                }
                continue;
            }
            throw new RuntimeException("unknown field ref");
        }
    }

    @Override
    public boolean isBasicValidator() {
        return true;
    }
}

