/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.typing;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import soot.ArrayType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.NullType;
import soot.PatchingChain;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.Type;
import soot.Unit;
import soot.jimple.AssignStmt;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NewExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.toolkits.typing.ClassHierarchy;
import soot.jimple.toolkits.typing.ConstraintCheckerBV;
import soot.jimple.toolkits.typing.ConstraintCollectorBV;
import soot.jimple.toolkits.typing.StronglyConnectedComponentsBV;
import soot.jimple.toolkits.typing.TypeException;
import soot.jimple.toolkits.typing.TypeNode;
import soot.jimple.toolkits.typing.TypeVariableBV;
import soot.jimple.toolkits.typing.integer.TypeResolver;
import soot.options.Options;
import soot.toolkits.scalar.LocalDefs;
import soot.util.BitSetIterator;
import soot.util.BitVector;

@Deprecated
public class TypeResolverBV {
    private final ClassHierarchy hierarchy;
    private final List<TypeVariableBV> typeVariableList = new ArrayList<TypeVariableBV>();
    private final BitVector invalidIds = new BitVector();
    private final Map<Object, TypeVariableBV> typeVariableMap = new HashMap<Object, TypeVariableBV>();
    private final JimpleBody stmtBody;
    final TypeNode NULL;
    private final TypeNode OBJECT;
    private static final boolean DEBUG = false;
    private BitVector unsolved;
    private BitVector solved;
    private BitVector single_soft_parent;
    private BitVector single_hard_parent;
    private BitVector multiple_parents;
    private BitVector single_child_not_null;
    private BitVector single_null_child;
    private BitVector multiple_children;

    public ClassHierarchy hierarchy() {
        return this.hierarchy;
    }

    public TypeNode typeNode(Type type) {
        return this.hierarchy.typeNode(type);
    }

    TypeVariableBV typeVariable(Local local) {
        TypeVariableBV result2 = this.typeVariableMap.get(local);
        if (result2 == null) {
            int id = this.typeVariableList.size();
            this.typeVariableList.add(null);
            result2 = new TypeVariableBV(id, this);
            this.typeVariableList.set(id, result2);
            this.typeVariableMap.put(local, result2);
        }
        return result2;
    }

    public TypeVariableBV typeVariable(TypeNode typeNode) {
        TypeVariableBV result2 = this.typeVariableMap.get(typeNode);
        if (result2 == null) {
            int id = this.typeVariableList.size();
            this.typeVariableList.add(null);
            result2 = new TypeVariableBV(id, this, typeNode);
            this.typeVariableList.set(id, result2);
            this.typeVariableMap.put(typeNode, result2);
        }
        return result2;
    }

    public TypeVariableBV typeVariable(SootClass sootClass) {
        return this.typeVariable(this.hierarchy.typeNode(sootClass.getType()));
    }

    public TypeVariableBV typeVariable(Type type) {
        return this.typeVariable(this.hierarchy.typeNode(type));
    }

    public TypeVariableBV typeVariable() {
        int id = this.typeVariableList.size();
        this.typeVariableList.add(null);
        TypeVariableBV result2 = new TypeVariableBV(id, this);
        this.typeVariableList.set(id, result2);
        return result2;
    }

    private TypeResolverBV(JimpleBody stmtBody, Scene scene) {
        this.stmtBody = stmtBody;
        this.hierarchy = ClassHierarchy.classHierarchy(scene);
        this.OBJECT = this.hierarchy.OBJECT;
        this.NULL = this.hierarchy.NULL;
        this.typeVariable(this.OBJECT);
        this.typeVariable(this.NULL);
        if (!Options.v().j2me()) {
            this.typeVariable(this.hierarchy.CLONEABLE);
            this.typeVariable(this.hierarchy.SERIALIZABLE);
        }
    }

    public static void resolve(JimpleBody stmtBody, Scene scene) {
        try {
            TypeResolverBV resolver = new TypeResolverBV(stmtBody, scene);
            resolver.resolve_step_1();
        }
        catch (TypeException e1) {
            try {
                TypeResolverBV resolver = new TypeResolverBV(stmtBody, scene);
                resolver.resolve_step_2();
            }
            catch (TypeException e2) {
                try {
                    TypeResolverBV resolver = new TypeResolverBV(stmtBody, scene);
                    resolver.resolve_step_3();
                }
                catch (TypeException e3) {
                    StringWriter st = new StringWriter();
                    PrintWriter pw = new PrintWriter(st);
                    e3.printStackTrace(pw);
                    pw.close();
                    throw new RuntimeException(st.toString());
                }
            }
        }
        TypeResolver.resolve(stmtBody);
    }

    private void debug_vars(String message) {
    }

    private void debug_body() {
    }

    private void resolve_step_1() throws TypeException {
        this.collect_constraints_1_2();
        this.debug_vars("constraints");
        this.compute_array_depth();
        this.propagate_array_constraints();
        this.debug_vars("arrays");
        this.merge_primitive_types();
        this.debug_vars("primitive");
        this.merge_connected_components();
        this.debug_vars("components");
        this.remove_transitive_constraints();
        this.debug_vars("transitive");
        this.merge_single_constraints();
        this.debug_vars("single");
        this.assign_types_1_2();
        this.debug_vars("assign");
        this.check_constraints();
    }

    private void resolve_step_2() throws TypeException {
        this.debug_body();
        this.split_new();
        this.debug_body();
        this.collect_constraints_1_2();
        this.debug_vars("constraints");
        this.compute_array_depth();
        this.propagate_array_constraints();
        this.debug_vars("arrays");
        this.merge_primitive_types();
        this.debug_vars("primitive");
        this.merge_connected_components();
        this.debug_vars("components");
        this.remove_transitive_constraints();
        this.debug_vars("transitive");
        this.merge_single_constraints();
        this.debug_vars("single");
        this.assign_types_1_2();
        this.debug_vars("assign");
        this.check_constraints();
    }

    private void resolve_step_3() throws TypeException {
        this.collect_constraints_3();
        this.compute_approximate_types();
        this.assign_types_3();
        this.check_and_fix_constraints();
    }

    private void collect_constraints_1_2() {
        ConstraintCollectorBV collector = new ConstraintCollectorBV(this, true);
        for (Stmt stmt : this.stmtBody.getUnits()) {
            collector.collect(stmt, this.stmtBody);
        }
    }

    private void collect_constraints_3() {
        ConstraintCollectorBV collector = new ConstraintCollectorBV(this, false);
        for (Stmt stmt : this.stmtBody.getUnits()) {
            collector.collect(stmt, this.stmtBody);
        }
    }

    private void compute_array_depth() throws TypeException {
        this.compute_approximate_types();
        TypeVariableBV[] vars = new TypeVariableBV[this.typeVariableList.size()];
        for (TypeVariableBV element2 : vars = this.typeVariableList.toArray(vars)) {
            element2.fixDepth();
        }
    }

    private void propagate_array_constraints() {
        int max2 = 0;
        for (TypeVariableBV var : this.typeVariableList) {
            int depth = var.depth();
            if (depth <= max2) continue;
            max2 = depth;
        }
        if (max2 > 1 && !Options.v().j2me()) {
            this.typeVariable(ArrayType.v(RefType.v("java.lang.Cloneable"), max2 - 1));
            this.typeVariable(ArrayType.v(RefType.v("java.io.Serializable"), max2 - 1));
        }
        LinkedList[] lists = new LinkedList[max2 + 1];
        for (int i = 0; i <= max2; ++i) {
            lists[i] = new LinkedList();
        }
        for (TypeVariableBV var : this.typeVariableList) {
            int depth = var.depth();
            lists[depth].add(var);
        }
        for (int i = max2; i >= 0; --i) {
            for (TypeVariableBV var : this.typeVariableList) {
                var.propagate();
            }
        }
    }

    private void merge_primitive_types() throws TypeException {
        this.compute_solved();
        BitSetIterator varIt = this.solved.iterator();
        while (varIt.hasNext()) {
            boolean finished;
            TypeVariableBV var = this.typeVariableForId(varIt.next());
            if (!(var.type().type() instanceof IntType) && !(var.type().type() instanceof LongType) && !(var.type().type() instanceof FloatType) && !(var.type().type() instanceof DoubleType)) continue;
            do {
                BitVector children2;
                BitSetIterator j;
                finished = true;
                BitVector parents = var.parents();
                if (parents.length() != 0) {
                    finished = false;
                    j = parents.iterator();
                    while (j.hasNext()) {
                        TypeVariableBV parent = this.typeVariableForId(j.next());
                        var = var.union(parent);
                    }
                }
                if ((children2 = var.children()).length() == 0) continue;
                finished = false;
                j = children2.iterator();
                while (j.hasNext()) {
                    TypeVariableBV child = this.typeVariableForId(j.next());
                    var = var.union(child);
                }
            } while (!finished);
        }
    }

    private void merge_connected_components() throws TypeException {
        this.refresh_solved();
        BitVector list = new BitVector();
        list.or(this.solved);
        list.or(this.unsolved);
        new StronglyConnectedComponentsBV(list, this);
    }

    private void remove_transitive_constraints() throws TypeException {
        this.refresh_solved();
        BitVector list = new BitVector();
        list.or(this.solved);
        list.or(this.unsolved);
        BitSetIterator varIt = list.iterator();
        while (varIt.hasNext()) {
            TypeVariableBV var = this.typeVariableForId(varIt.next());
            var.removeIndirectRelations();
        }
    }

    /*
     * Exception decompiling
     */
    private void merge_single_constraints() throws TypeException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[UNCONDITIONALDOLOOP]], but top level block is 9[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void assign_types_1_2() throws TypeException {
        for (Local local : this.stmtBody.getLocals()) {
            TypeVariableBV var = this.typeVariable(local);
            if (var == null) {
                local.setType(RefType.v("java.lang.Object"));
                continue;
            }
            if (var.depth() == 0) {
                if (var.type() == null) {
                    TypeVariableBV.error("Type Error(5):  Variable without type");
                    continue;
                }
                local.setType(var.type().type());
                continue;
            }
            TypeVariableBV element2 = var.element();
            for (int j = 1; j < var.depth(); ++j) {
                element2 = element2.element();
            }
            if (element2.type() == null) {
                TypeVariableBV.error("Type Error(6):  Array variable without base type");
                continue;
            }
            if (element2.type().type() instanceof NullType) {
                local.setType(NullType.v());
                continue;
            }
            Type t = element2.type().type();
            if (t instanceof IntType) {
                local.setType(var.approx().type());
                continue;
            }
            local.setType(ArrayType.v(t, var.depth()));
        }
    }

    private void assign_types_3() throws TypeException {
        for (Local local : this.stmtBody.getLocals()) {
            TypeVariableBV var = this.typeVariable(local);
            if (var == null || var.approx() == null || var.approx().type() == null) {
                local.setType(RefType.v("java.lang.Object"));
                continue;
            }
            local.setType(var.approx().type());
        }
    }

    private void check_constraints() throws TypeException {
        ConstraintCheckerBV checker = new ConstraintCheckerBV(this, false);
        Object s2 = null;
        for (Stmt stmt : this.stmtBody.getUnits()) {
            checker.check(stmt, this.stmtBody);
        }
    }

    private void check_and_fix_constraints() throws TypeException {
        ConstraintCheckerBV checker = new ConstraintCheckerBV(this, true);
        Object s2 = null;
        PatchingChain<Unit> units = this.stmtBody.getUnits();
        Stmt[] stmts = new Stmt[units.size()];
        units.toArray(stmts);
        for (Stmt stmt : stmts) {
            checker.check(stmt, this.stmtBody);
        }
    }

    private void compute_approximate_types() throws TypeException {
        TreeSet<TypeVariableBV> workList = new TreeSet<TypeVariableBV>();
        for (TypeVariableBV var : this.typeVariableList) {
            if (var.type() == null) continue;
            workList.add(var);
        }
        TypeVariableBV.computeApprox(workList);
        for (TypeVariableBV var : this.typeVariableList) {
            if (var.approx() == this.NULL) {
                var.union(this.typeVariable(this.NULL));
                continue;
            }
            if (var.approx() != null) continue;
            var.union(this.typeVariable(this.NULL));
        }
    }

    private void compute_solved() {
        this.unsolved = new BitVector();
        this.solved = new BitVector();
        for (TypeVariableBV var : this.typeVariableList) {
            if (var.depth() != 0) continue;
            if (var.type() == null) {
                this.unsolved.set(var.id());
                continue;
            }
            this.solved.set(var.id());
        }
    }

    private void refresh_solved() throws TypeException {
        this.unsolved = new BitVector();
        BitSetIterator varIt = this.unsolved.iterator();
        while (varIt.hasNext()) {
            TypeVariableBV var = this.typeVariableForId(varIt.next());
            if (var.depth() != 0) continue;
            if (var.type() == null) {
                this.unsolved.set(var.id());
                continue;
            }
            this.solved.set(var.id());
        }
    }

    private void categorize() throws TypeException {
        this.refresh_solved();
        this.single_soft_parent = new BitVector();
        this.single_hard_parent = new BitVector();
        this.multiple_parents = new BitVector();
        this.single_child_not_null = new BitVector();
        this.single_null_child = new BitVector();
        this.multiple_children = new BitVector();
        BitSetIterator i = this.unsolved.iterator();
        while (i.hasNext()) {
            TypeVariableBV var = this.typeVariableForId(i.next());
            BitVector parents = var.parents();
            int size2 = parents.length();
            if (size2 == 0) {
                var.addParent(this.typeVariable(this.OBJECT));
                this.single_soft_parent.set(var.id());
            } else if (size2 == 1) {
                TypeVariableBV parent = this.typeVariableForId(parents.iterator().next());
                if (parent.type() == null) {
                    this.single_soft_parent.set(var.id());
                } else {
                    this.single_hard_parent.set(var.id());
                }
            } else {
                this.multiple_parents.set(var.id());
            }
            BitVector children2 = var.children();
            size2 = children2.size();
            if (size2 == 0) {
                var.addChild(this.typeVariable(this.NULL));
                this.single_null_child.set(var.id());
                continue;
            }
            if (size2 == 1) {
                TypeVariableBV child = this.typeVariableForId(children2.iterator().next());
                if (child.type() == this.NULL) {
                    this.single_null_child.set(var.id());
                    continue;
                }
                this.single_child_not_null.set(var.id());
                continue;
            }
            this.multiple_children.set(var.id());
        }
    }

    private void split_new() {
        LocalDefs defs = LocalDefs.Factory.newLocalDefs(this.stmtBody);
        PatchingChain<Unit> units = this.stmtBody.getUnits();
        Stmt[] stmts = new Stmt[units.size()];
        units.toArray(stmts);
        block0: for (Stmt stmt : stmts) {
            Stmt stmt2;
            SpecialInvokeExpr special;
            InvokeStmt invoke;
            if (!(stmt instanceof InvokeStmt) || !((invoke = (InvokeStmt)stmt).getInvokeExpr() instanceof SpecialInvokeExpr) || !(special = (SpecialInvokeExpr)invoke.getInvokeExpr()).getMethodRef().name().equals("<init>")) continue;
            List<Unit> deflist = defs.getDefsOfAt((Local)special.getBase(), invoke);
            while (deflist.size() == 1 && (stmt2 = (Stmt)deflist.get(0)) instanceof AssignStmt) {
                AssignStmt assign = (AssignStmt)stmt2;
                if (assign.getRightOp() instanceof Local) {
                    deflist = defs.getDefsOfAt((Local)assign.getRightOp(), assign);
                    continue;
                }
                if (!(assign.getRightOp() instanceof NewExpr)) continue block0;
                Local newlocal = Jimple.v().newLocal("tmp", null);
                this.stmtBody.getLocals().add(newlocal);
                special.setBase(newlocal);
                units.insertAfter(Jimple.v().newAssignStmt(assign.getLeftOp(), newlocal), (Unit)assign);
                assign.setLeftOp(newlocal);
                continue block0;
            }
        }
    }

    public TypeVariableBV typeVariableForId(int idx) {
        return this.typeVariableList.get(idx);
    }

    public BitVector invalidIds() {
        return this.invalidIds;
    }

    public void invalidateId(int id) {
        this.invalidIds.set(id);
    }
}

