/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.mhp;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.jimple.toolkits.thread.mhp.PegGraph;
import soot.jimple.toolkits.thread.mhp.stmt.JPegStmt;
import soot.tagkit.Tag;
import soot.util.Chain;
import soot.util.dot.DotGraph;
import soot.util.dot.DotGraphEdge;
import soot.util.dot.DotGraphNode;

public class PegToDotFile {
    public static final int UNITGRAPH = 0;
    public static final int BLOCKGRAPH = 1;
    public static final int ARRAYBLOCK = 2;
    public static int graphtype = 0;
    public static boolean isBrief = false;
    private static final Map<Object, String> listNodeName = new HashMap<Object, String>();
    private static final Map<Object, String> startNodeToName = new HashMap<Object, String>();
    public static boolean onepage = true;
    private static int nodecount = 0;

    public PegToDotFile(PegGraph graph, boolean onepage, String name) {
        PegToDotFile.onepage = onepage;
        PegToDotFile.toDotFile(name, graph, "PEG graph");
    }

    public static void toDotFile(String methodname, PegGraph graph, String graphname) {
        int sequence2 = 0;
        nodecount = 0;
        Hashtable<Object, Integer> nodeindex = new Hashtable<Object, Integer>(graph.size());
        DotGraph canvas = new DotGraph(methodname);
        if (!onepage) {
            canvas.setPageSize(8.5, 11.0);
        }
        canvas.setNodeShape("box");
        canvas.setGraphLabel(graphname);
        for (Object node : graph) {
            if (!(node instanceof List)) continue;
            String listName = "list" + new Integer(sequence2++).toString();
            String nodeName = PegToDotFile.makeNodeName(PegToDotFile.getNodeOrder(nodeindex, listName));
            listNodeName.put(node, listName);
        }
        Iterator<Object> nodesIt = graph.mainIterator();
        while (nodesIt.hasNext()) {
            Object node;
            node = nodesIt.next();
            String nodeName = null;
            if (node instanceof List) {
                nodeName = PegToDotFile.makeNodeName(PegToDotFile.getNodeOrder(nodeindex, listNodeName.get(node)));
            } else {
                Tag tag = ((JPegStmt)node).getTags().get(0);
                nodeName = PegToDotFile.makeNodeName(PegToDotFile.getNodeOrder(nodeindex, tag + " " + node));
                if (((JPegStmt)node).getName().equals("start")) {
                    startNodeToName.put(node, nodeName);
                }
            }
            for (Object s2 : graph.getSuccsOf(node)) {
                String succName = null;
                if (s2 instanceof List) {
                    succName = PegToDotFile.makeNodeName(PegToDotFile.getNodeOrder(nodeindex, listNodeName.get(s2)));
                } else {
                    JPegStmt succ = (JPegStmt)s2;
                    Tag succTag = succ.getTags().get(0);
                    succName = PegToDotFile.makeNodeName(PegToDotFile.getNodeOrder(nodeindex, succTag + " " + succ));
                }
                canvas.drawEdge(nodeName, succName);
            }
        }
        System.out.println("Drew main chain");
        System.out.println("while printing, startToThread has size " + graph.getStartToThread().size());
        Set<Map.Entry<JPegStmt, List>> maps = graph.getStartToThread().entrySet();
        System.out.println("maps has size " + maps.size());
        for (Map.Entry<JPegStmt, List> entry2 : maps) {
            JPegStmt startNode = entry2.getKey();
            System.out.println("startNode is: " + startNode);
            String startNodeName = startNodeToName.get(startNode);
            System.out.println("startNodeName is: " + startNodeName);
            List runMethodChainList = entry2.getValue();
            for (Chain chain2 : runMethodChainList) {
                Iterator subNodesIt = chain2.iterator();
                boolean firstNode = false;
                while (subNodesIt.hasNext()) {
                    Object node = subNodesIt.next();
                    String nodeName = null;
                    if (node instanceof List) {
                        nodeName = PegToDotFile.makeNodeName(PegToDotFile.getNodeOrder(nodeindex, listNodeName.get(node)));
                        System.out.println("Didn't draw list node");
                    } else {
                        if (((JPegStmt)node).getName().equals("begin")) {
                            firstNode = true;
                        }
                        Tag tag = ((JPegStmt)node).getTags().get(0);
                        nodeName = PegToDotFile.makeNodeName(PegToDotFile.getNodeOrder(nodeindex, tag + " " + node));
                        if (((JPegStmt)node).getName().equals("start")) {
                            startNodeToName.put(node, nodeName);
                        }
                        if (firstNode) {
                            if (startNodeName == null) {
                                System.out.println("00000000startNodeName is null ");
                            }
                            if (nodeName == null) {
                                System.out.println("00000000nodeName is null ");
                            }
                            DotGraphEdge startThreadEdge = canvas.drawEdge(startNodeName, nodeName);
                            startThreadEdge.setStyle("dotted");
                            firstNode = false;
                        }
                    }
                    for (Object succ : graph.getSuccsOf(node)) {
                        String threadNodeName = null;
                        if (succ instanceof List) {
                            threadNodeName = PegToDotFile.makeNodeName(PegToDotFile.getNodeOrder(nodeindex, listNodeName.get(succ)));
                        } else {
                            JPegStmt succStmt = (JPegStmt)succ;
                            Tag succTag = succStmt.getTags().get(0);
                            threadNodeName = PegToDotFile.makeNodeName(PegToDotFile.getNodeOrder(nodeindex, succTag + " " + succStmt));
                        }
                        canvas.drawEdge(nodeName, threadNodeName);
                    }
                }
            }
        }
        if (!isBrief) {
            for (Object node : nodeindex.keySet()) {
                String nodename = PegToDotFile.makeNodeName(PegToDotFile.getNodeOrder(nodeindex, node));
                DotGraphNode dotnode = canvas.getNode(nodename);
                dotnode.setLabel(node.toString());
            }
        }
        canvas.plot("peg.dot");
        listNodeName.clear();
        startNodeToName.clear();
    }

    private static int getNodeOrder(Hashtable<Object, Integer> nodeindex, Object node) {
        if (node == null) {
            System.out.println("----node is null-----");
            return 0;
        }
        Integer index = nodeindex.get(node);
        if (index == null) {
            index = new Integer(nodecount++);
            nodeindex.put(node, index);
        }
        return index;
    }

    private static String makeNodeName(int index) {
        return "N" + index;
    }
}

