/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.mhp;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import soot.jimple.toolkits.thread.mhp.DominatorsFinder;
import soot.jimple.toolkits.thread.mhp.stmt.JPegStmt;
import soot.tagkit.Tag;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.scalar.FlowSet;
import soot.util.Chain;

public class DfsForBackEdge {
    private final Map<Object, Object> backEdges = new HashMap<Object, Object>();
    private final Set<Object> gray = new HashSet<Object>();
    private final Set<Object> black = new HashSet<Object>();
    private final DominatorsFinder domFinder;

    DfsForBackEdge(Chain chain2, DirectedGraph peg) {
        this.domFinder = new DominatorsFinder(chain2, peg);
        Iterator it = chain2.iterator();
        this.dfs(it, peg);
        this.testBackEdge();
    }

    private void dfs(Iterator it, DirectedGraph g) {
        while (it.hasNext()) {
            Object s2 = it.next();
            if (this.gray.contains(s2)) continue;
            this.visitNode(g, s2);
        }
    }

    private void visitNode(DirectedGraph g, Object s2) {
        this.gray.add(s2);
        Iterator<Object> it = g.getSuccsOf(s2).iterator();
        if (g.getSuccsOf(s2).size() > 0) {
            while (it.hasNext()) {
                FlowSet dominators;
                Object succ = it.next();
                if (!this.gray.contains(succ)) {
                    this.visitNode(g, succ);
                    continue;
                }
                if (!this.gray.contains(succ) || this.black.contains(succ) || !(dominators = this.domFinder.getDominatorsOf(s2)).contains(succ)) continue;
                System.out.println("s is " + s2);
                System.out.println("succ is " + succ);
                this.backEdges.put(s2, succ);
            }
        }
        this.black.add(s2);
    }

    protected Map<Object, Object> getBackEdges() {
        return this.backEdges;
    }

    private void testBackEdge() {
        System.out.println("===test backEdges==");
        Set<Map.Entry<Object, Object>> maps = this.backEdges.entrySet();
        for (Map.Entry<Object, Object> entry2 : maps) {
            JPegStmt key2 = (JPegStmt)entry2.getKey();
            Tag tag = key2.getTags().get(0);
            System.out.println("---key=  " + tag + " " + key2);
            JPegStmt value2 = (JPegStmt)entry2.getValue();
            Tag tag1 = value2.getTags().get(0);
            System.out.println("---value=  " + tag1 + " " + value2);
        }
        System.out.println("===test backEdges==end==");
    }
}

