/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread;

import soot.IntType;
import soot.RefLikeType;
import soot.Type;
import soot.jimple.FieldRef;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.toolkits.graph.UnitGraph;

public class EncapsulatedMethodAnalysis {
    boolean isMethodPure = true;
    boolean isMethodConditionallyPure = true;

    public EncapsulatedMethodAnalysis(UnitGraph g) {
        for (Stmt s2 : g) {
            FieldRef ref;
            if (!s2.containsFieldRef() || !((ref = s2.getFieldRef()) instanceof StaticFieldRef) || !(Type.toMachineType(((StaticFieldRef)ref).getType()) instanceof RefLikeType)) continue;
            this.isMethodPure = false;
            this.isMethodConditionallyPure = false;
            return;
        }
        for (Type paramType : g.getBody().getMethod().getParameterTypes()) {
            if (Type.toMachineType(paramType) == IntType.v()) continue;
            this.isMethodPure = false;
            return;
        }
    }

    public boolean isPure() {
        return this.isMethodPure;
    }

    public boolean isConditionallyPure() {
        return this.isMethodConditionallyPure;
    }
}

