/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import soot.EquivalentValue;
import soot.Local;
import soot.Value;
import soot.ValueBox;
import soot.jimple.DefinitionStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.Stmt;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardFlowAnalysis;

public class EqualLocalsAnalysis
extends ForwardFlowAnalysis {
    Local l = null;
    Stmt s = null;

    public EqualLocalsAnalysis(UnitGraph g) {
        super(g);
    }

    public List getCopiesOfAt(Local l, Stmt s2) {
        this.l = l;
        this.s = s2;
        this.doAnalysis();
        FlowSet fs = (FlowSet)this.getFlowBefore(s2);
        ArrayList aliasList = new ArrayList(fs.size());
        for (Object o : fs) {
            aliasList.add(o);
        }
        if (aliasList.contains(new EquivalentValue(l))) {
            return aliasList;
        }
        return new ArrayList();
    }

    @Override
    protected void merge(Object in1, Object in2, Object out) {
        FlowSet inSet1 = (FlowSet)in1;
        FlowSet inSet2 = (FlowSet)in2;
        FlowSet outSet = (FlowSet)out;
        inSet1.intersection(inSet2, outSet);
    }

    @Override
    protected void flowThrough(Object inValue, Object unit, Object outValue) {
        FlowSet in = (FlowSet)inValue;
        FlowSet out = (FlowSet)outValue;
        Stmt stmt = (Stmt)unit;
        in.copy(out);
        ArrayList<EquivalentValue> newDefs = new ArrayList<EquivalentValue>();
        Iterator<ValueBox> newDefBoxesIt = stmt.getDefBoxes().iterator();
        while (newDefBoxesIt.hasNext()) {
            newDefs.add(new EquivalentValue(newDefBoxesIt.next().getValue()));
        }
        if (newDefs.contains(new EquivalentValue(this.l))) {
            ArrayList existingDefStmts = new ArrayList();
            for (Object o : out) {
                if (!(o instanceof Stmt)) continue;
                existingDefStmts.add(o);
            }
            out.clear();
            Iterator newDefsIt = newDefs.iterator();
            while (newDefsIt.hasNext()) {
                out.add(newDefsIt.next());
            }
            if (stmt instanceof DefinitionStmt && !stmt.containsInvokeExpr() && !(stmt instanceof IdentityStmt)) {
                out.add(new EquivalentValue(((DefinitionStmt)stmt).getRightOp()));
            }
            for (Stmt s2 : existingDefStmts) {
                Iterator sNewDefsIt;
                ArrayList<Value> sNewDefs = new ArrayList<Value>();
                Iterator<ValueBox> sNewDefBoxesIt = s2.getDefBoxes().iterator();
                while (sNewDefBoxesIt.hasNext()) {
                    sNewDefs.add(sNewDefBoxesIt.next().getValue());
                }
                if (!(s2 instanceof DefinitionStmt)) continue;
                if (out.contains(new EquivalentValue(((DefinitionStmt)s2).getRightOp()))) {
                    sNewDefsIt = sNewDefs.iterator();
                    while (sNewDefsIt.hasNext()) {
                        out.add(new EquivalentValue((Value)sNewDefsIt.next()));
                    }
                    continue;
                }
                sNewDefsIt = sNewDefs.iterator();
                while (sNewDefsIt.hasNext()) {
                    out.remove(new EquivalentValue((Value)sNewDefsIt.next()));
                }
            }
        } else if (stmt instanceof DefinitionStmt) {
            if (out.contains(new EquivalentValue(this.l))) {
                if (out.contains(new EquivalentValue(((DefinitionStmt)stmt).getRightOp()))) {
                    Iterator newDefsIt = newDefs.iterator();
                    while (newDefsIt.hasNext()) {
                        out.add(newDefsIt.next());
                    }
                } else {
                    Iterator newDefsIt = newDefs.iterator();
                    while (newDefsIt.hasNext()) {
                        out.remove(newDefsIt.next());
                    }
                }
            } else {
                out.add(stmt);
            }
        }
    }

    @Override
    protected void copy(Object source, Object dest) {
        FlowSet sourceSet = (FlowSet)source;
        FlowSet destSet = (FlowSet)dest;
        sourceSet.copy(destSet);
    }

    @Override
    protected Object entryInitialFlow() {
        return new ArraySparseSet();
    }

    @Override
    protected Object newInitialFlow() {
        return new ArraySparseSet();
    }
}

