/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.reflection;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.ArrayType;
import soot.Body;
import soot.BooleanType;
import soot.Local;
import soot.PatchingChain;
import soot.PhaseOptions;
import soot.PrimType;
import soot.RefLikeType;
import soot.RefType;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.SootField;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.VoidType;
import soot.javaToJimple.LocalGenerator;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.ClassConstant;
import soot.jimple.FieldRef;
import soot.jimple.GotoStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.IntConstant;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NopStmt;
import soot.jimple.NullConstant;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.toolkits.reflection.ReflectionTraceInfo;
import soot.jimple.toolkits.scalar.CopyPropagator;
import soot.jimple.toolkits.scalar.DeadAssignmentEliminator;
import soot.jimple.toolkits.scalar.NopEliminator;
import soot.options.CGOptions;
import soot.options.Options;
import soot.rtlib.tamiflex.DefaultHandler;
import soot.rtlib.tamiflex.IUnexpectedReflectiveCallHandler;
import soot.rtlib.tamiflex.OpaquePredicate;
import soot.rtlib.tamiflex.ReflectiveCalls;
import soot.rtlib.tamiflex.SootSig;
import soot.rtlib.tamiflex.UnexpectedReflectiveCall;
import soot.toolkits.scalar.UnusedLocalEliminator;
import soot.util.Chain;
import soot.util.HashChain;

public class ReflectiveCallsInliner
extends SceneTransformer {
    private final boolean useCaching = false;
    private static final String ALREADY_CHECKED_FIELDNAME = "SOOT$Reflection$alreadyChecked";
    private ReflectionTraceInfo RTI;
    private SootMethodRef UNINTERPRETED_METHOD;
    private boolean initialized = false;
    private int callSiteId;
    private int callNum;
    private SootClass reflectiveCallsClass;
    private static final List<String> fieldSets = Arrays.asList("set", "setBoolean", "setByte", "setChar", "setInt", "setLong", "setFloat", "setDouble", "setShort");
    private static final List<String> fieldGets = Arrays.asList("get", "getBoolean", "getByte", "getChar", "getInt", "getLong", "getFloat", "getDouble", "getShort");

    protected void internalTransform(String phaseName, Map options) {
        if (!this.initialized) {
            CGOptions cgOptions = new CGOptions(PhaseOptions.v().getPhaseOptions("cg"));
            String logFilePath = cgOptions.reflection_log();
            this.RTI = new ReflectionTraceInfo(logFilePath);
            Scene.v().getSootClass(SootSig.class.getName()).setApplicationClass();
            Scene.v().getSootClass(UnexpectedReflectiveCall.class.getName()).setApplicationClass();
            Scene.v().getSootClass(IUnexpectedReflectiveCallHandler.class.getName()).setApplicationClass();
            Scene.v().getSootClass(DefaultHandler.class.getName()).setApplicationClass();
            Scene.v().getSootClass(OpaquePredicate.class.getName()).setApplicationClass();
            Scene.v().getSootClass(ReflectiveCalls.class.getName()).setApplicationClass();
            this.reflectiveCallsClass = new SootClass("soot.rtlib.tamiflex.ReflectiveCallsWrapper", 1);
            Scene.v().addClass(this.reflectiveCallsClass);
            this.reflectiveCallsClass.setApplicationClass();
            this.UNINTERPRETED_METHOD = Scene.v().makeMethodRef(Scene.v().getSootClass("soot.rtlib.tamiflex.OpaquePredicate"), "getFalse", Collections.emptyList(), BooleanType.v(), true);
            this.initializeReflectiveCallsTable();
            this.callSiteId = 0;
            this.callNum = 0;
            this.initialized = true;
        }
        for (SootMethod m : this.RTI.methodsContainingReflectiveCalls()) {
            Set<String> fieldGetSignatures;
            Set<String> fieldSetSignatures;
            Set<String> methodInvokeSignatures;
            Set<String> constructorNewInstanceSignatures;
            Set<String> classNewInstanceClassNames;
            m.retrieveActiveBody();
            Body b = m.getActiveBody();
            Set<String> classForNameClassNames = this.RTI.classForNameClassNames(m);
            if (!classForNameClassNames.isEmpty()) {
                this.inlineRelectiveCalls(m, classForNameClassNames, ReflectionTraceInfo.Kind.ClassForName);
                if (Options.v().validate()) {
                    b.validate();
                }
            }
            if (!(classNewInstanceClassNames = this.RTI.classNewInstanceClassNames(m)).isEmpty()) {
                this.inlineRelectiveCalls(m, classNewInstanceClassNames, ReflectionTraceInfo.Kind.ClassNewInstance);
                if (Options.v().validate()) {
                    b.validate();
                }
            }
            if (!(constructorNewInstanceSignatures = this.RTI.constructorNewInstanceSignatures(m)).isEmpty()) {
                this.inlineRelectiveCalls(m, constructorNewInstanceSignatures, ReflectionTraceInfo.Kind.ConstructorNewInstance);
                if (Options.v().validate()) {
                    b.validate();
                }
            }
            if (!(methodInvokeSignatures = this.RTI.methodInvokeSignatures(m)).isEmpty()) {
                this.inlineRelectiveCalls(m, methodInvokeSignatures, ReflectionTraceInfo.Kind.MethodInvoke);
                if (Options.v().validate()) {
                    b.validate();
                }
            }
            if (!(fieldSetSignatures = this.RTI.fieldSetSignatures(m)).isEmpty()) {
                this.inlineRelectiveCalls(m, fieldSetSignatures, ReflectionTraceInfo.Kind.FieldSet);
                if (Options.v().validate()) {
                    b.validate();
                }
            }
            if (!(fieldGetSignatures = this.RTI.fieldGetSignatures(m)).isEmpty()) {
                this.inlineRelectiveCalls(m, fieldGetSignatures, ReflectionTraceInfo.Kind.FieldGet);
                if (Options.v().validate()) {
                    b.validate();
                }
            }
            this.cleanup(b);
        }
    }

    private void cleanup(Body b) {
        CopyPropagator.v().transform(b);
        DeadAssignmentEliminator.v().transform(b);
        UnusedLocalEliminator.v().transform(b);
        NopEliminator.v().transform(b);
    }

    private void initializeReflectiveCallsTable() {
        int callSiteId = 0;
        SootClass reflCallsClass = Scene.v().getSootClass("soot.rtlib.tamiflex.ReflectiveCalls");
        SootMethod clinit = reflCallsClass.getMethodByName("<clinit>");
        Body body = clinit.retrieveActiveBody();
        PatchingChain<Unit> units = body.getUnits();
        LocalGenerator localGen = new LocalGenerator(body);
        HashChain<Stmt> newUnits = new HashChain<Stmt>();
        SootClass setClass = Scene.v().getSootClass("java.util.Set");
        SootMethodRef addMethodRef = setClass.getMethodByName("add").makeRef();
        for (SootMethod m : this.RTI.methodsContainingReflectiveCalls()) {
            InterfaceInvokeExpr invokeExpr;
            Local setLocal;
            SootFieldRef fieldRef;
            if (!this.RTI.classForNameClassNames(m).isEmpty()) {
                fieldRef = Scene.v().makeFieldRef(reflCallsClass, "classForName", RefType.v("java.util.Set"), true);
                setLocal = localGen.generateLocal(RefType.v("java.util.Set"));
                newUnits.add(Jimple.v().newAssignStmt(setLocal, Jimple.v().newStaticFieldRef(fieldRef)));
                for (String className : this.RTI.classForNameClassNames(m)) {
                    invokeExpr = Jimple.v().newInterfaceInvokeExpr(setLocal, addMethodRef, (Value)StringConstant.v(callSiteId + className));
                    newUnits.add(Jimple.v().newInvokeStmt(invokeExpr));
                }
                ++callSiteId;
            }
            if (!this.RTI.classNewInstanceClassNames(m).isEmpty()) {
                fieldRef = Scene.v().makeFieldRef(reflCallsClass, "classNewInstance", RefType.v("java.util.Set"), true);
                setLocal = localGen.generateLocal(RefType.v("java.util.Set"));
                newUnits.add(Jimple.v().newAssignStmt(setLocal, Jimple.v().newStaticFieldRef(fieldRef)));
                for (String className : this.RTI.classNewInstanceClassNames(m)) {
                    invokeExpr = Jimple.v().newInterfaceInvokeExpr(setLocal, addMethodRef, (Value)StringConstant.v(callSiteId + className));
                    newUnits.add(Jimple.v().newInvokeStmt(invokeExpr));
                }
                ++callSiteId;
            }
            if (!this.RTI.constructorNewInstanceSignatures(m).isEmpty()) {
                fieldRef = Scene.v().makeFieldRef(reflCallsClass, "constructorNewInstance", RefType.v("java.util.Set"), true);
                setLocal = localGen.generateLocal(RefType.v("java.util.Set"));
                newUnits.add(Jimple.v().newAssignStmt(setLocal, Jimple.v().newStaticFieldRef(fieldRef)));
                for (String constrSig : this.RTI.constructorNewInstanceSignatures(m)) {
                    invokeExpr = Jimple.v().newInterfaceInvokeExpr(setLocal, addMethodRef, (Value)StringConstant.v(callSiteId + constrSig));
                    newUnits.add(Jimple.v().newInvokeStmt(invokeExpr));
                }
                ++callSiteId;
            }
            if (this.RTI.methodInvokeSignatures(m).isEmpty()) continue;
            fieldRef = Scene.v().makeFieldRef(reflCallsClass, "methodInvoke", RefType.v("java.util.Set"), true);
            setLocal = localGen.generateLocal(RefType.v("java.util.Set"));
            newUnits.add(Jimple.v().newAssignStmt(setLocal, Jimple.v().newStaticFieldRef(fieldRef)));
            for (String methodSig : this.RTI.methodInvokeSignatures(m)) {
                invokeExpr = Jimple.v().newInterfaceInvokeExpr(setLocal, addMethodRef, (Value)StringConstant.v(callSiteId + methodSig));
                newUnits.add(Jimple.v().newInvokeStmt(invokeExpr));
            }
            ++callSiteId;
        }
        Unit secondLastStmt = units.getPredOf((Unit)units.getLast());
        units.insertAfter(newUnits, secondLastStmt);
        if (Options.v().validate()) {
            body.validate();
        }
    }

    private void addCaching() {
        SootClass method = Scene.v().getSootClass("java.lang.reflect.Method");
        method.addField(new SootField(ALREADY_CHECKED_FIELDNAME, BooleanType.v()));
        SootClass constructor = Scene.v().getSootClass("java.lang.reflect.Constructor");
        constructor.addField(new SootField(ALREADY_CHECKED_FIELDNAME, BooleanType.v()));
        SootClass clazz = Scene.v().getSootClass("java.lang.Class");
        clazz.addField(new SootField(ALREADY_CHECKED_FIELDNAME, BooleanType.v()));
        for (ReflectionTraceInfo.Kind k : ReflectionTraceInfo.Kind.values()) {
            this.addCaching(k);
        }
    }

    private void addCaching(ReflectionTraceInfo.Kind kind) {
        String methodName;
        SootClass c;
        switch (kind) {
            case ClassNewInstance: {
                c = Scene.v().getSootClass("java.lang.Class");
                methodName = "knownClassNewInstance";
                break;
            }
            case ConstructorNewInstance: {
                c = Scene.v().getSootClass("java.lang.reflect.Constructor");
                methodName = "knownConstructorNewInstance";
                break;
            }
            case MethodInvoke: {
                c = Scene.v().getSootClass("java.lang.reflect.Method");
                methodName = "knownMethodInvoke";
                break;
            }
            case ClassForName: {
                return;
            }
            default: {
                throw new IllegalStateException("unknown kind: " + (Object)((Object)kind));
            }
        }
        SootClass reflCallsClass = Scene.v().getSootClass("soot.rtlib.tamiflex.ReflectiveCalls");
        SootMethod m = reflCallsClass.getMethodByName(methodName);
        JimpleBody body = (JimpleBody)m.retrieveActiveBody();
        LocalGenerator localGen = new LocalGenerator(body);
        Unit firstStmt = body.getFirstNonIdentityStmt();
        firstStmt = body.getUnits().getPredOf(firstStmt);
        NopStmt jumpTarget = Jimple.v().newNopStmt();
        HashChain<Stmt> newUnits = new HashChain<Stmt>();
        InstanceFieldRef fieldRef = Jimple.v().newInstanceFieldRef(body.getParameterLocal(m.getParameterCount() - 1), Scene.v().makeFieldRef(c, ALREADY_CHECKED_FIELDNAME, BooleanType.v(), false));
        Local alreadyCheckedLocal = localGen.generateLocal(BooleanType.v());
        newUnits.add(Jimple.v().newAssignStmt(alreadyCheckedLocal, fieldRef));
        newUnits.add(Jimple.v().newIfStmt((Value)Jimple.v().newEqExpr(alreadyCheckedLocal, IntConstant.v(0)), jumpTarget));
        newUnits.add(Jimple.v().newReturnVoidStmt());
        newUnits.add(jumpTarget);
        InstanceFieldRef fieldRef2 = Jimple.v().newInstanceFieldRef(body.getParameterLocal(m.getParameterCount() - 1), Scene.v().makeFieldRef(c, ALREADY_CHECKED_FIELDNAME, BooleanType.v(), false));
        newUnits.add(Jimple.v().newAssignStmt(fieldRef2, IntConstant.v(1)));
        body.getUnits().insertAfter(newUnits, firstStmt);
        if (Options.v().validate()) {
            body.validate();
        }
    }

    private void inlineRelectiveCalls(SootMethod m, Set<String> targets, ReflectionTraceInfo.Kind callKind) {
        if (!m.hasActiveBody()) {
            m.retrieveActiveBody();
        }
        Body b = m.getActiveBody();
        PatchingChain<Unit> units = b.getUnits();
        Iterator<Unit> iter2 = units.snapshotIterator();
        LocalGenerator localGen = new LocalGenerator(b);
        while (iter2.hasNext()) {
            Value field2;
            SootMethod sootMethod;
            Object recv;
            HashChain<Stmt> newUnits = new HashChain<Stmt>();
            Stmt s2 = (Stmt)iter2.next();
            if (!s2.containsInvokeExpr()) continue;
            InvokeExpr ie = s2.getInvokeExpr();
            boolean found = false;
            Type fieldSetGetType = null;
            if (callKind == ReflectionTraceInfo.Kind.ClassForName && (ie.getMethodRef().getSignature().equals("<java.lang.Class: java.lang.Class forName(java.lang.String)>") || ie.getMethodRef().getSignature().equals("<java.lang.Class: java.lang.Class forName(java.lang.String,boolean,java.lang.ClassLoader)>"))) {
                found = true;
                Value classNameValue = ie.getArg(0);
                newUnits.add(Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(Scene.v().getMethod("<soot.rtlib.tamiflex.ReflectiveCalls: void knownClassForName(int,java.lang.String)>").makeRef(), IntConstant.v(this.callSiteId), classNameValue)));
            } else if (callKind == ReflectionTraceInfo.Kind.ClassNewInstance && ie.getMethodRef().getSignature().equals("<java.lang.Class: java.lang.Object newInstance()>")) {
                found = true;
                Local classLocal = (Local)((InstanceInvokeExpr)ie).getBase();
                newUnits.add(Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(Scene.v().getMethod("<soot.rtlib.tamiflex.ReflectiveCalls: void knownClassNewInstance(int,java.lang.Class)>").makeRef(), IntConstant.v(this.callSiteId), classLocal)));
            } else if (callKind == ReflectionTraceInfo.Kind.ConstructorNewInstance && ie.getMethodRef().getSignature().equals("<java.lang.reflect.Constructor: java.lang.Object newInstance(java.lang.Object[])>")) {
                found = true;
                Local constrLocal = (Local)((InstanceInvokeExpr)ie).getBase();
                newUnits.add(Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(Scene.v().getMethod("<soot.rtlib.tamiflex.ReflectiveCalls: void knownConstructorNewInstance(int,java.lang.reflect.Constructor)>").makeRef(), IntConstant.v(this.callSiteId), constrLocal)));
            } else if (callKind == ReflectionTraceInfo.Kind.MethodInvoke && ie.getMethodRef().getSignature().equals("<java.lang.reflect.Method: java.lang.Object invoke(java.lang.Object,java.lang.Object[])>")) {
                found = true;
                Local methodLocal = (Local)((InstanceInvokeExpr)ie).getBase();
                recv = ie.getArg(0);
                newUnits.add(Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(Scene.v().getMethod("<soot.rtlib.tamiflex.ReflectiveCalls: void knownMethodInvoke(int,java.lang.Object,java.lang.reflect.Method)>").makeRef(), new Value[]{IntConstant.v(this.callSiteId), recv, methodLocal})));
            } else if (callKind == ReflectionTraceInfo.Kind.FieldSet) {
                sootMethod = ie.getMethodRef().resolve();
                if (sootMethod.getDeclaringClass().getName().equals("java.lang.reflect.Field") && fieldSets.contains(sootMethod.getName())) {
                    found = true;
                    fieldSetGetType = sootMethod.getParameterType(1);
                    recv = ie.getArg(0);
                    field2 = ((InstanceInvokeExpr)ie).getBase();
                    newUnits.add(Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(Scene.v().getMethod("<soot.rtlib.tamiflex.ReflectiveCalls: void knownFieldSet(int,java.lang.Object,java.lang.reflect.Field)>").makeRef(), new Value[]{IntConstant.v(this.callSiteId), recv, field2})));
                }
            } else if (callKind == ReflectionTraceInfo.Kind.FieldGet && (sootMethod = ie.getMethodRef().resolve()).getDeclaringClass().getName().equals("java.lang.reflect.Field") && fieldGets.contains(sootMethod.getName())) {
                found = true;
                fieldSetGetType = sootMethod.getReturnType();
                recv = ie.getArg(0);
                field2 = ((InstanceInvokeExpr)ie).getBase();
                newUnits.add(Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(Scene.v().getMethod("<soot.rtlib.tamiflex.ReflectiveCalls: void knownFieldSet(int,java.lang.Object,java.lang.reflect.Field)>").makeRef(), new Value[]{IntConstant.v(this.callSiteId), recv, field2})));
            }
            if (!found) continue;
            NopStmt endLabel = Jimple.v().newNopStmt();
            for (String target : targets) {
                NopStmt jumpTarget = Jimple.v().newNopStmt();
                Local predLocal = localGen.generateLocal(BooleanType.v());
                StaticInvokeExpr staticInvokeExpr = Jimple.v().newStaticInvokeExpr(this.UNINTERPRETED_METHOD);
                newUnits.add(Jimple.v().newAssignStmt(predLocal, staticInvokeExpr));
                newUnits.add(Jimple.v().newIfStmt((Value)Jimple.v().newEqExpr(IntConstant.v(0), predLocal), jumpTarget));
                SootMethod newMethod = this.createNewMethod(callKind, target, fieldSetGetType);
                LinkedList<Value> args = new LinkedList<Value>();
                switch (callKind) {
                    case ClassNewInstance: 
                    case ClassForName: {
                        break;
                    }
                    case ConstructorNewInstance: {
                        args.add(ie.getArgs().get(0));
                        break;
                    }
                    case MethodInvoke: {
                        args.add(ie.getArgs().get(0));
                        args.add(ie.getArgs().get(1));
                        break;
                    }
                    case FieldSet: {
                        args.add(ie.getArgs().get(0));
                        args.add(ie.getArgs().get(1));
                        break;
                    }
                    case FieldGet: {
                        args.add(ie.getArgs().get(0));
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                StaticInvokeExpr methodInvokeExpr = Jimple.v().newStaticInvokeExpr(newMethod.makeRef(), args);
                Local retLocal = localGen.generateLocal(newMethod.getReturnType());
                newUnits.add(Jimple.v().newAssignStmt(retLocal, methodInvokeExpr));
                if (s2 instanceof AssignStmt) {
                    AssignStmt assignStmt = (AssignStmt)s2;
                    Value leftOp = assignStmt.getLeftOp();
                    AssignStmt newAssignStmt = Jimple.v().newAssignStmt(leftOp, retLocal);
                    newUnits.add(newAssignStmt);
                }
                GotoStmt gotoStmt = Jimple.v().newGotoStmt(endLabel);
                newUnits.add(gotoStmt);
                newUnits.add(jumpTarget);
            }
            Unit end = (Unit)newUnits.getLast();
            units.insertAfter(newUnits, (Unit)s2);
            units.remove(s2);
            units.insertAfter(s2, end);
            units.insertAfter(endLabel, (Unit)s2);
        }
        ++this.callSiteId;
    }

    private SootMethod createNewMethod(ReflectionTraceInfo.Kind callKind, String target, Type fieldSetGetType) {
        SootField field2;
        Local freshLocal;
        LinkedList<Type> parameterTypes = new LinkedList<Type>();
        Type returnType = null;
        switch (callKind) {
            case ClassForName: {
                returnType = RefType.v("java.lang.Class");
                break;
            }
            case ClassNewInstance: {
                returnType = RefType.v("java.lang.Object");
                break;
            }
            case ConstructorNewInstance: {
                parameterTypes.add(ArrayType.v(RefType.v("java.lang.Object"), 1));
                returnType = RefType.v("java.lang.Object");
                break;
            }
            case MethodInvoke: {
                parameterTypes.add(RefType.v("java.lang.Object"));
                parameterTypes.add(ArrayType.v(RefType.v("java.lang.Object"), 1));
                returnType = RefType.v("java.lang.Object");
                break;
            }
            case FieldSet: {
                parameterTypes.add(RefType.v("java.lang.Object"));
                parameterTypes.add(fieldSetGetType);
                returnType = VoidType.v();
                break;
            }
            case FieldGet: {
                parameterTypes.add(RefType.v("java.lang.Object"));
                returnType = fieldSetGetType;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        SootMethod newMethod = new SootMethod("reflectiveCall" + this.callNum++, parameterTypes, returnType, 9);
        JimpleBody newBody = Jimple.v().newBody(newMethod);
        newMethod.setActiveBody(newBody);
        this.reflectiveCallsClass.addMethod(newMethod);
        PatchingChain<Unit> newUnits = newBody.getUnits();
        LocalGenerator localGen = new LocalGenerator(newBody);
        Value replacement = null;
        Local[] paramLocals = null;
        switch (callKind) {
            case ClassForName: {
                freshLocal = localGen.generateLocal(RefType.v("java.lang.Class"));
                replacement = ClassConstant.v(target.replace('.', '/'));
                break;
            }
            case ClassNewInstance: {
                RefType targetType = RefType.v(target);
                freshLocal = localGen.generateLocal(targetType);
                replacement = Jimple.v().newNewExpr(targetType);
                break;
            }
            case ConstructorNewInstance: {
                SootMethod constructor = Scene.v().getMethod(target);
                paramLocals = new Local[constructor.getParameterCount()];
                if (constructor.getParameterCount() > 0) {
                    ArrayType arrayType = ArrayType.v(RefType.v("java.lang.Object"), 1);
                    Local argArrayLocal = localGen.generateLocal(arrayType);
                    newUnits.add(Jimple.v().newIdentityStmt(argArrayLocal, Jimple.v().newParameterRef(arrayType, 0)));
                    int i = 0;
                    for (Type paramType : constructor.getParameterTypes()) {
                        paramLocals[i] = localGen.generateLocal(paramType);
                        this.unboxParameter(argArrayLocal, i, paramLocals, paramType, newUnits, localGen);
                        ++i;
                    }
                }
                RefType targetType = constructor.getDeclaringClass().getType();
                freshLocal = localGen.generateLocal(targetType);
                replacement = Jimple.v().newNewExpr(targetType);
                break;
            }
            case MethodInvoke: {
                SootMethod method = Scene.v().getMethod(target);
                RefType objectType = RefType.v("java.lang.Object");
                Local recvObject = localGen.generateLocal(objectType);
                newUnits.add(Jimple.v().newIdentityStmt(recvObject, Jimple.v().newParameterRef(objectType, 0)));
                paramLocals = new Local[method.getParameterCount()];
                if (method.getParameterCount() > 0) {
                    ArrayType arrayType = ArrayType.v(RefType.v("java.lang.Object"), 1);
                    Local argArrayLocal = localGen.generateLocal(arrayType);
                    newUnits.add(Jimple.v().newIdentityStmt(argArrayLocal, Jimple.v().newParameterRef(arrayType, 1)));
                    int i = 0;
                    for (Type paramType : method.getParameterTypes()) {
                        paramLocals[i] = localGen.generateLocal(paramType);
                        this.unboxParameter(argArrayLocal, i, paramLocals, paramType, newUnits, localGen);
                        ++i;
                    }
                }
                RefType targetType = method.getDeclaringClass().getType();
                freshLocal = localGen.generateLocal(targetType);
                replacement = Jimple.v().newCastExpr(recvObject, method.getDeclaringClass().getType());
                break;
            }
            case FieldSet: 
            case FieldGet: {
                RefType objectType = RefType.v("java.lang.Object");
                Local recvObject = localGen.generateLocal(objectType);
                newUnits.add(Jimple.v().newIdentityStmt(recvObject, Jimple.v().newParameterRef(objectType, 0)));
                field2 = Scene.v().getField(target);
                freshLocal = localGen.generateLocal(field2.getDeclaringClass().getType());
                replacement = Jimple.v().newCastExpr(recvObject, field2.getDeclaringClass().getType());
                break;
            }
            default: {
                throw new InternalError("Unknown kind of reflective call " + (Object)((Object)callKind));
            }
        }
        AssignStmt replStmt = Jimple.v().newAssignStmt(freshLocal, replacement);
        newUnits.add(replStmt);
        Local retLocal = localGen.generateLocal(returnType);
        switch (callKind) {
            case ClassForName: {
                newUnits.add(Jimple.v().newAssignStmt(retLocal, freshLocal));
                break;
            }
            case ClassNewInstance: {
                SootClass targetClass = Scene.v().getSootClass(target);
                SpecialInvokeExpr constrCallExpr = Jimple.v().newSpecialInvokeExpr(freshLocal, Scene.v().makeMethodRef(targetClass, "<init>", Collections.emptyList(), VoidType.v(), false));
                InvokeStmt constrCallStmt2 = Jimple.v().newInvokeStmt(constrCallExpr);
                newUnits.add(constrCallStmt2);
                newUnits.add(Jimple.v().newAssignStmt(retLocal, freshLocal));
                break;
            }
            case ConstructorNewInstance: {
                SootMethod constructor = Scene.v().getMethod(target);
                SpecialInvokeExpr constrCallExpr = Jimple.v().newSpecialInvokeExpr(freshLocal, constructor.makeRef(), Arrays.asList(paramLocals));
                InvokeStmt constrCallStmt2 = Jimple.v().newInvokeStmt(constrCallExpr);
                newUnits.add(constrCallStmt2);
                newUnits.add(Jimple.v().newAssignStmt(retLocal, freshLocal));
                break;
            }
            case MethodInvoke: {
                SootMethod method = Scene.v().getMethod(target);
                InvokeExpr invokeExpr = method.isStatic() ? Jimple.v().newStaticInvokeExpr(method.makeRef(), Arrays.asList(paramLocals)) : Jimple.v().newVirtualInvokeExpr(freshLocal, method.makeRef(), Arrays.asList(paramLocals));
                if (method.getReturnType().equals(VoidType.v())) {
                    InvokeStmt invokeStmt = Jimple.v().newInvokeStmt(invokeExpr);
                    newUnits.add(invokeStmt);
                    AssignStmt assignStmt = Jimple.v().newAssignStmt(retLocal, NullConstant.v());
                    newUnits.add(assignStmt);
                    break;
                }
                AssignStmt assignStmt = Jimple.v().newAssignStmt(retLocal, invokeExpr);
                newUnits.add(assignStmt);
                break;
            }
            case FieldSet: {
                Local value2 = localGen.generateLocal(fieldSetGetType);
                newUnits.insertBeforeNoRedirect(Jimple.v().newIdentityStmt(value2, Jimple.v().newParameterRef(fieldSetGetType, 1)), replStmt);
                SootField field3 = Scene.v().getField(target);
                Local boxedOrCasted = localGen.generateLocal(field3.getType());
                this.insertCastOrUnboxingCode(boxedOrCasted, value2, newUnits);
                FieldRef fieldRef = field3.isStatic() ? Jimple.v().newStaticFieldRef(field3.makeRef()) : Jimple.v().newInstanceFieldRef(freshLocal, field3.makeRef());
                newUnits.add(Jimple.v().newAssignStmt(fieldRef, boxedOrCasted));
                break;
            }
            case FieldGet: {
                field2 = Scene.v().getField(target);
                Local value3 = localGen.generateLocal(field2.getType());
                FieldRef fieldRef = field2.isStatic() ? Jimple.v().newStaticFieldRef(field2.makeRef()) : Jimple.v().newInstanceFieldRef(freshLocal, field2.makeRef());
                newUnits.add(Jimple.v().newAssignStmt(value3, fieldRef));
                this.insertCastOrBoxingCode(retLocal, value3, newUnits);
                break;
            }
        }
        if (!returnType.equals(VoidType.v())) {
            newUnits.add(Jimple.v().newReturnStmt(retLocal));
        }
        if (Options.v().validate()) {
            ((Body)newBody).validate();
        }
        this.cleanup(newBody);
        return newMethod;
    }

    private void insertCastOrUnboxingCode(Local lhs, Local rhs, Chain<Unit> newUnits) {
        if (lhs.getType() instanceof PrimType) {
            if (rhs.getType() instanceof PrimType) {
                newUnits.add(Jimple.v().newAssignStmt(lhs, Jimple.v().newCastExpr(rhs, lhs.getType())));
            } else {
                RefType boxedType = (RefType)rhs.getType();
                SootMethodRef ref = Scene.v().makeMethodRef(boxedType.getSootClass(), lhs.getType().toString() + "Value", Collections.emptyList(), lhs.getType(), false);
                newUnits.add(Jimple.v().newAssignStmt(lhs, Jimple.v().newVirtualInvokeExpr(rhs, ref)));
            }
        }
    }

    private void insertCastOrBoxingCode(Local lhs, Local rhs, Chain<Unit> newUnits) {
        if (lhs.getType() instanceof RefLikeType) {
            if (rhs.getType() instanceof RefLikeType) {
                newUnits.add(Jimple.v().newAssignStmt(lhs, Jimple.v().newCastExpr(rhs, lhs.getType())));
            } else {
                RefType boxedType = ((PrimType)rhs.getType()).boxedType();
                SootMethodRef ref = Scene.v().makeMethodRef(boxedType.getSootClass(), "valueOf", Collections.singletonList(rhs.getType()), boxedType, true);
                newUnits.add(Jimple.v().newAssignStmt(lhs, Jimple.v().newStaticInvokeExpr(ref, (Value)rhs)));
            }
        }
    }

    private void unboxParameter(Local argsArrayLocal, int paramIndex, Local[] paramLocals, Type paramType, Chain<Unit> newUnits, LocalGenerator localGen) {
        AssignStmt assignStmt;
        ArrayRef arrayRef = Jimple.v().newArrayRef(argsArrayLocal, IntConstant.v(paramIndex));
        if (paramType instanceof PrimType) {
            PrimType primType = (PrimType)paramType;
            RefType boxedType = primType.boxedType();
            SootMethodRef ref = Scene.v().makeMethodRef(boxedType.getSootClass(), paramType + "Value", Collections.emptyList(), paramType, false);
            Local boxedLocal = localGen.generateLocal(RefType.v("java.lang.Object"));
            AssignStmt arrayLoad = Jimple.v().newAssignStmt(boxedLocal, arrayRef);
            newUnits.add(arrayLoad);
            Local castedLocal = localGen.generateLocal(boxedType);
            AssignStmt cast = Jimple.v().newAssignStmt(castedLocal, Jimple.v().newCastExpr(boxedLocal, boxedType));
            newUnits.add(cast);
            VirtualInvokeExpr unboxInvokeExpr = Jimple.v().newVirtualInvokeExpr(castedLocal, ref);
            assignStmt = Jimple.v().newAssignStmt(paramLocals[paramIndex], unboxInvokeExpr);
        } else {
            Local boxedLocal = localGen.generateLocal(RefType.v("java.lang.Object"));
            AssignStmt arrayLoad = Jimple.v().newAssignStmt(boxedLocal, arrayRef);
            newUnits.add(arrayLoad);
            Local castedLocal = localGen.generateLocal(paramType);
            AssignStmt cast = Jimple.v().newAssignStmt(castedLocal, Jimple.v().newCastExpr(boxedLocal, paramType));
            newUnits.add(cast);
            assignStmt = Jimple.v().newAssignStmt(paramLocals[paramIndex], castedLocal);
        }
        newUnits.add(assignStmt);
    }
}

