/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.pointer;

import java.util.HashSet;
import soot.tagkit.Attribute;

public class DependenceGraph
implements Attribute {
    private static final String NAME = "DependenceGraph";
    HashSet<Edge> edges = new HashSet();

    public boolean areAdjacent(short from2, short to2) {
        if (from2 > to2) {
            return this.areAdjacent(to2, from2);
        }
        if (from2 < 0 || to2 < 0) {
            return false;
        }
        if (from2 == to2) {
            return true;
        }
        return this.edges.contains(new Edge(from2, to2));
    }

    public void addEdge(short from2, short to2) {
        if (from2 < 0) {
            throw new RuntimeException("from < 0");
        }
        if (to2 < 0) {
            throw new RuntimeException("to < 0");
        }
        if (from2 > to2) {
            this.addEdge(to2, from2);
            return;
        }
        this.edges.add(new Edge(from2, to2));
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setValue(byte[] v) {
        throw new RuntimeException("Not Supported");
    }

    @Override
    public byte[] getValue() {
        byte[] ret = new byte[4 * this.edges.size()];
        int i = 0;
        for (Edge e : this.edges) {
            ret[i + 0] = (byte)(e.from >> 8 & 0xFF);
            ret[i + 1] = (byte)(e.from & 0xFF);
            ret[i + 2] = (byte)(e.to >> 8 & 0xFF);
            ret[i + 3] = (byte)(e.to & 0xFF);
            i += 4;
        }
        return ret;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("Dependences");
        for (Edge e : this.edges) {
            buf.append("( " + e.from + ", " + e.to + " ) ");
        }
        return buf.toString();
    }

    protected class Edge {
        short from;
        short to;

        Edge(short from2, short to2) {
            this.from = from2;
            this.to = to2;
        }

        public int hashCode() {
            return (this.from << 16) + this.to;
        }

        public boolean equals(Object other) {
            Edge o = (Edge)other;
            return this.from == o.from && this.to == o.to;
        }
    }
}

