/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.infoflow;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import soot.SootMethod;
import soot.jimple.toolkits.callgraph.Edge;

public class CallChain {
    Edge edge;
    CallChain next;

    public CallChain(Edge edge, CallChain next2) {
        this.edge = edge;
        this.next = next2 != null && next2.edge == null && next2.next == null ? null : next2;
    }

    public List<Edge> getEdges() {
        LinkedList<Edge> ret = new LinkedList<Edge>();
        if (this.edge != null) {
            ret.add(this.edge);
        }
        CallChain current = this.next;
        while (current != null) {
            ret.add(current.edge);
            current = current.next;
        }
        return ret;
    }

    public int size() {
        return 1 + (this.next == null ? 0 : this.next.size());
    }

    public Iterator<Edge> iterator() {
        return this.getEdges().iterator();
    }

    public boolean contains(Edge e) {
        return this.edge == e || this.next != null && this.next.contains(e);
    }

    public boolean containsMethod(SootMethod sm) {
        return this.edge != null && this.edge.tgt() == sm || this.next != null && this.next.containsMethod(sm);
    }

    public CallChain cloneAndExtend(CallChain extension2) {
        if (this.next == null) {
            return new CallChain(this.edge, extension2);
        }
        return new CallChain(this.edge, this.next.cloneAndExtend(extension2));
    }

    public Object clone() {
        if (this.next == null) {
            return new CallChain(this.edge, null);
        }
        return new CallChain(this.edge, (CallChain)this.next.clone());
    }

    public boolean equals(Object o) {
        if (o instanceof CallChain) {
            CallChain other = (CallChain)o;
            if (this.edge == other.edge && (this.next == null && other.next == null || this.next != null && other.next != null && this.next.equals(other.next))) {
                return true;
            }
        }
        return false;
    }
}

