/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.PatchingChain;
import soot.PhaseOptions;
import soot.Trap;
import soot.Unit;
import soot.jimple.GotoStmt;
import soot.jimple.IfStmt;
import soot.jimple.Jimple;
import soot.options.Options;
import soot.toolkits.graph.Block;
import soot.toolkits.graph.BriefBlockGraph;
import soot.util.Chain;

public class LoopConditionUnroller
extends BodyTransformer {
    private Set<Block> visitingSuccs;
    private Set<Block> visitedBlocks;
    private int maxSize;
    private Body body;
    private Map<Unit, List<Trap>> unitsToTraps;

    @Override
    protected void internalTransform(Body body, String phaseName, Map<String, String> options) {
        if (Options.v().verbose()) {
            G.v().out.println("[" + body.getMethod().getName() + "]     Unrolling Loop Conditions...");
        }
        this.visitingSuccs = new HashSet<Block>();
        this.visitedBlocks = new HashSet<Block>();
        this.body = body;
        this.maxSize = PhaseOptions.getInt(options, "maxSize");
        BriefBlockGraph bg = new BriefBlockGraph(body);
        for (Block b : bg.getHeads()) {
            this.unrollConditions(b);
        }
        if (Options.v().verbose()) {
            G.v().out.println("[" + body.getMethod().getName() + "]     Unrolling Loop Conditions done.");
        }
    }

    private Unit insertGotoAfter(Unit node, Unit target) {
        GotoStmt newGoto = Jimple.v().newGotoStmt(target);
        this.body.getUnits().insertAfter(newGoto, node);
        return newGoto;
    }

    private Unit insertCloneAfter(Chain<Unit> unitChain, Unit node, Unit toClone) {
        Unit clone2 = (Unit)toClone.clone();
        this.body.getUnits().insertAfter(clone2, node);
        return clone2;
    }

    private int getSize(Block block) {
        int size2 = 0;
        PatchingChain<Unit> unitChain = this.body.getUnits();
        Unit unit = block.getHead();
        while (unit != block.getTail()) {
            ++size2;
            unit = unitChain.getSuccOf(unit);
        }
        return ++size2;
    }

    private Map<Unit, List<Trap>> getTraps() {
        if (this.unitsToTraps != null) {
            return this.unitsToTraps;
        }
        this.unitsToTraps = new HashMap<Unit, List<Trap>>();
        for (Trap trap : this.body.getTraps()) {
            Unit beginUnit = trap.getBeginUnit();
            List<Trap> unitTraps = this.unitsToTraps.get(beginUnit);
            if (unitTraps == null) {
                unitTraps = new ArrayList<Trap>();
                this.unitsToTraps.put(beginUnit, unitTraps);
            }
            unitTraps.add(trap);
            Unit endUnit = trap.getEndUnit();
            if (endUnit == beginUnit) continue;
            unitTraps = this.unitsToTraps.get(endUnit);
            if (unitTraps == null) {
                unitTraps = new ArrayList<Trap>();
                this.unitsToTraps.put(endUnit, unitTraps);
            }
            unitTraps.add(trap);
        }
        return this.unitsToTraps;
    }

    private Unit copyBlock(Block block) {
        Unit newGoto;
        Map<Unit, List<Trap>> traps = this.getTraps();
        HashSet<Trap> openedTraps = new HashSet<Trap>();
        HashMap<Trap, Trap> copiedTraps = new HashMap<Trap, Trap>();
        PatchingChain<Unit> unitChain = this.body.getUnits();
        Unit tail = block.getTail();
        Unit immediateSucc = unitChain.getSuccOf(tail);
        Unit last2 = newGoto = this.insertGotoAfter(tail, immediateSucc);
        boolean first = true;
        Unit copiedHead = null;
        Unit currentUnit = block.getHead();
        while (currentUnit != newGoto) {
            List<Trap> currentTraps;
            last2 = this.insertCloneAfter(unitChain, last2, currentUnit);
            if (first) {
                first = false;
                copiedHead = last2;
            }
            if ((currentTraps = traps.get(currentUnit)) != null) {
                for (Trap trap : currentTraps) {
                    Trap copiedTrap;
                    if (trap.getBeginUnit() == currentUnit) {
                        copiedTrap = (Trap)trap.clone();
                        copiedTrap.setBeginUnit(last2);
                        copiedTraps.put(trap, copiedTrap);
                        openedTraps.add(copiedTrap);
                        this.body.getTraps().insertAfter(copiedTrap, trap);
                    }
                    if (trap.getEndUnit() != currentUnit) continue;
                    copiedTrap = (Trap)copiedTraps.get(trap);
                    if (copiedTrap == null) {
                        copiedTrap = (Trap)trap.clone();
                        copiedTrap.setBeginUnit(copiedHead);
                        this.body.getTraps().insertAfter(copiedTrap, trap);
                    } else {
                        openedTraps.remove(copiedTrap);
                    }
                    copiedTrap.setEndUnit(last2);
                }
            }
            currentUnit = unitChain.getSuccOf(currentUnit);
        }
        Iterator openedIterator = openedTraps.iterator();
        while (openedIterator.hasNext()) {
            ((Trap)openedIterator.next()).setEndUnit(last2);
        }
        return copiedHead;
    }

    private void unrollConditions(Block block) {
        if (this.visitedBlocks.contains(block)) {
            return;
        }
        this.visitedBlocks.add(block);
        this.visitingSuccs.add(block);
        for (Block succ : block.getSuccs()) {
            if (this.visitedBlocks.contains(succ)) {
                if (succ == block || !this.visitingSuccs.contains(succ) || succ.getPreds().size() < 2 || succ.getSuccs().size() != 2) continue;
                Block condition = succ;
                Block loopTailBlock = block;
                if (this.getSize(condition) > this.maxSize) continue;
                Unit copiedHead = this.copyBlock(condition);
                Unit loopTail = loopTailBlock.getTail();
                if (loopTail instanceof GotoStmt) {
                    ((GotoStmt)loopTail).setTarget(copiedHead);
                    continue;
                }
                if (loopTail instanceof IfStmt) {
                    if (((IfStmt)loopTail).getTarget() == condition.getHead()) {
                        ((IfStmt)loopTail).setTarget(copiedHead);
                        continue;
                    }
                    this.insertGotoAfter(loopTail, copiedHead);
                    continue;
                }
                this.insertGotoAfter(loopTail, copiedHead);
                continue;
            }
            this.unrollConditions(succ);
        }
        this.visitingSuccs.remove(block);
    }
}

