/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.ondemand;

import java.util.HashSet;
import java.util.Set;
import soot.RefType;
import soot.Scene;
import soot.SootField;
import soot.jimple.spark.internal.TypeManager;
import soot.jimple.spark.ondemand.FieldCheckHeuristic;
import soot.jimple.spark.ondemand.genericutil.Util;
import soot.jimple.spark.ondemand.pautil.SootUtil;
import soot.jimple.spark.pag.ArrayElement;
import soot.jimple.spark.pag.SparkField;

public class InnerTypesIncrementalHeuristic
implements FieldCheckHeuristic {
    private final TypeManager manager;
    private final Set<RefType> typesToCheck = new HashSet<RefType>();
    private String newTypeOnQuery = null;
    private final Set<RefType> bothEndsTypes = new HashSet<RefType>();
    private final Set<RefType> notBothEndsTypes = new HashSet<RefType>();
    private int numPasses = 0;
    private final int passesInDirection;
    private boolean allNotBothEnds = false;

    public InnerTypesIncrementalHeuristic(TypeManager manager, int maxPasses) {
        this.manager = manager;
        this.passesInDirection = maxPasses / 2;
    }

    @Override
    public boolean runNewPass() {
        ++this.numPasses;
        if (this.numPasses == this.passesInDirection) {
            return this.switchToNotBothEnds();
        }
        if (this.newTypeOnQuery != null) {
            boolean added;
            String topLevelTypeStr = Util.topLevelTypeString(this.newTypeOnQuery);
            if (Scene.v().containsType(topLevelTypeStr)) {
                RefType refType = Scene.v().getRefType(topLevelTypeStr);
                added = this.typesToCheck.add(refType);
            } else {
                added = false;
            }
            this.newTypeOnQuery = null;
            return added;
        }
        return this.switchToNotBothEnds();
    }

    private boolean switchToNotBothEnds() {
        if (!this.allNotBothEnds) {
            this.numPasses = 0;
            this.allNotBothEnds = true;
            this.newTypeOnQuery = null;
            this.typesToCheck.clear();
            return true;
        }
        return false;
    }

    @Override
    public boolean validateMatchesForField(SparkField field2) {
        if (field2 instanceof ArrayElement) {
            return true;
        }
        SootField sootField = (SootField)field2;
        RefType declaringType = sootField.getDeclaringClass().getType();
        String declaringTypeStr = declaringType.toString();
        String topLevel = Util.topLevelTypeString(declaringTypeStr);
        RefType refType = Scene.v().containsType(topLevel) ? Scene.v().getRefType(topLevel) : null;
        for (RefType checkedType : this.typesToCheck) {
            if (!this.manager.castNeverFails(checkedType, refType)) continue;
            return true;
        }
        if (this.newTypeOnQuery == null) {
            this.newTypeOnQuery = declaringTypeStr;
        }
        return false;
    }

    @Override
    public boolean validFromBothEnds(SparkField field2) {
        if (this.allNotBothEnds) {
            return false;
        }
        if (field2 instanceof ArrayElement) {
            return true;
        }
        SootField sootField = (SootField)field2;
        RefType declaringType = sootField.getDeclaringClass().getType();
        if (this.bothEndsTypes.contains(declaringType)) {
            return true;
        }
        if (this.notBothEndsTypes.contains(declaringType)) {
            return false;
        }
        if (SootUtil.hasRecursiveField(declaringType.getSootClass())) {
            this.notBothEndsTypes.add(declaringType);
            return false;
        }
        this.bothEndsTypes.add(declaringType);
        return true;
    }

    public String toString() {
        return this.typesToCheck.toString();
    }
}

