/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.ondemand;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import soot.jimple.spark.ondemand.genericutil.Predicate;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PagToDotDumper;
import soot.jimple.spark.pag.VarNode;

public class DotPointerGraph {
    private final Set<String> edges = new HashSet<String>();
    private final Set<Node> nodes = new HashSet<Node>();

    public void addAssign(VarNode from2, VarNode to2) {
        this.addEdge(to2, from2, "", "black");
    }

    private void addEdge(Node from2, Node to2, String edgeLabel, String color) {
        this.nodes.add(from2);
        this.nodes.add(to2);
        this.addEdge(PagToDotDumper.makeNodeName(from2), PagToDotDumper.makeNodeName(to2), edgeLabel, color);
    }

    private void addEdge(String from2, String to2, String edgeLabel, String color) {
        StringBuffer tmp = new StringBuffer();
        tmp.append("    ");
        tmp.append(from2);
        tmp.append(" -> ");
        tmp.append(to2);
        tmp.append(" [label=\"");
        tmp.append(edgeLabel);
        tmp.append("\", color=");
        tmp.append(color);
        tmp.append("];");
        this.edges.add(tmp.toString());
    }

    public void addNew(AllocNode from2, VarNode to2) {
        this.addEdge(to2, from2, "", "yellow");
    }

    public void addCall(VarNode from2, VarNode to2, Integer callSite) {
        this.addEdge(to2, from2, callSite.toString(), "blue");
    }

    public void addMatch(VarNode from2, VarNode to2) {
        this.addEdge(to2, from2, "", "brown");
    }

    public void addLoad(FieldRefNode from2, VarNode to2) {
        this.addEdge(to2, from2.getBase(), from2.getField().toString(), "green");
    }

    public void addStore(VarNode from2, FieldRefNode to2) {
        this.addEdge(to2.getBase(), from2, to2.getField().toString(), "red");
    }

    public int numEdges() {
        return this.edges.size();
    }

    public void dump(String filename) {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileOutputStream(filename));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        pw.println("digraph G {");
        Predicate<Node> falsePred = new Predicate<Node>(){

            @Override
            public boolean test(Node obj_) {
                return false;
            }
        };
        for (Node node : this.nodes) {
            pw.println(PagToDotDumper.makeDotNodeLabel(node, falsePred));
        }
        for (String edge : this.edges) {
            pw.println(edge);
        }
        pw.println("}");
        pw.close();
    }
}

