/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.geom.heapinsE;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import soot.Hierarchy;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.jimple.spark.geom.dataMgr.PtSensVisitor;
import soot.jimple.spark.geom.dataRep.PlainConstraint;
import soot.jimple.spark.geom.dataRep.RectangleNode;
import soot.jimple.spark.geom.dataRep.SegmentNode;
import soot.jimple.spark.geom.geomPA.GeomPointsTo;
import soot.jimple.spark.geom.geomPA.IVarAbstraction;
import soot.jimple.spark.geom.geomPA.IWorklist;
import soot.jimple.spark.geom.geomPA.Parameters;
import soot.jimple.spark.geom.heapinsE.HeapInsIntervalManager;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.ClassConstantNode;
import soot.jimple.spark.pag.LocalVarNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.StringConstantNode;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.util.Numberable;

public class HeapInsNode
extends IVarAbstraction {
    public HashMap<HeapInsNode, HeapInsIntervalManager> flowto;
    public HashMap<AllocNode, HeapInsIntervalManager> pt_objs;
    public Map<AllocNode, HeapInsIntervalManager> new_pts;
    public Vector<PlainConstraint> complex_cons = null;

    public HeapInsNode(Node thisVar) {
        this.me = thisVar;
    }

    @Override
    public void deleteAll() {
        this.flowto = null;
        this.pt_objs = null;
        this.new_pts = null;
        this.complex_cons = null;
    }

    @Override
    public void reconstruct() {
        this.flowto = new HashMap();
        this.pt_objs = new HashMap();
        this.new_pts = new HashMap<AllocNode, HeapInsIntervalManager>();
        this.complex_cons = null;
        this.lrf_value = 0;
    }

    @Override
    public void do_before_propagation() {
        SootMethod func;
        this.do_pts_interval_merge();
        this.do_flow_edge_interval_merge();
        Node wrappedNode = this.getWrappedNode();
        if (wrappedNode instanceof LocalVarNode && ((LocalVarNode)wrappedNode).isThisPtr() && !(func = ((LocalVarNode)wrappedNode).getMethod()).isConstructor()) {
            SootClass defClass = func.getDeclaringClass();
            Hierarchy typeHierarchy = Scene.v().getActiveHierarchy();
            Iterator<AllocNode> it = this.new_pts.keySet().iterator();
            while (it.hasNext()) {
                SootClass sc;
                AllocNode obj = it.next();
                if (!(obj.getType() instanceof RefType) || defClass == (sc = ((RefType)obj.getType()).getSootClass())) continue;
                try {
                    SootMethod rt_func = typeHierarchy.resolveConcreteDispatch(sc, func);
                    if (rt_func == func) continue;
                    it.remove();
                    this.pt_objs.put(obj, (HeapInsIntervalManager)deadManager);
                }
                catch (RuntimeException e) {}
            }
        }
    }

    @Override
    public void do_after_propagation() {
        for (HeapInsIntervalManager im : this.new_pts.values()) {
            im.flush();
        }
        this.new_pts = new HashMap<AllocNode, HeapInsIntervalManager>();
    }

    @Override
    public int num_of_diff_objs() {
        if (this.parent != this) {
            return this.getRepresentative().num_of_diff_objs();
        }
        if (this.pt_objs == null) {
            return -1;
        }
        return this.pt_objs.size();
    }

    @Override
    public int num_of_diff_edges() {
        if (this.parent != this) {
            return this.getRepresentative().num_of_diff_objs();
        }
        if (this.flowto == null) {
            return -1;
        }
        return this.flowto.size();
    }

    @Override
    public boolean add_points_to_3(AllocNode obj, long I1, long I2, long L) {
        int code = 0;
        HeapInsNode.pres.I1 = I1;
        HeapInsNode.pres.I2 = I2;
        HeapInsNode.pres.L = L;
        code = I1 == 0L ? (I2 == 0L ? -1 : 0) : (I2 == 0L ? 1 : 2);
        return this.addPointsTo(code, obj);
    }

    @Override
    public boolean add_points_to_4(AllocNode obj, long I1, long I2, long L1, long L2) {
        return false;
    }

    @Override
    public boolean add_simple_constraint_3(IVarAbstraction qv, long I1, long I2, long L) {
        int code = 0;
        HeapInsNode.pres.I1 = I1;
        HeapInsNode.pres.I2 = I2;
        HeapInsNode.pres.L = L;
        code = I1 == 0L ? (I2 == 0L ? -1 : 0) : (I2 == 0L ? 1 : 2);
        return this.addFlowsTo(code, (HeapInsNode)qv);
    }

    @Override
    public boolean add_simple_constraint_4(IVarAbstraction qv, long I1, long I2, long L1, long L2) {
        return false;
    }

    @Override
    public void put_complex_constraint(PlainConstraint cons) {
        if (this.complex_cons == null) {
            this.complex_cons = new Vector();
        }
        this.complex_cons.add(cons);
    }

    @Override
    public void drop_duplicates() {
        for (HeapInsIntervalManager im : this.pt_objs.values()) {
            im.removeUselessSegments();
        }
    }

    @Override
    public void propagate(GeomPointsTo ptAnalyzer, IWorklist worklist) {
        SegmentNode pts;
        int i;
        HeapInsNode qn;
        SegmentNode[] int_entry1;
        AllocNode obj;
        if (this.complex_cons != null) {
            block4: for (Map.Entry<Numberable, HeapInsIntervalManager> entry2 : this.new_pts.entrySet()) {
                obj = (AllocNode)entry2.getKey();
                int_entry1 = entry2.getValue().getFigures();
                for (PlainConstraint pcons : this.complex_cons) {
                    HeapInsNode objn = (HeapInsNode)ptAnalyzer.findAndInsertInstanceField(obj, pcons.f);
                    if (objn == null) {
                        this.pt_objs.put(obj, (HeapInsIntervalManager)deadManager);
                        entry2.setValue((HeapInsIntervalManager)deadManager);
                        continue block4;
                    }
                    if (!objn.willUpdate) continue;
                    qn = (HeapInsNode)pcons.otherSide;
                    for (i = 0; i < HeapInsIntervalManager.Divisions; ++i) {
                        pts = int_entry1[i];
                        while (pts != null && pts.is_new) {
                            switch (pcons.type) {
                                case 3: {
                                    if (!qn.add_simple_constraint_3(objn, pcons.code == 0 ? pts.I1 : 0L, pts.I2, pts.L < 0L ? -pts.L : pts.L)) break;
                                    worklist.push(qn);
                                    break;
                                }
                                case 2: {
                                    if (!objn.add_simple_constraint_3(qn, pts.I2, pcons.code == 0 ? pts.I1 : 0L, pts.L < 0L ? -pts.L : pts.L)) break;
                                    worklist.push(objn);
                                }
                            }
                            pts = pts.next;
                        }
                    }
                }
            }
        }
        for (Map.Entry<Numberable, HeapInsIntervalManager> entry3 : this.flowto.entrySet()) {
            boolean added = false;
            qn = (HeapInsNode)entry3.getKey();
            HeapInsIntervalManager him1 = entry3.getValue();
            int_entry1 = him1.getFigures();
            boolean has_new_edges = him1.isThereUnprocessedFigures();
            Map<AllocNode, HeapInsIntervalManager> objs = has_new_edges ? this.pt_objs : this.new_pts;
            for (Map.Entry<AllocNode, HeapInsIntervalManager> entry2 : objs.entrySet()) {
                obj = entry2.getKey();
                HeapInsIntervalManager him2 = entry2.getValue();
                if (him2 == deadManager || !ptAnalyzer.castNeverFails(obj.getType(), qn.getWrappedNode().getType())) continue;
                SegmentNode[] int_entry2 = him2.getFigures();
                for (i = 0; i < HeapInsIntervalManager.Divisions; ++i) {
                    pts = int_entry2[i];
                    while (pts != null && (has_new_edges || pts.is_new)) {
                        for (int j = 0; j < HeapInsIntervalManager.Divisions; ++j) {
                            SegmentNode pe = int_entry1[j];
                            while (pe != null && (pts.is_new || pe.is_new)) {
                                if (HeapInsNode.add_new_points_to_tuple(pts, pe, obj, qn)) {
                                    added = true;
                                }
                                pe = pe.next;
                            }
                        }
                        pts = pts.next;
                    }
                }
            }
            if (added) {
                worklist.push(qn);
            }
            if (!has_new_edges) continue;
            him1.flush();
        }
    }

    @Override
    public int count_pts_intervals(AllocNode obj) {
        int ret = 0;
        SegmentNode[] int_entry = this.find_points_to(obj);
        for (int j = 0; j < HeapInsIntervalManager.Divisions; ++j) {
            SegmentNode p = int_entry[j];
            while (p != null) {
                ++ret;
                p = p.next;
            }
        }
        return ret;
    }

    @Override
    public int count_flow_intervals(IVarAbstraction qv) {
        int ret = 0;
        SegmentNode[] int_entry = this.find_flowto((HeapInsNode)qv);
        for (int j = 0; j < HeapInsIntervalManager.Divisions; ++j) {
            SegmentNode p = int_entry[j];
            while (p != null) {
                ++ret;
                p = p.next;
            }
        }
        return ret;
    }

    @Override
    public boolean heap_sensitive_intersection(IVarAbstraction qv) {
        HeapInsNode qn = (HeapInsNode)qv;
        for (AllocNode an2 : this.pt_objs.keySet()) {
            SegmentNode[] qt;
            if (an2 instanceof ClassConstantNode || an2 instanceof StringConstantNode || (qt = qn.find_points_to(an2)) == null) continue;
            SegmentNode[] pt = this.find_points_to(an2);
            for (int i = 0; i < HeapInsIntervalManager.Divisions; ++i) {
                SegmentNode p = pt[i];
                while (p != null) {
                    for (int j = 0; j < HeapInsIntervalManager.Divisions; ++j) {
                        SegmentNode q = qt[j];
                        while (q != null) {
                            if (HeapInsNode.quick_intersecting_test(p, q)) {
                                return true;
                            }
                            q = q.next;
                        }
                    }
                    p = p.next;
                }
            }
        }
        return false;
    }

    @Override
    public Set<AllocNode> get_all_points_to_objects() {
        if (this.parent != this) {
            return this.getRepresentative().get_all_points_to_objects();
        }
        return this.pt_objs.keySet();
    }

    @Override
    public void print_context_sensitive_points_to(PrintStream outPrintStream) {
        for (AllocNode obj : this.pt_objs.keySet()) {
            SegmentNode[] int_entry = this.find_points_to(obj);
            for (int j = 0; j < HeapInsIntervalManager.Divisions; ++j) {
                SegmentNode p = int_entry[j];
                while (p != null) {
                    outPrintStream.println("(" + obj.toString() + ", " + p.I1 + ", " + p.I2 + ", " + p.L + ")");
                    p = p.next;
                }
            }
        }
    }

    @Override
    public boolean pointer_interval_points_to(long l, long r, AllocNode obj) {
        SegmentNode[] int_entry = this.find_points_to(obj);
        if (int_entry == null) {
            return false;
        }
        if (int_entry[0] != null) {
            return true;
        }
        for (int i = 1; i < HeapInsIntervalManager.Divisions; ++i) {
            SegmentNode p = int_entry[i];
            while (p != null) {
                long R2 = p.I1 + p.L;
                if (l <= p.I1 && p.I1 < r || p.I1 <= l && l < R2) {
                    return true;
                }
                p = p.next;
            }
        }
        return false;
    }

    @Override
    public void remove_points_to(AllocNode obj) {
        this.pt_objs.remove(obj);
    }

    @Override
    public void keepPointsToOnly() {
        this.flowto = null;
        this.new_pts = null;
        this.complex_cons = null;
    }

    @Override
    public int count_new_pts_intervals() {
        int ans = 0;
        for (HeapInsIntervalManager im : this.new_pts.values()) {
            SegmentNode[] int_entry = im.getFigures();
            for (int i = 0; i < HeapInsIntervalManager.Divisions; ++i) {
                SegmentNode p = int_entry[i];
                while (p != null && p.is_new) {
                    ++ans;
                    p = p.next;
                }
            }
        }
        return ans;
    }

    @Override
    public void get_all_context_sensitive_objects(long l, long r, PtSensVisitor visitor) {
        if (this.parent != this) {
            this.getRepresentative().get_all_context_sensitive_objects(l, r, visitor);
            return;
        }
        GeomPointsTo geomPTA = (GeomPointsTo)Scene.v().getPointsToAnalysis();
        for (Map.Entry<AllocNode, HeapInsIntervalManager> entry2 : this.pt_objs.entrySet()) {
            AllocNode obj = entry2.getKey();
            HeapInsIntervalManager im = entry2.getValue();
            SegmentNode[] int_entry = im.getFigures();
            SootMethod sm = obj.getMethod();
            int sm_int = 0;
            long n_contexts = 1L;
            if (sm != null) {
                sm_int = geomPTA.getIDFromSootMethod(sm);
                n_contexts = geomPTA.context_size[sm_int];
            }
            for (int i = 0; i < HeapInsIntervalManager.Divisions; ++i) {
                SegmentNode p = int_entry[i];
                while (p != null) {
                    long d;
                    long R2 = p.I1 + p.L;
                    long objL = -1L;
                    long objR = -1L;
                    if (i == 0) {
                        objL = p.I2;
                        objR = p.I2 + p.L;
                    } else if (l <= p.I1 && p.I1 < r) {
                        if (i != 1) {
                            d = r - p.I1;
                            if (d > p.L) {
                                d = p.L;
                            }
                            objL = p.I2;
                            objR = objL + d;
                        } else {
                            objL = 1L;
                            objR = 1L + n_contexts;
                        }
                    } else if (p.I1 <= l && l < R2) {
                        if (i != 1) {
                            d = R2 - l;
                            if (R2 > r) {
                                d = r - l;
                            }
                            objL = p.I2 + l - p.I1;
                            objR = objL + d;
                        } else {
                            objL = 1L;
                            objR = 1L + n_contexts;
                        }
                    }
                    if (objL != -1L && objR != -1L) {
                        visitor.visit(obj, objL, objR, sm_int);
                    }
                    p = p.next;
                }
            }
        }
    }

    @Override
    public void injectPts() {
        final GeomPointsTo geomPTA = (GeomPointsTo)Scene.v().getPointsToAnalysis();
        this.pt_objs = new HashMap();
        this.me.getP2Set().forall(new P2SetVisitor(){

            @Override
            public void visit(Node n) {
                if (geomPTA.isValidGeometricNode(n)) {
                    HeapInsNode.this.pt_objs.put((AllocNode)n, (HeapInsIntervalManager)stubManager);
                }
            }
        });
        this.new_pts = null;
    }

    @Override
    public boolean isDeadObject(AllocNode obj) {
        return this.pt_objs.get(obj) == deadManager;
    }

    private SegmentNode[] find_flowto(HeapInsNode qv) {
        HeapInsIntervalManager im = this.flowto.get(qv);
        if (im == null) {
            return null;
        }
        return im.getFigures();
    }

    private SegmentNode[] find_points_to(AllocNode obj) {
        HeapInsIntervalManager im = this.pt_objs.get(obj);
        if (im == null) {
            return null;
        }
        return im.getFigures();
    }

    private void do_pts_interval_merge() {
        for (HeapInsIntervalManager him : this.new_pts.values()) {
            him.mergeFigures(Parameters.max_pts_budget);
        }
    }

    private void do_flow_edge_interval_merge() {
        for (HeapInsIntervalManager him : this.flowto.values()) {
            him.mergeFigures(Parameters.max_cons_budget);
        }
    }

    private boolean addPointsTo(int code, AllocNode obj) {
        HeapInsIntervalManager im = this.pt_objs.get(obj);
        if (im == null) {
            im = new HeapInsIntervalManager();
            this.pt_objs.put(obj, im);
        } else if (im == deadManager) {
            return false;
        }
        if (im.addNewFigure(code, pres) != null) {
            this.new_pts.put(obj, im);
            return true;
        }
        return false;
    }

    private boolean addFlowsTo(int code, HeapInsNode qv) {
        HeapInsIntervalManager im = this.flowto.get(qv);
        if (im == null) {
            im = new HeapInsIntervalManager();
            this.flowto.put(qv, im);
        }
        return im.addNewFigure(code, pres) != null;
    }

    private static boolean add_new_points_to_tuple(SegmentNode pts, SegmentNode pe, AllocNode obj, HeapInsNode qn) {
        int code = 0;
        if (pts.I1 == 0L || pe.I1 == 0L) {
            if (pe.I2 != 0L) {
                HeapInsNode.pres.I1 = pe.I2;
                HeapInsNode.pres.I2 = 0L;
                HeapInsNode.pres.L = pe.L;
                code = 1;
            } else {
                HeapInsNode.pres.I1 = 0L;
                HeapInsNode.pres.I2 = pts.I2;
                HeapInsNode.pres.L = pts.L;
                code = pts.I2 == 0L ? -1 : 0;
            }
        } else {
            long interJ;
            long interI = pe.I1 < pts.I1 ? pts.I1 : pe.I1;
            long l = interJ = pe.I1 + pe.L < pts.I1 + pts.L ? pe.I1 + pe.L : pts.I1 + pts.L;
            if (interI >= interJ) {
                return false;
            }
            HeapInsNode.pres.I1 = pe.I2 == 0L ? 0L : interI - pe.I1 + pe.I2;
            HeapInsNode.pres.I2 = pts.I2 == 0L ? 0L : interI - pts.I1 + pts.I2;
            HeapInsNode.pres.L = interJ - interI;
            code = HeapInsNode.pres.I1 == 0L ? (HeapInsNode.pres.I2 == 0L ? -1 : 0) : (HeapInsNode.pres.I2 == 0L ? 1 : 2);
        }
        return qn.addPointsTo(code, obj);
    }

    private static boolean quick_intersecting_test(SegmentNode p, SegmentNode q) {
        if (p.I2 == 0L || q.I2 == 0L) {
            return true;
        }
        if (p.I2 >= q.I2) {
            return p.I2 < q.I2 + (q.L < 0L ? -q.L : q.L);
        }
        return q.I2 < p.I2 + (p.L < 0L ? -p.L : p.L);
    }

    static {
        stubManager = new HeapInsIntervalManager();
        pres = new RectangleNode(0L, 0L, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        stubManager.addNewFigure(-1, pres);
        deadManager = new HeapInsIntervalManager();
    }
}

