/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark;

import java.util.Date;
import java.util.Map;
import soot.G;
import soot.Local;
import soot.Scene;
import soot.SceneTransformer;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.SourceLocator;
import soot.Unit;
import soot.Value;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.ReachingTypeDumper;
import soot.jimple.Stmt;
import soot.jimple.spark.builder.ContextInsensitiveBuilder;
import soot.jimple.spark.geom.geomPA.GeomPointsTo;
import soot.jimple.spark.ondemand.DemandCSPointsTo;
import soot.jimple.spark.pag.AllocDotField;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.PAG2HTML;
import soot.jimple.spark.pag.PAGDumper;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.spark.solver.EBBCollapser;
import soot.jimple.spark.solver.PropAlias;
import soot.jimple.spark.solver.PropCycle;
import soot.jimple.spark.solver.PropIter;
import soot.jimple.spark.solver.PropMerge;
import soot.jimple.spark.solver.PropWorklist;
import soot.jimple.spark.solver.Propagator;
import soot.jimple.spark.solver.SCCCollapser;
import soot.jimple.toolkits.callgraph.CallGraphBuilder;
import soot.options.SparkOptions;
import soot.tagkit.Host;
import soot.tagkit.StringTag;
import soot.tagkit.Tag;

public class SparkTransformer
extends SceneTransformer {
    public SparkTransformer(Singletons.Global g) {
    }

    public static SparkTransformer v() {
        return G.v().soot_jimple_spark_SparkTransformer();
    }

    @Override
    protected void internalTransform(String phaseName, Map<String, String> options) {
        SparkOptions opts = new SparkOptions(options);
        String output_dir = SourceLocator.v().getOutputDir();
        ContextInsensitiveBuilder b = new ContextInsensitiveBuilder();
        if (opts.pre_jimplify()) {
            b.preJimplify();
        }
        if (opts.force_gc()) {
            SparkTransformer.doGC();
        }
        Date startBuild = new Date();
        PAG pag = b.setup(opts);
        b.build();
        Date endBuild = new Date();
        SparkTransformer.reportTime("Pointer Assignment Graph", startBuild, endBuild);
        if (opts.force_gc()) {
            SparkTransformer.doGC();
        }
        Date startTM = new Date();
        pag.getTypeManager().makeTypeMask();
        Date endTM = new Date();
        SparkTransformer.reportTime("Type masks", startTM, endTM);
        if (opts.force_gc()) {
            SparkTransformer.doGC();
        }
        if (opts.verbose()) {
            G.v().out.println("VarNodes: " + pag.getVarNodeNumberer().size());
            G.v().out.println("FieldRefNodes: " + pag.getFieldRefNodeNumberer().size());
            G.v().out.println("AllocNodes: " + pag.getAllocNodeNumberer().size());
        }
        Date startSimplify = new Date();
        if (opts.simplify_sccs() && !opts.on_fly_cg() || opts.vta()) {
            new SCCCollapser(pag, opts.ignore_types_for_sccs()).collapse();
        }
        if (opts.simplify_offline() && !opts.on_fly_cg()) {
            new EBBCollapser(pag).collapse();
        }
        pag.cleanUpMerges();
        Date endSimplify = new Date();
        SparkTransformer.reportTime("Pointer Graph simplified", startSimplify, endSimplify);
        if (opts.force_gc()) {
            SparkTransformer.doGC();
        }
        PAGDumper dumper = null;
        if (opts.dump_pag() || opts.dump_solution()) {
            dumper = new PAGDumper(pag, output_dir);
        }
        if (opts.dump_pag()) {
            dumper.dump();
        }
        Date startProp = new Date();
        Propagator[] propagator = new Propagator[1];
        switch (opts.propagator()) {
            case 1: {
                propagator[0] = new PropIter(pag);
                break;
            }
            case 2: {
                propagator[0] = new PropWorklist(pag);
                break;
            }
            case 3: {
                propagator[0] = new PropCycle(pag);
                break;
            }
            case 4: {
                propagator[0] = new PropMerge(pag);
                break;
            }
            case 5: {
                propagator[0] = new PropAlias(pag);
                break;
            }
            case 6: {
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        if (propagator[0] != null) {
            propagator[0].propagate();
        }
        Date endProp = new Date();
        SparkTransformer.reportTime("Propagation", startProp, endProp);
        SparkTransformer.reportTime("Solution found", startSimplify, endProp);
        if (opts.force_gc()) {
            SparkTransformer.doGC();
        }
        if (!opts.on_fly_cg() || opts.vta()) {
            CallGraphBuilder cgb = new CallGraphBuilder(pag);
            cgb.build();
        }
        if (opts.verbose()) {
            G.v().out.println("[Spark] Number of reachable methods: " + Scene.v().getReachableMethods().size());
        }
        if (opts.set_mass()) {
            this.findSetMass(pag);
        }
        if (opts.dump_answer()) {
            new ReachingTypeDumper(pag, output_dir).dump();
        }
        if (opts.dump_solution()) {
            dumper.dumpPointsToSets();
        }
        if (opts.dump_html()) {
            new PAG2HTML(pag, output_dir).dump();
        }
        Scene.v().setPointsToAnalysis(pag);
        if (opts.add_tags()) {
            this.addTags(pag);
        }
        if (opts.geom_pta()) {
            if (opts.simplify_offline() || opts.simplify_sccs()) {
                G.v().out.println("Please turn off the simplify-offline and simplify-sccs to run the geometric points-to analysis");
                G.v().out.println("Now, we keep the SPARK result for querying.");
            } else {
                GeomPointsTo geomPTA = (GeomPointsTo)pag;
                geomPTA.parametrize(endProp.getTime() - startSimplify.getTime());
                geomPTA.solve();
            }
        }
        if (opts.cs_demand()) {
            Date startOnDemand = new Date();
            DemandCSPointsTo onDemandAnalysis = DemandCSPointsTo.makeWithBudget(opts.traversal(), opts.passes(), opts.lazy_pts());
            Date endOndemand = new Date();
            SparkTransformer.reportTime("Initialized on-demand refinement-based context-sensitive analysis", startOnDemand, endOndemand);
            Scene.v().setPointsToAnalysis(onDemandAnalysis);
        }
    }

    protected void addTags(PAG pag) {
        final StringTag unknown = new StringTag("Untagged Spark node");
        final Map<Node, Tag> nodeToTag = pag.getNodeTags();
        for (SootClass c : Scene.v().getClasses()) {
            for (SootMethod m : c.getMethods()) {
                if (!m.isConcrete() || !m.hasActiveBody()) continue;
                for (Unit u : m.getActiveBody().getUnits()) {
                    Node[] simpleSources;
                    final Stmt s2 = (Stmt)u;
                    if (!(s2 instanceof DefinitionStmt)) continue;
                    Value lhs = ((DefinitionStmt)s2).getLeftOp();
                    VarNode v = null;
                    if (lhs instanceof Local) {
                        v = pag.findLocalVarNode(lhs);
                    } else if (lhs instanceof FieldRef) {
                        v = pag.findGlobalVarNode(((FieldRef)lhs).getField());
                    }
                    if (v == null) continue;
                    PointsToSetInternal p2set = v.getP2Set();
                    p2set.forall(new P2SetVisitor(){

                        @Override
                        public final void visit(Node n) {
                            SparkTransformer.this.addTag(s2, n, nodeToTag, unknown);
                        }
                    });
                    for (Node element2 : simpleSources = pag.simpleInvLookup(v)) {
                        this.addTag(s2, element2, nodeToTag, unknown);
                    }
                    for (Node element2 : simpleSources = pag.allocInvLookup(v)) {
                        this.addTag(s2, element2, nodeToTag, unknown);
                    }
                    for (Node element2 : simpleSources = pag.loadInvLookup(v)) {
                        this.addTag(s2, element2, nodeToTag, unknown);
                    }
                }
            }
        }
    }

    protected static void reportTime(String desc, Date start, Date end) {
        long time = end.getTime() - start.getTime();
        G.v().out.println("[Spark] " + desc + " in " + time / 1000L + "." + time / 100L % 10L + " seconds.");
    }

    protected static void doGC() {
        System.gc();
        System.gc();
        System.gc();
        System.gc();
        System.gc();
    }

    protected void addTag(Host h, Node n, Map<Node, Tag> nodeToTag, Tag unknown) {
        if (nodeToTag.containsKey(n)) {
            h.addTag(nodeToTag.get(n));
        } else {
            h.addTag(unknown);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void findSetMass(PAG pag) {
        void var8_20;
        void var7_12;
        int mass = 0;
        int varMass = 0;
        int adfs = 0;
        int scalars = 0;
        for (VarNode varNode : pag.getVarNodeNumberer()) {
            ++scalars;
            PointsToSetInternal pointsToSetInternal = varNode.getP2Set();
            if (pointsToSetInternal != null) {
                mass += pointsToSetInternal.size();
            }
            if (pointsToSetInternal == null) continue;
            varMass += pointsToSetInternal.size();
        }
        for (AllocNode allocNode : pag.allocSources()) {
            for (AllocDotField adf : allocNode.getFields()) {
                PointsToSetInternal set3 = adf.getP2Set();
                if (set3 != null) {
                    mass += set3.size();
                }
                if (set3 == null || set3.size() <= 0) continue;
                ++adfs;
            }
        }
        G.v().out.println("Set mass: " + mass);
        G.v().out.println("Variable mass: " + varMass);
        G.v().out.println("Scalars: " + scalars);
        G.v().out.println("adfs: " + adfs);
        int[] deRefCounts = new int[30001];
        for (VarNode varNode : pag.getDereferences()) {
            PointsToSetInternal set4 = varNode.getP2Set();
            int size2 = 0;
            if (set4 != null) {
                size2 = set4.size();
            }
            int n = size2;
            deRefCounts[n] = deRefCounts[n] + 1;
        }
        boolean bl = false;
        for (int element2 : deRefCounts) {
            var7_12 += element2;
        }
        G.v().out.println("Dereference counts BEFORE trimming (total = " + (int)var7_12 + "):");
        boolean bl2 = false;
        while (var8_20 < deRefCounts.length) {
            if (deRefCounts[var8_20] > 0) {
                G.v().out.println("" + (int)var8_20 + " " + deRefCounts[var8_20] + " " + (double)deRefCounts[var8_20] * 100.0 / (double)var7_12 + "%");
            }
            ++var8_20;
        }
    }
}

