/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.Value;
import soot.ValueBox;
import soot.jimple.InvokeExpr;

public abstract class AbstractInvokeExpr
implements InvokeExpr {
    protected SootMethodRef methodRef;
    protected final ValueBox[] argBoxes;

    protected AbstractInvokeExpr(SootMethodRef methodRef, ValueBox[] argBoxes) {
        this.methodRef = methodRef;
        this.argBoxes = argBoxes;
    }

    @Override
    public void setMethodRef(SootMethodRef methodRef) {
        this.methodRef = methodRef;
    }

    @Override
    public SootMethodRef getMethodRef() {
        return this.methodRef;
    }

    @Override
    public SootMethod getMethod() {
        return this.methodRef.resolve();
    }

    @Override
    public abstract Object clone();

    @Override
    public Value getArg(int index) {
        return this.argBoxes[index].getValue();
    }

    @Override
    public List<Value> getArgs() {
        ArrayList<Value> l = new ArrayList<Value>();
        for (ValueBox element2 : this.argBoxes) {
            l.add(element2.getValue());
        }
        return l;
    }

    @Override
    public int getArgCount() {
        return this.argBoxes.length;
    }

    @Override
    public void setArg(int index, Value arg) {
        this.argBoxes[index].setValue(arg);
    }

    @Override
    public ValueBox getArgBox(int index) {
        return this.argBoxes[index];
    }

    @Override
    public Type getType() {
        return this.methodRef.returnType();
    }

    @Override
    public List<ValueBox> getUseBoxes() {
        ArrayList<ValueBox> list = new ArrayList<ValueBox>();
        Collections.addAll(list, this.argBoxes);
        for (ValueBox element2 : this.argBoxes) {
            list.addAll(element2.getValue().getUseBoxes());
        }
        return list;
    }
}

