/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import soot.jimple.infoflow.data.SootMethodAndClass;

public class SootMethodRepresentationParser {
    private static final SootMethodRepresentationParser instance = new SootMethodRepresentationParser();
    private Pattern patternSubsigToName = null;

    private SootMethodRepresentationParser() {
    }

    public static SootMethodRepresentationParser v() {
        return instance;
    }

    public SootMethodAndClass parseSootMethodString(String parseString) {
        if (!parseString.startsWith("<") || !parseString.endsWith(">")) {
            throw new IllegalArgumentException("Illegal format of " + parseString + " (should use soot method representation)");
        }
        String name = "";
        String className = "";
        String returnType = "";
        Pattern pattern = Pattern.compile("<(.*?):");
        Matcher matcher = pattern.matcher(parseString);
        if (matcher.find()) {
            className = matcher.group(1);
        }
        if ((matcher = (pattern = Pattern.compile(": (.*?) ")).matcher(parseString)).find()) {
            returnType = matcher.group(1);
            parseString = parseString.substring(matcher.end(1));
        }
        if ((matcher = (pattern = Pattern.compile(" (.*?)\\(")).matcher(parseString)).find()) {
            name = matcher.group(1);
        }
        ArrayList<String> paramList = new ArrayList<String>();
        pattern = Pattern.compile("\\((.*?)\\)");
        matcher = pattern.matcher(parseString);
        if (matcher.find()) {
            String params = matcher.group(1);
            for (String param2 : params.split(",")) {
                paramList.add(param2.trim());
            }
        }
        return new SootMethodAndClass(name, className, returnType, paramList);
    }

    public HashMap<String, Set<String>> parseClassNames(Collection<String> methods, boolean subSignature) {
        HashMap<String, Set<String>> result2 = new HashMap<String, Set<String>>();
        Pattern pattern = Pattern.compile("^\\s*<(.*?):\\s*(.*?)>\\s*$");
        for (String parseString : methods) {
            String className = "";
            Matcher matcher = pattern.matcher(parseString);
            if (!matcher.find()) continue;
            className = matcher.group(1);
            String params = "";
            params = subSignature ? matcher.group(2) : parseString;
            if (result2.containsKey(className)) {
                result2.get(className).add(params);
                continue;
            }
            HashSet<String> methodList = new HashSet<String>();
            methodList.add(params);
            result2.put(className, methodList);
        }
        return result2;
    }

    public String getMethodNameFromSubSignature(String subSignature) {
        Matcher matcher;
        if (this.patternSubsigToName == null) {
            Pattern pattern;
            this.patternSubsigToName = pattern = Pattern.compile("^\\s*(.+)\\s+(.+)\\((.*?)\\)\\s*$");
        }
        if ((matcher = this.patternSubsigToName.matcher(subSignature)).find()) {
            return matcher.group(2);
        }
        return "";
    }

    public String[] getParameterTypesFromSubSignature(String subSignature) {
        Matcher matcher;
        if (this.patternSubsigToName == null) {
            Pattern pattern;
            this.patternSubsigToName = pattern = Pattern.compile("^\\s*(.+)\\s+(.+)\\((.*?)\\)\\s*$");
        }
        if (!(matcher = this.patternSubsigToName.matcher(subSignature)).find() || matcher.groupCount() < 3) {
            return null;
        }
        String params = matcher.group(3);
        return params.split("\\s*,\\s*");
    }
}

