/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.BooleanType;
import soot.Local;
import soot.PrimType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.infoflow.collect.ConcurrentHashSet;
import soot.jimple.infoflow.collect.MyConcurrentHashMap;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.handlers.TaintPropagationHandler;
import soot.jimple.infoflow.nativ.DefaultNativeCallHandler;
import soot.jimple.infoflow.nativ.NativeCallHandler;
import soot.jimple.infoflow.solver.IInfoflowSolver;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.infoflow.source.ISourceSinkManager;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.jimple.toolkits.ide.DefaultJimpleIFDSTabulationProblem;
import soot.jimple.toolkits.ide.icfg.BiDiInterproceduralCFG;

public abstract class AbstractInfoflowProblem
extends DefaultJimpleIFDSTabulationProblem<Abstraction, BiDiInterproceduralCFG<Unit, SootMethod>> {
    protected final Map<Unit, Set<Abstraction>> initialSeeds = new HashMap<Unit, Set<Abstraction>>();
    protected ITaintPropagationWrapper taintWrapper;
    protected final NativeCallHandler ncHandler = new DefaultNativeCallHandler();
    protected final ISourceSinkManager sourceSinkManager;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected boolean enableImplicitFlows = false;
    protected boolean enableStaticFields = true;
    protected boolean enableExceptions = true;
    protected boolean flowSensitiveAliasing = true;
    protected boolean enableTypeChecking = true;
    protected boolean ignoreFlowsInSystemPackages = true;
    protected boolean inspectSources = false;
    protected boolean inspectSinks = false;
    private Abstraction zeroValue = null;
    protected IInfoflowSolver solver = null;
    protected boolean stopAfterFirstFlow = false;
    protected Set<TaintPropagationHandler> taintPropagationHandlers = null;
    private MyConcurrentHashMap<Unit, Set<Unit>> activationUnitsToCallSites = new MyConcurrentHashMap();

    public AbstractInfoflowProblem(BiDiInterproceduralCFG<Unit, SootMethod> icfg, ISourceSinkManager sourceSinkManager) {
        super(icfg);
        this.sourceSinkManager = sourceSinkManager;
    }

    protected boolean canCastType(Type destType, Type sourceType) {
        if (!this.enableTypeChecking) {
            return true;
        }
        if (sourceType == null) {
            return true;
        }
        if (sourceType == destType) {
            return true;
        }
        if (Scene.v().getFastHierarchy().canStoreType(destType, sourceType) || Scene.v().getFastHierarchy().canStoreType(sourceType, destType)) {
            return true;
        }
        return destType instanceof PrimType && sourceType instanceof PrimType && destType != BooleanType.v() && sourceType != BooleanType.v();
    }

    protected boolean hasCompatibleTypesForCall(AccessPath apBase, SootClass dest) {
        if (!this.enableTypeChecking) {
            return true;
        }
        if (apBase.getBaseType() instanceof PrimType) {
            return false;
        }
        if (apBase.getBaseType() instanceof ArrayType) {
            return dest.getName().equals("java.lang.Object");
        }
        return Scene.v().getOrMakeFastHierarchy().canStoreType(apBase.getBaseType(), dest.getType()) || Scene.v().getOrMakeFastHierarchy().canStoreType(dest.getType(), apBase.getBaseType());
    }

    public void setSolver(IInfoflowSolver solver) {
        this.solver = solver;
    }

    public void setZeroValue(Abstraction zeroValue) {
        this.zeroValue = zeroValue;
    }

    @Override
    public boolean followReturnsPastSeeds() {
        return true;
    }

    public void setTaintWrapper(ITaintPropagationWrapper wrapper) {
        this.taintWrapper = wrapper;
    }

    public void setStopAfterFirstFlow(boolean stopAfterFirstFlow) {
        this.stopAfterFirstFlow = stopAfterFirstFlow;
    }

    public void setEnableImplicitFlows(boolean enableImplicitFlows) {
        this.enableImplicitFlows = enableImplicitFlows;
    }

    public void setEnableStaticFieldTracking(boolean enableStaticFields) {
        this.enableStaticFields = enableStaticFields;
    }

    public void setEnableExceptionTracking(boolean enableExceptions) {
        this.enableExceptions = enableExceptions;
    }

    public void setFlowSensitiveAliasing(boolean flowSensitiveAliasing) {
        this.flowSensitiveAliasing = flowSensitiveAliasing;
        this.zeroValue = null;
    }

    public void setEnableTypeChecking(boolean enableTypeChecking) {
        this.enableTypeChecking = enableTypeChecking;
    }

    public void setIgnoreFlowsInSystemPackages(boolean ignoreFlowsInSystemPackages) {
        this.ignoreFlowsInSystemPackages = ignoreFlowsInSystemPackages;
    }

    protected boolean isInitialMethod(SootMethod sm) {
        for (Unit u : this.initialSeeds.keySet()) {
            if (this.interproceduralCFG().getMethodOf(u) != sm) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<Unit, Set<Abstraction>> initialSeeds() {
        return this.initialSeeds;
    }

    @Override
    public boolean autoAddZero() {
        return false;
    }

    public void setInspectSources(boolean inspect) {
        this.inspectSources = inspect;
    }

    public void setInspectSinks(boolean inspect) {
        this.inspectSinks = inspect;
    }

    protected boolean baseMatches(Value baseValue, Abstraction source) {
        if (baseValue instanceof Local) {
            if (baseValue.equals(source.getAccessPath().getPlainValue())) {
                return true;
            }
        } else if (baseValue instanceof InstanceFieldRef) {
            InstanceFieldRef ifr = (InstanceFieldRef)baseValue;
            if (ifr.getBase().equals(source.getAccessPath().getPlainValue()) && source.getAccessPath().firstFieldMatches(ifr.getField())) {
                return true;
            }
        } else if (baseValue instanceof StaticFieldRef) {
            StaticFieldRef sfr = (StaticFieldRef)baseValue;
            if (source.getAccessPath().firstFieldMatches(sfr.getField())) {
                return true;
            }
        }
        return false;
    }

    protected boolean baseMatchesStrict(Value baseValue, Abstraction source) {
        if (!this.baseMatches(baseValue, source)) {
            return false;
        }
        if (baseValue instanceof Local) {
            return source.getAccessPath().isLocal();
        }
        if (baseValue instanceof InstanceFieldRef || baseValue instanceof StaticFieldRef) {
            return source.getAccessPath().getFieldCount() == 1;
        }
        throw new RuntimeException("Unexpected left side");
    }

    protected boolean isCallSiteActivatingTaint(Unit callSite, Unit activationUnit) {
        if (!this.flowSensitiveAliasing) {
            return false;
        }
        if (activationUnit == null) {
            return false;
        }
        Set callSites = (Set)this.activationUnitsToCallSites.get(activationUnit);
        return callSites != null && callSites.contains(callSite);
    }

    protected boolean registerActivationCallSite(Unit callSite, SootMethod callee, Abstraction activationAbs) {
        if (!this.flowSensitiveAliasing) {
            return false;
        }
        Unit activationUnit = activationAbs.getActivationUnit();
        if (activationUnit == null) {
            return false;
        }
        Set callSites = this.activationUnitsToCallSites.putIfAbsentElseGet(activationUnit, new ConcurrentHashSet());
        if (callSites.contains(callSite)) {
            return false;
        }
        if (!activationAbs.isAbstractionActive() && !callee.getActiveBody().getUnits().contains(activationUnit)) {
            boolean found = false;
            for (Unit au : callSites) {
                if (!callee.getActiveBody().getUnits().contains(au)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        }
        return callSites.add(callSite);
    }

    public void setActivationUnitsToCallSites(AbstractInfoflowProblem other) {
        this.activationUnitsToCallSites = other.activationUnitsToCallSites;
    }

    @Override
    public IInfoflowCFG interproceduralCFG() {
        return (IInfoflowCFG)super.interproceduralCFG();
    }

    public void addInitialSeeds(Unit unit, Set<Abstraction> seeds) {
        if (this.initialSeeds.containsKey(unit)) {
            this.initialSeeds.get(unit).addAll(seeds);
        } else {
            this.initialSeeds.put(unit, new HashSet<Abstraction>(seeds));
        }
    }

    public boolean hasInitialSeeds() {
        return !this.initialSeeds.isEmpty();
    }

    public Map<Unit, Set<Abstraction>> getInitialSeeds() {
        return this.initialSeeds;
    }

    public void addTaintPropagationHandler(TaintPropagationHandler handler) {
        if (this.taintPropagationHandlers == null) {
            this.taintPropagationHandlers = new HashSet<TaintPropagationHandler>();
        }
        this.taintPropagationHandlers.add(handler);
    }

    public Type buildArrayOrAddDimension(Type type) {
        if (type instanceof ArrayType) {
            ArrayType array = (ArrayType)type;
            return array.makeArrayType();
        }
        return ArrayType.v(type, 1);
    }

    protected boolean checkCast(AccessPath accessPath, Type type) {
        if (accessPath.isStaticFieldRef()) {
            return this.canCastType(type, accessPath.getFirstFieldType());
        }
        return this.canCastType(type, accessPath.getBaseType());
    }

    protected boolean isObjectLikeType(Type tp) {
        if (!(tp instanceof RefType)) {
            return false;
        }
        RefType rt = (RefType)tp;
        return rt.getSootClass().getName().equals("java.lang.Object") || rt.getSootClass().getName().equals("java.io.Serializable") || rt.getSootClass().getName().equals("java.lang.Cloneable");
    }

    @Override
    public Abstraction createZeroValue() {
        if (this.zeroValue == null) {
            this.zeroValue = Abstraction.getZeroAbstraction(this.flowSensitiveAliasing);
        }
        return this.zeroValue;
    }

    protected Abstraction getZeroValue() {
        return this.zeroValue;
    }

    protected boolean isExecutorExecute(InvokeExpr ie, SootMethod dest) {
        if (ie == null || dest == null) {
            return false;
        }
        SootMethod ieMethod = ie.getMethod();
        if (!ieMethod.getName().equals("execute") && !ieMethod.getName().equals("doPrivileged")) {
            return false;
        }
        String ieSubSig = ieMethod.getSubSignature();
        String calleeSubSig = dest.getSubSignature();
        if (ieSubSig.equals("void execute(java.lang.Runnable)") && calleeSubSig.equals("void run()")) {
            return true;
        }
        if (calleeSubSig.equals("java.lang.Object run()")) {
            if (ieSubSig.equals("java.lang.Object doPrivileged(java.security.PrivilegedAction)")) {
                return true;
            }
            if (ieSubSig.equals("java.lang.Object doPrivileged(java.security.PrivilegedAction,java.security.AccessControlContext)")) {
                return true;
            }
            if (ieSubSig.equals("java.lang.Object doPrivileged(java.security.PrivilegedExceptionAction)")) {
                return true;
            }
            if (ieSubSig.equals("java.lang.Object doPrivileged(java.security.PrivilegedExceptionAction,java.security.AccessControlContext)")) {
                return true;
            }
        }
        return false;
    }

    protected boolean isStringType(Type tp) {
        if (!(tp instanceof RefType)) {
            return false;
        }
        RefType refType = (RefType)tp;
        return refType.getClassName().equals("java.lang.String");
    }
}

