/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.data;

import soot.jimple.Stmt;
import soot.jimple.infoflow.data.AccessPath;

public class SourceContext
implements Cloneable {
    private final AccessPath accessPath;
    private final Stmt stmt;
    private final Object userData;
    private int hashCode = 0;

    public SourceContext(AccessPath accessPath, Stmt stmt) {
        assert (accessPath != null);
        this.accessPath = accessPath;
        this.stmt = stmt;
        this.userData = null;
    }

    public SourceContext(AccessPath accessPath, Stmt stmt, Object userData) {
        assert (accessPath != null);
        this.accessPath = accessPath;
        this.stmt = stmt;
        this.userData = userData;
    }

    public AccessPath getAccessPath() {
        return this.accessPath;
    }

    public Stmt getStmt() {
        return this.stmt;
    }

    public Object getUserData() {
        return this.userData;
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.stmt == null ? 0 : this.stmt.hashCode());
        result2 = 31 * result2 + (this.accessPath == null ? 0 : this.accessPath.hashCode());
        this.hashCode = result2 = 31 * result2 + (this.userData == null ? 0 : this.userData.hashCode());
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SourceContext other = (SourceContext)obj;
        if (this.hashCode != 0 && other.hashCode != 0 && this.hashCode != other.hashCode) {
            return false;
        }
        if (this.stmt == null ? other.stmt != null : !this.stmt.equals(other.stmt)) {
            return false;
        }
        if (this.accessPath == null ? other.accessPath != null : !this.accessPath.equals(other.accessPath)) {
            return false;
        }
        return !(this.userData == null ? other.userData != null : !this.userData.equals(other.userData));
    }

    public SourceContext clone() {
        SourceContext sc = new SourceContext(this.accessPath, this.stmt, this.userData);
        assert (sc.equals(this));
        return sc;
    }

    public String toString() {
        return this.accessPath.toString() + (this.stmt == null ? "" : " in " + this.stmt.toString());
    }
}

