/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.source;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import heros.InterproceduralCFG;
import heros.solver.IDESolver;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Local;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.AssignStmt;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.ParameterRef;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.infoflow.android.resources.ARSCFileParser;
import soot.jimple.infoflow.android.resources.LayoutControl;
import soot.jimple.infoflow.android.source.data.SourceSinkDefinition;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.infoflow.source.ISourceSinkManager;
import soot.jimple.infoflow.source.SourceInfo;
import soot.jimple.toolkits.ide.icfg.BiDiInterproceduralCFG;
import soot.jimple.toolkits.scalar.ConstantPropagatorAndFolder;
import soot.tagkit.IntegerConstantValueTag;
import soot.tagkit.Tag;

public class AndroidSourceSinkManager
implements ISourceSinkManager {
    protected static final String Activity_FindViewById = "<android.app.Activity: android.view.View findViewById(int)>";
    protected static final String View_FindViewById = "<android.app.View: android.view.View findViewById(int)>";
    protected final Map<String, SourceSinkDefinition> sourceMethods;
    protected final Map<String, SourceSinkDefinition> sinkMethods;
    protected final Map<String, SootMethodAndClass> callbackMethods;
    protected final LayoutMatchingMode layoutMatching;
    protected final Map<Integer, LayoutControl> layoutControls;
    protected List<ARSCFileParser.ResPackage> resourcePackages;
    protected String appPackageName = "";
    protected boolean enableCallbackSources = true;
    protected final Set<SootMethod> analyzedLayoutMethods = new HashSet<SootMethod>();
    protected SootClass[] iccBaseClasses = null;
    protected final LoadingCache<SootClass, Collection<SootClass>> interfacesOf = IDESolver.DEFAULT_CACHE_BUILDER.build(new CacheLoader<SootClass, Collection<SootClass>>(){

        @Override
        public Collection<SootClass> load(SootClass sc) throws Exception {
            HashSet<SootClass> set2 = new HashSet<SootClass>(sc.getInterfaceCount());
            for (SootClass i : sc.getInterfaces()) {
                set2.add(i);
                set2.addAll(AndroidSourceSinkManager.this.interfacesOf.getUnchecked(i));
            }
            if (sc.hasSuperclass()) {
                set2.addAll(AndroidSourceSinkManager.this.interfacesOf.getUnchecked(sc.getSuperclass()));
            }
            return set2;
        }
    });
    protected final LoadingCache<SootMethod, String> methodToSignature = IDESolver.DEFAULT_CACHE_BUILDER.build(new CacheLoader<SootMethod, String>(){

        @Override
        public String load(SootMethod sm) throws Exception {
            return sm.getSignature();
        }
    });

    public AndroidSourceSinkManager(Set<SourceSinkDefinition> sources, Set<SourceSinkDefinition> sinks) {
        this(sources, sinks, Collections.emptySet(), LayoutMatchingMode.NoMatch, null);
    }

    public AndroidSourceSinkManager(Set<SourceSinkDefinition> sources, Set<SourceSinkDefinition> sinks, Set<SootMethodAndClass> callbackMethods, LayoutMatchingMode layoutMatching, Map<Integer, LayoutControl> layoutControls) {
        this.sourceMethods = new HashMap<String, SourceSinkDefinition>();
        for (SourceSinkDefinition sourceSinkDefinition : sources) {
            this.sourceMethods.put(sourceSinkDefinition.getMethod().getSignature(), sourceSinkDefinition);
        }
        this.sinkMethods = new HashMap<String, SourceSinkDefinition>();
        for (SourceSinkDefinition sourceSinkDefinition : sinks) {
            this.sinkMethods.put(sourceSinkDefinition.getMethod().getSignature(), sourceSinkDefinition);
        }
        this.callbackMethods = new HashMap<String, SootMethodAndClass>();
        for (SootMethodAndClass sootMethodAndClass : callbackMethods) {
            this.callbackMethods.put(sootMethodAndClass.getSignature(), sootMethodAndClass);
        }
        this.layoutMatching = layoutMatching;
        this.layoutControls = layoutControls;
        System.out.println("Created a SourceSinkManager with " + this.sourceMethods.size() + " sources, " + this.sinkMethods.size() + " sinks, and " + this.callbackMethods.size() + " callback methods.");
    }

    public void setEnableCallbackSources(boolean enableCallbackSources) {
        this.enableCallbackSources = enableCallbackSources;
    }

    @Override
    public boolean isSink(Stmt sCallSite, InterproceduralCFG<Unit, SootMethod> cfg, AccessPath ap) {
        String signature;
        if (!sCallSite.containsInvokeExpr()) {
            return false;
        }
        if (this.iccBaseClasses == null) {
            this.iccBaseClasses = new SootClass[]{Scene.v().getSootClass("android.content.Context"), Scene.v().getSootClass("android.content.ContentResolver"), Scene.v().getSootClass("android.app.Activity")};
        }
        SootMethod callee = sCallSite.getInvokeExpr().getMethod();
        SootClass sc = callee.getDeclaringClass();
        String subSig = callee.getSubSignature();
        if (!sc.isInterface()) {
            for (SootClass clazz : this.iccBaseClasses) {
                if (!Scene.v().getOrMakeFastHierarchy().isSubclass(sc, clazz) || !clazz.declaresMethod(subSig)) continue;
                if (!this.sinkMethods.containsKey(this.methodToSignature.getUnchecked(clazz.getMethod(subSig)))) break;
                return true;
            }
        }
        if (this.sinkMethods.containsKey(signature = this.methodToSignature.getUnchecked(sCallSite.getInvokeExpr().getMethod()))) {
            return true;
        }
        for (SootClass i : this.interfacesOf.getUnchecked(sCallSite.getInvokeExpr().getMethod().getDeclaringClass())) {
            if (!i.declaresMethod(subSig) || !this.sinkMethods.containsKey(this.methodToSignature.getUnchecked(i.getMethod(subSig)))) continue;
            return true;
        }
        return false;
    }

    @Override
    public SourceInfo getSourceInfo(Stmt sCallSite, InterproceduralCFG<Unit, SootMethod> cfg) {
        SourceType type = this.getSourceType(sCallSite, cfg);
        if (type == SourceType.NoSource) {
            return null;
        }
        return this.getSourceInfo(sCallSite, type);
    }

    protected SourceInfo getSourceInfo(Stmt sCallSite, SourceType type) {
        if (type == SourceType.UISource || type == SourceType.Callback) {
            if (sCallSite instanceof DefinitionStmt) {
                DefinitionStmt defStmt = (DefinitionStmt)sCallSite;
                return new SourceInfo(new AccessPath(defStmt.getLeftOp(), true));
            }
            return null;
        }
        if (!sCallSite.containsInvokeExpr()) {
            return null;
        }
        if (sCallSite instanceof DefinitionStmt && sCallSite.getInvokeExpr().getMethod().getReturnType() != null) {
            DefinitionStmt defStmt = (DefinitionStmt)sCallSite;
            return new SourceInfo(new AccessPath(defStmt.getLeftOp(), true));
        }
        if (sCallSite.getInvokeExpr() instanceof InstanceInvokeExpr) {
            InstanceInvokeExpr iinv = (InstanceInvokeExpr)sCallSite.getInvokeExpr();
            return new SourceInfo(new AccessPath(iinv.getBase(), true));
        }
        return null;
    }

    protected SourceType getSourceType(Stmt sCallSite, InterproceduralCFG<Unit, SootMethod> cfg) {
        assert (cfg != null);
        assert (cfg instanceof BiDiInterproceduralCFG);
        if (sCallSite.containsInvokeExpr()) {
            String signature = this.methodToSignature.getUnchecked(sCallSite.getInvokeExpr().getMethod());
            if (this.sourceMethods.containsKey(signature)) {
                return SourceType.MethodCall;
            }
            String subSig = sCallSite.getInvokeExpr().getMethod().getSubSignature();
            for (SootClass i : this.interfacesOf.getUnchecked(sCallSite.getInvokeExpr().getMethod().getDeclaringClass())) {
                if (!i.declaresMethod(subSig) || !this.sinkMethods.containsKey(this.methodToSignature.getUnchecked(i.getMethod(subSig)))) continue;
                return SourceType.MethodCall;
            }
        }
        if (this.isUISource(sCallSite, cfg)) {
            return SourceType.UISource;
        }
        if (this.enableCallbackSources) {
            IdentityStmt is2;
            String callSiteSignature = this.methodToSignature.getUnchecked(cfg.getMethodOf(sCallSite));
            if (sCallSite instanceof IdentityStmt && (is2 = (IdentityStmt)sCallSite).getRightOp() instanceof ParameterRef && this.callbackMethods.containsKey(callSiteSignature)) {
                return SourceType.Callback;
            }
        }
        return SourceType.NoSource;
    }

    private boolean isUISource(Stmt sCallSite, InterproceduralCFG<Unit, SootMethod> cfg) {
        InvokeExpr ie;
        String signature;
        if (this.layoutMatching != LayoutMatchingMode.NoMatch && sCallSite.containsInvokeExpr() && ((signature = this.methodToSignature.getUnchecked((ie = sCallSite.getInvokeExpr()).getMethod())).equals(Activity_FindViewById) || signature.equals(View_FindViewById))) {
            SootMethod uiMethod = cfg.getMethodOf(sCallSite);
            if (this.analyzedLayoutMethods.add(uiMethod)) {
                ConstantPropagatorAndFolder.v().transform(uiMethod.getActiveBody());
            }
            if (this.layoutMatching == LayoutMatchingMode.MatchAll) {
                return true;
            }
            if (this.layoutControls == null) {
                return false;
            }
            if (ie.getArgCount() != 1) {
                System.err.println("Framework method call with unexpected number of arguments");
                return false;
            }
            int id = 0;
            if (ie.getArg(0) instanceof IntConstant) {
                id = ((IntConstant)ie.getArg((int)0)).value;
            } else if (ie.getArg(0) instanceof Local) {
                Integer idVal = this.findLastResIDAssignment(sCallSite, (Local)ie.getArg(0), (BiDiInterproceduralCFG)cfg, new HashSet<Stmt>(cfg.getMethodOf(sCallSite).getActiveBody().getUnits().size()));
                if (idVal == null) {
                    System.err.println("Could not find assignment to local " + ((Local)ie.getArg(0)).getName() + " in method " + cfg.getMethodOf(sCallSite).getSignature());
                    return false;
                }
                id = idVal;
            } else {
                System.err.println("Framework method call with unexpected parameter type: " + ie.toString() + ", " + "first parameter is of type " + ie.getArg(0).getClass());
                return false;
            }
            LayoutControl control = this.layoutControls.get(id);
            if (control == null) {
                System.err.println("Layout control with ID " + id + " not found");
                return false;
            }
            if (this.layoutMatching == LayoutMatchingMode.MatchSensitiveOnly && control.isSensitive()) {
                return true;
            }
        }
        return false;
    }

    private Integer findLastResIDAssignment(Stmt stmt, Local local, BiDiInterproceduralCFG<Unit, SootMethod> cfg, Set<Stmt> doneSet) {
        AssignStmt assign;
        if (!doneSet.add(stmt)) {
            return null;
        }
        if (stmt instanceof AssignStmt && (assign = (AssignStmt)stmt).getLeftOp() == local) {
            InvokeExpr inv;
            if (assign.getRightOp() instanceof IntConstant) {
                return ((IntConstant)assign.getRightOp()).value;
            }
            if (assign.getRightOp() instanceof FieldRef) {
                SootField field2 = ((FieldRef)assign.getRightOp()).getField();
                for (Tag tag : field2.getTags()) {
                    if (tag instanceof IntegerConstantValueTag) {
                        return ((IntegerConstantValueTag)tag).getIntValue();
                    }
                    System.err.println("Constant " + field2 + " was of unexpected type");
                }
            } else if (assign.getRightOp() instanceof InvokeExpr && (inv = (InvokeExpr)assign.getRightOp()).getMethod().getName().equals("getIdentifier") && inv.getMethod().getDeclaringClass().getName().equals("android.content.res.Resources") && this.resourcePackages != null) {
                if (inv.getArgCount() != 3) {
                    System.err.println("Invalid parameter count for call to getIdentifier");
                    return null;
                }
                String resName = "";
                String resID = "";
                String packageName = "";
                if (inv.getArg(0) instanceof StringConstant) {
                    resName = ((StringConstant)inv.getArg((int)0)).value;
                }
                if (inv.getArg(1) instanceof StringConstant) {
                    resID = ((StringConstant)inv.getArg((int)1)).value;
                }
                if (inv.getArg(2) instanceof StringConstant) {
                    packageName = ((StringConstant)inv.getArg((int)2)).value;
                } else if (inv.getArg(2) instanceof Local) {
                    packageName = this.findLastStringAssignment(stmt, (Local)inv.getArg(2), cfg);
                } else {
                    System.err.println("Unknown parameter type in call to getIdentifier");
                    return null;
                }
                ARSCFileParser.AbstractResource res = this.findResource(resName, resID, packageName);
                if (res != null) {
                    return res.getResourceID();
                }
            }
        }
        for (Unit pred : cfg.getPredsOf(stmt)) {
            Integer lastAssignment;
            if (!(pred instanceof Stmt) || (lastAssignment = this.findLastResIDAssignment((Stmt)pred, local, cfg, doneSet)) == null) continue;
            return lastAssignment;
        }
        return null;
    }

    private ARSCFileParser.AbstractResource findResource(String resName, String resID, String packageName) {
        for (ARSCFileParser.ResPackage pkg : this.resourcePackages) {
            boolean matches;
            boolean bl = matches = (packageName == null || packageName.isEmpty()) && pkg.getPackageName().equals(this.appPackageName);
            if (!(matches |= pkg.getPackageName().equals(packageName))) continue;
            for (ARSCFileParser.ResType type : pkg.getDeclaredTypes()) {
                if (!type.getTypeName().equals(resID)) continue;
                ARSCFileParser.AbstractResource res = type.getFirstResource(resName);
                return res;
            }
        }
        return null;
    }

    private String findLastStringAssignment(Stmt stmt, Local local, BiDiInterproceduralCFG<Unit, SootMethod> cfg) {
        AssignStmt assign;
        if (stmt instanceof AssignStmt && (assign = (AssignStmt)stmt).getLeftOp() == local && assign.getRightOp() instanceof StringConstant) {
            return ((StringConstant)assign.getRightOp()).value;
        }
        for (Unit pred : cfg.getPredsOf(stmt)) {
            String lastAssignment;
            if (!(pred instanceof Stmt) || (lastAssignment = this.findLastStringAssignment((Stmt)pred, local, cfg)) == null) continue;
            return lastAssignment;
        }
        return null;
    }

    public void addSink(Set<SourceSinkDefinition> sinks) {
        for (SourceSinkDefinition am : sinks) {
            this.sinkMethods.put(am.getMethod().getSignature(), am);
        }
    }

    public void setResourcePackages(List<ARSCFileParser.ResPackage> resourcePackages) {
        this.resourcePackages = resourcePackages;
    }

    public void setAppPackageName(String appPackageName) {
        this.appPackageName = appPackageName;
    }

    public static enum SourceType {
        NoSource,
        MethodCall,
        Callback,
        UISource;

    }

    public static enum LayoutMatchingMode {
        NoMatch,
        MatchAll,
        MatchSensitiveOnly;

    }
}

