/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.data.parsers;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import soot.jimple.infoflow.android.data.AndroidMethod;
import soot.jimple.infoflow.android.source.data.ISourceSinkDefinitionProvider;
import soot.jimple.infoflow.android.source.data.SourceSinkDefinition;

public class PScoutPermissionMethodParser
implements ISourceSinkDefinitionProvider {
    private static final int INITIAL_SET_SIZE = 10000;
    private Set<SourceSinkDefinition> sourceList = null;
    private Set<SourceSinkDefinition> sinkList = null;
    private Set<SourceSinkDefinition> neitherList = null;
    private final String fileName;
    private final String regex = "^<(.+):\\s*(.+)\\s+(.+)\\s*\\((.*)\\)>.+?(->.+)?$";
    private final boolean SET_IMPLICIT_SOURCE_TO_SOURCE = false;
    private final boolean SET_INDIRECT_SINK_TO_SINK = false;

    public PScoutPermissionMethodParser(String filename) {
        this.fileName = filename;
    }

    private void parse() {
        this.sourceList = new HashSet<SourceSinkDefinition>(10000);
        this.sinkList = new HashSet<SourceSinkDefinition>(10000);
        this.neitherList = new HashSet<SourceSinkDefinition>(10000);
        BufferedReader rdr = this.readFile();
        String line = null;
        Pattern p = Pattern.compile("^<(.+):\\s*(.+)\\s+(.+)\\s*\\((.*)\\)>.+?(->.+)?$");
        String currentPermission = null;
        try {
            while ((line = rdr.readLine()) != null) {
                AndroidMethod singleMethod;
                if (line.startsWith("Permission:")) {
                    currentPermission = line.substring(11);
                    continue;
                }
                Matcher m = p.matcher(line);
                if (!m.find() || (singleMethod = this.parseMethod(m, currentPermission)) == null) continue;
                if (singleMethod.isSource()) {
                    this.addToList(this.sourceList, singleMethod, currentPermission);
                    continue;
                }
                if (singleMethod.isSink()) {
                    this.addToList(this.sinkList, singleMethod, currentPermission);
                    continue;
                }
                if (!singleMethod.isNeitherNor()) continue;
                this.addToList(this.neitherList, singleMethod, currentPermission);
            }
            if (rdr != null) {
                rdr.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addToList(Set<SourceSinkDefinition> sourceList, AndroidMethod singleMethod, String currentPermission) {
        SourceSinkDefinition def = new SourceSinkDefinition(singleMethod);
        if (!sourceList.add(def)) {
            for (SourceSinkDefinition ssdef : sourceList) {
                if (!ssdef.getMethod().equals(singleMethod)) continue;
                singleMethod.addPermission(currentPermission);
                break;
            }
        }
    }

    @Override
    public Set<SourceSinkDefinition> getSources() {
        if (this.sourceList == null || this.sinkList == null) {
            this.parse();
        }
        return this.sourceList;
    }

    @Override
    public Set<SourceSinkDefinition> getSinks() {
        if (this.sourceList == null || this.sinkList == null) {
            this.parse();
        }
        return this.sinkList;
    }

    private BufferedReader readFile() {
        FileReader fr = null;
        BufferedReader br = null;
        try {
            fr = new FileReader(this.fileName);
            br = new BufferedReader(fr);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        return br;
    }

    private AndroidMethod parseMethod(Matcher m, String currentPermission) {
        String params;
        assert (m.group(1) != null && m.group(2) != null && m.group(3) != null && m.group(4) != null);
        int groupIdx = 1;
        String className = m.group(groupIdx++).trim();
        String returnType = m.group(groupIdx++).trim();
        String methodName = m.group(groupIdx++).trim();
        ArrayList<String> methodParameters = new ArrayList<String>();
        if (!(params = m.group(groupIdx++).trim()).isEmpty()) {
            for (String parameter : params.split(",")) {
                methodParameters.add(parameter.trim());
            }
        }
        HashSet<String> permissions = new HashSet<String>();
        permissions.add(currentPermission);
        AndroidMethod singleMethod = new AndroidMethod(methodName, methodParameters, returnType, className, permissions);
        if (m.group(5) != null) {
            String targets = m.group(5).substring(3);
            for (String target : targets.split(" ")) {
                String cat2;
                if (target.startsWith("_SOURCE_")) {
                    singleMethod.setSource(true);
                    if (!target.contains("|")) continue;
                    cat2 = target.substring(target.indexOf(124) + 1);
                    singleMethod.setCategory(this.returnCorrectCategory(cat2));
                    continue;
                }
                if (target.startsWith("_SINK_")) {
                    singleMethod.setSink(true);
                    if (!target.contains("|")) continue;
                    cat2 = target.substring(target.indexOf(124) + 1);
                    singleMethod.setCategory(this.returnCorrectCategory(cat2));
                    continue;
                }
                if (target.equals("_NONE_")) {
                    singleMethod.setNeitherNor(true);
                    continue;
                }
                if (target.startsWith("_IMPSOURCE_")) {
                    singleMethod.setNeitherNor(true);
                    continue;
                }
                if (target.startsWith("_INDSINK_")) {
                    singleMethod.setNeitherNor(true);
                    continue;
                }
                if (target.equals("_IGNORE_")) {
                    return null;
                }
                if (target.startsWith("-")) {
                    cat2 = target.substring(target.indexOf(124) + 1);
                    singleMethod.setCategory(this.returnCorrectCategory(cat2));
                    continue;
                }
                throw new RuntimeException("error in target definition");
            }
        }
        return singleMethod;
    }

    private AndroidMethod.CATEGORY returnCorrectCategory(String category) {
        if (category.equals("_NO_CATEGORY_")) {
            return AndroidMethod.CATEGORY.NO_CATEGORY;
        }
        if (category.equals("_HARDWARE_INFO_")) {
            return AndroidMethod.CATEGORY.HARDWARE_INFO;
        }
        if (category.equals("_NFC_")) {
            return AndroidMethod.CATEGORY.NFC;
        }
        if (category.equals("_PHONE_CONNECTION_")) {
            return AndroidMethod.CATEGORY.PHONE_CONNECTION;
        }
        if (category.equals("_INTER_APP_COMMUNICATION_")) {
            return AndroidMethod.CATEGORY.INTER_APP_COMMUNICATION;
        }
        if (category.equals("_VOIP_")) {
            return AndroidMethod.CATEGORY.VOIP;
        }
        if (category.equals("_CONTACT_INFORMATION_")) {
            return AndroidMethod.CATEGORY.CONTACT_INFORMATION;
        }
        if (category.equals("_UNIQUE_IDENTIFIER_")) {
            return AndroidMethod.CATEGORY.UNIQUE_IDENTIFIER;
        }
        if (category.equals("_PHONE_STATE_")) {
            return AndroidMethod.CATEGORY.PHONE_STATE;
        }
        if (category.equals("_SYSTEM_SETTINGS_")) {
            return AndroidMethod.CATEGORY.SYSTEM_SETTINGS;
        }
        if (category.equals("_LOCATION_INFORMATION_")) {
            return AndroidMethod.CATEGORY.LOCATION_INFORMATION;
        }
        if (category.equals("_NETWORK_INFORMATION_")) {
            return AndroidMethod.CATEGORY.NETWORK_INFORMATION;
        }
        if (category.equals("_EMAIL_")) {
            return AndroidMethod.CATEGORY.EMAIL;
        }
        if (category.equals("_SMS_MMS_")) {
            return AndroidMethod.CATEGORY.SMS_MMS;
        }
        if (category.equals("_CALENDAR_INFORMATION_")) {
            return AndroidMethod.CATEGORY.CALENDAR_INFORMATION;
        }
        if (category.equals("_ACCOUNT_INFORMATION_")) {
            return AndroidMethod.CATEGORY.ACCOUNT_INFORMATION;
        }
        if (category.equals("_BLUETOOTH_")) {
            return AndroidMethod.CATEGORY.BLUETOOTH;
        }
        if (category.equals("_ACCOUNT_SETTINGS_")) {
            return AndroidMethod.CATEGORY.ACCOUNT_SETTINGS;
        }
        if (category.equals("_VIDEO_")) {
            return AndroidMethod.CATEGORY.VIDEO;
        }
        if (category.equals("_AUDIO_")) {
            return AndroidMethod.CATEGORY.AUDIO;
        }
        if (category.equals("_SYNCHRONIZATION_DATA_")) {
            return AndroidMethod.CATEGORY.SYNCHRONIZATION_DATA;
        }
        if (category.equals("_NETWORK_")) {
            return AndroidMethod.CATEGORY.NETWORK;
        }
        if (category.equals("_EMAIL_SETTINGS_")) {
            return AndroidMethod.CATEGORY.EMAIL_SETTINGS;
        }
        if (category.equals("_EMAIL_INFORMATION_")) {
            return AndroidMethod.CATEGORY.EMAIL_INFORMATION;
        }
        if (category.equals("_IMAGE_")) {
            return AndroidMethod.CATEGORY.IMAGE;
        }
        if (category.equals("_FILE_INFORMATION_")) {
            return AndroidMethod.CATEGORY.FILE_INFORMATION;
        }
        if (category.equals("_BLUETOOTH_INFORMATION_")) {
            return AndroidMethod.CATEGORY.BLUETOOTH_INFORMATION;
        }
        if (category.equals("_BROWSER_INFORMATION_")) {
            return AndroidMethod.CATEGORY.BROWSER_INFORMATION;
        }
        if (category.equals("_FILE_")) {
            return AndroidMethod.CATEGORY.FILE;
        }
        if (category.equals("_VOIP_INFORMATION_")) {
            return AndroidMethod.CATEGORY.VOIP_INFORMATION;
        }
        if (category.equals("_DATABASE_INFORMATION_")) {
            return AndroidMethod.CATEGORY.DATABASE_INFORMATION;
        }
        if (category.equals("_PHONE_INFORMATION_")) {
            return AndroidMethod.CATEGORY.PHONE_INFORMATION;
        }
        if (category.equals("_LOG_")) {
            return AndroidMethod.CATEGORY.LOG;
        }
        throw new RuntimeException("The category -" + category + "- is not supported!");
    }

    @Override
    public Set<SourceSinkDefinition> getAllMethods() {
        HashSet<SourceSinkDefinition> sourcesSinks = new HashSet<SourceSinkDefinition>(this.sourceList.size() + this.sinkList.size() + this.neitherList.size());
        sourcesSinks.addAll(this.sourceList);
        sourcesSinks.addAll(this.sinkList);
        sourcesSinks.addAll(this.neitherList);
        return sourcesSinks;
    }
}

