/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.data.parsers;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import soot.jimple.infoflow.android.data.AndroidMethod;

public class CategorizedAndroidSourceSinkParser {
    private Set<AndroidMethod.CATEGORY> categories;
    private final String fileName;
    private boolean isSources;
    private boolean isSinks;
    private final String regex = "^<(.+):\\s*(.+)\\s+(.+)\\s*\\((.*)\\)>.+?\\((.+)\\)$";

    public CategorizedAndroidSourceSinkParser(Set<AndroidMethod.CATEGORY> categories, String filename, boolean isSources, boolean isSinks) {
        this.categories = categories;
        this.fileName = filename;
        this.isSources = isSources;
        this.isSinks = isSinks;
    }

    public Set<AndroidMethod> parse() throws IOException {
        HashSet<AndroidMethod> methods = new HashSet<AndroidMethod>();
        BufferedReader rdr = this.readFile();
        if (rdr == null) {
            throw new RuntimeException("Could not read source/sink file");
        }
        String line = null;
        Pattern p = Pattern.compile("^<(.+):\\s*(.+)\\s+(.+)\\s*\\((.*)\\)>.+?\\((.+)\\)$");
        while ((line = rdr.readLine()) != null) {
            Matcher m = p.matcher(line);
            if (!m.find()) continue;
            AndroidMethod.CATEGORY cat2 = AndroidMethod.CATEGORY.valueOf(m.group(5));
            if (!this.categories.contains((Object)AndroidMethod.CATEGORY.ALL) && !this.categories.contains((Object)cat2)) continue;
            AndroidMethod method = this.parseMethod(m);
            method.setCategory(cat2);
            if (this.isSources) {
                method.setSource(true);
            } else if (this.isSinks) {
                method.setSink(true);
            } else {
                throw new RuntimeException("Oops, something went all wonky!");
            }
            methods.add(method);
        }
        try {
            if (rdr != null) {
                rdr.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return methods;
    }

    private BufferedReader readFile() {
        FileReader fr = null;
        BufferedReader br = null;
        try {
            fr = new FileReader(this.fileName);
            br = new BufferedReader(fr);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        return br;
    }

    private AndroidMethod parseMethod(Matcher m) {
        String params;
        assert (m.group(1) != null && m.group(2) != null && m.group(3) != null && m.group(4) != null);
        int groupIdx = 1;
        String className = m.group(groupIdx++).trim();
        String returnType = m.group(groupIdx++).trim();
        String methodName = m.group(groupIdx++).trim();
        ArrayList<String> methodParameters = new ArrayList<String>();
        if (!(params = m.group(groupIdx++).trim()).isEmpty()) {
            for (String parameter : params.split(",")) {
                methodParameters.add(parameter.trim());
            }
        }
        return new AndroidMethod(methodName, methodParameters, returnType, className);
    }
}

