/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.UnsupportedDataTypeException;
import org.k33nteam.JadeCfg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;
import soot.G;
import soot.Main;
import soot.PackManager;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.jimple.infoflow.IInfoflow;
import soot.jimple.infoflow.Infoflow;
import soot.jimple.infoflow.android.AnalyzeJimpleClass;
import soot.jimple.infoflow.android.config.SootConfigForAndroid;
import soot.jimple.infoflow.android.data.AndroidMethod;
import soot.jimple.infoflow.android.data.parsers.PermissionMethodParser;
import soot.jimple.infoflow.android.manifest.ProcessManifest;
import soot.jimple.infoflow.android.resources.ARSCFileParser;
import soot.jimple.infoflow.android.resources.LayoutControl;
import soot.jimple.infoflow.android.resources.LayoutFileParser;
import soot.jimple.infoflow.android.source.AccessPathBasedSourceSinkManager;
import soot.jimple.infoflow.android.source.AndroidSourceSinkManager;
import soot.jimple.infoflow.android.source.data.ISourceSinkDefinitionProvider;
import soot.jimple.infoflow.android.source.data.SourceSinkDefinition;
import soot.jimple.infoflow.android.source.parsers.xml.XMLSourceSinkParser;
import soot.jimple.infoflow.cfg.BiDirICFGFactory;
import soot.jimple.infoflow.config.IInfoflowConfig;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.infoflow.data.pathBuilders.DefaultPathBuilderFactory;
import soot.jimple.infoflow.entryPointCreators.AndroidEntryPointCreator;
import soot.jimple.infoflow.handlers.ResultsAvailableHandler;
import soot.jimple.infoflow.ipc.IIPCManager;
import soot.jimple.infoflow.results.InfoflowResults;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.infoflow.source.ISourceSinkManager;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.options.Options;

public class SetupApplication {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ISourceSinkDefinitionProvider sourceSinkProvider;
    private final Map<String, Set<SootMethodAndClass>> callbackMethods = new HashMap<String, Set<SootMethodAndClass>>(10000);
    private boolean stopAfterFirstFlow = false;
    private boolean enableImplicitFlows = false;
    private boolean enableStaticFields = true;
    private boolean enableExceptions = true;
    private boolean enableCallbacks = true;
    private boolean flowSensitiveAliasing = true;
    private boolean ignoreFlowsInSystemPackages = true;
    private boolean enableCallbackSources = true;
    private boolean computeResultPaths = true;
    private int accessPathLength = 5;
    private AndroidSourceSinkManager.LayoutMatchingMode layoutMatchingMode = AndroidSourceSinkManager.LayoutMatchingMode.MatchSensitiveOnly;
    private IInfoflow.CallgraphAlgorithm callgraphAlgorithm = IInfoflow.CallgraphAlgorithm.AutomaticSelection;
    private Set<String> entrypoints = null;
    private Set<String> callbackClasses = null;
    private List<ARSCFileParser.ResPackage> resourcePackages = null;
    private String appPackageName = "";
    private String androidJar;
    private boolean forceAndroidJar;
    private final String apkFileLocation;
    private ITaintPropagationWrapper taintWrapper;
    private DefaultPathBuilderFactory.PathBuilder pathBuilder = DefaultPathBuilderFactory.PathBuilder.ContextInsensitiveSourceFinder;
    private AccessPathBasedSourceSinkManager sourceSinkManager = null;
    private AndroidEntryPointCreator entryPointCreator = null;
    private IInfoflowConfig sootConfig = null;
    private BiDirICFGFactory cfgFactory = null;
    private IIPCManager ipcManager = null;
    private long maxMemoryConsumption = -1L;
    private IInfoflow.CodeEliminationMode codeEliminationMode = IInfoflow.CodeEliminationMode.RemoveSideEffectFreeCode;
    private IInfoflowCFG icfg;

    public SetupApplication(String androidJar, String apkFileLocation) {
        File f = new File(androidJar);
        this.forceAndroidJar = f.isFile();
        this.androidJar = androidJar;
        this.apkFileLocation = apkFileLocation;
        this.ipcManager = null;
    }

    public SetupApplication(String androidJar, String apkFileLocation, IIPCManager ipcManager) {
        this(androidJar, apkFileLocation);
        this.ipcManager = ipcManager;
    }

    public Set<SourceSinkDefinition> getSinks() {
        return this.sourceSinkProvider == null ? null : this.sourceSinkProvider.getSinks();
    }

    public void printSinks() {
        if (this.sourceSinkProvider == null) {
            System.err.println("Sinks not calculated yet");
            return;
        }
        System.out.println("Sinks:");
        for (SourceSinkDefinition am : this.getSinks()) {
            System.out.println(am.toString());
        }
        System.out.println("End of Sinks");
    }

    public Set<SourceSinkDefinition> getSources() {
        return this.sourceSinkProvider == null ? null : this.sourceSinkProvider.getSources();
    }

    public void printSources() {
        if (this.sourceSinkProvider == null) {
            System.err.println("Sources not calculated yet");
            return;
        }
        System.out.println("Sources:");
        for (SourceSinkDefinition am : this.getSources()) {
            System.out.println(am.toString());
        }
        System.out.println("End of Sources");
    }

    public Set<String> getEntrypointClasses() {
        return this.entrypoints;
    }

    public void printEntrypoints() {
        if (this.entrypoints == null) {
            System.out.println("Entry points not initialized");
        } else {
            System.out.println("Classes containing entry points:");
            for (String className : this.entrypoints) {
                System.out.println("\t" + className);
            }
            System.out.println("End of Entrypoints");
        }
    }

    public void setCallbackClasses(Set<String> callbackClasses) {
        this.callbackClasses = callbackClasses;
    }

    public Set<String> getCallbackClasses() {
        return this.callbackClasses;
    }

    public void setTaintWrapper(ITaintPropagationWrapper taintWrapper) {
        this.taintWrapper = taintWrapper;
    }

    public ITaintPropagationWrapper getTaintWrapper() {
        return this.taintWrapper;
    }

    public void calculateSourcesSinksEntrypoints(Set<AndroidMethod> sources, Set<AndroidMethod> sinks) throws IOException, XmlPullParserException {
        final HashSet<SourceSinkDefinition> sourceDefs = new HashSet<SourceSinkDefinition>(sources.size());
        final HashSet<SourceSinkDefinition> sinkDefs = new HashSet<SourceSinkDefinition>(sinks.size());
        for (AndroidMethod am : sources) {
            sourceDefs.add(new SourceSinkDefinition(am));
        }
        for (AndroidMethod am : sinks) {
            sinkDefs.add(new SourceSinkDefinition(am));
        }
        ISourceSinkDefinitionProvider parser2 = new ISourceSinkDefinitionProvider(){

            @Override
            public Set<SourceSinkDefinition> getSources() {
                return sourceDefs;
            }

            @Override
            public Set<SourceSinkDefinition> getSinks() {
                return sinkDefs;
            }

            @Override
            public Set<SourceSinkDefinition> getAllMethods() {
                HashSet<SourceSinkDefinition> sourcesSinks = new HashSet<SourceSinkDefinition>(sourceDefs.size() + sinkDefs.size());
                sourcesSinks.addAll(sourceDefs);
                sourcesSinks.addAll(sinkDefs);
                return sourcesSinks;
            }
        };
        this.calculateSourcesSinksEntrypoints(parser2);
    }

    public void calculateSourcesSinksEntrypoints(String sourceSinkFile) throws IOException, XmlPullParserException {
        ISourceSinkDefinitionProvider parser2 = null;
        String fileExtension = sourceSinkFile.substring(sourceSinkFile.lastIndexOf("."));
        if ((fileExtension = fileExtension.toLowerCase()).equals(".xml")) {
            parser2 = XMLSourceSinkParser.fromFile(sourceSinkFile);
        } else if (fileExtension.equals(".txt")) {
            parser2 = PermissionMethodParser.fromFile(sourceSinkFile);
        } else {
            throw new UnsupportedDataTypeException("The Inputfile isn't a .txt or .xml file.");
        }
        this.calculateSourcesSinksEntrypoints(parser2);
    }

    public void calculateSourcesSinksEntrypoints(ISourceSinkDefinitionProvider sourcesAndSinks) throws IOException, XmlPullParserException {
        this.sourceSinkProvider = sourcesAndSinks;
        ProcessManifest processMan = new ProcessManifest(this.apkFileLocation);
        this.appPackageName = processMan.getPackageName();
        this.entrypoints = processMan.getEntryPointClasses();
        long beforeARSC = System.nanoTime();
        ARSCFileParser resParser = new ARSCFileParser();
        resParser.parse(this.apkFileLocation);
        this.logger.info("ARSC file parsing took " + (double)(System.nanoTime() - beforeARSC) / 1.0E9 + " seconds");
        this.resourcePackages = resParser.getPackages();
        LayoutFileParser lfp = null;
        if (this.enableCallbacks) {
            lfp = new LayoutFileParser(this.appPackageName, resParser);
            this.calculateCallbackMethods(resParser, lfp);
            System.out.println("Found " + lfp.getUserControls() + " layout controls");
        }
        System.out.println("Entry point calculation done.");
        G.reset();
        HashSet<SootMethodAndClass> callbacks = new HashSet<SootMethodAndClass>();
        for (Set<SootMethodAndClass> methods : this.callbackMethods.values()) {
            callbacks.addAll(methods);
        }
        this.sourceSinkManager = new AccessPathBasedSourceSinkManager(this.sourceSinkProvider.getSources(), this.sourceSinkProvider.getSinks(), callbacks, this.layoutMatchingMode, lfp == null ? null : lfp.getUserControlsByID());
        this.sourceSinkManager.setAppPackageName(this.appPackageName);
        this.sourceSinkManager.setResourcePackages(this.resourcePackages);
        this.sourceSinkManager.setEnableCallbackSources(this.enableCallbackSources);
        this.entryPointCreator = this.createEntryPointCreator();
    }

    private void addCallbackMethod(String layoutClass, AndroidMethod callbackMethod) {
        Set<SootMethodAndClass> methods = this.callbackMethods.get(layoutClass);
        if (methods == null) {
            methods = new HashSet<SootMethodAndClass>();
            this.callbackMethods.put(layoutClass, methods);
        }
        methods.add(new AndroidMethod(callbackMethod));
    }

    private void calculateCallbackMethods(ARSCFileParser resParser, LayoutFileParser lfp) throws IOException {
        AnalyzeJimpleClass jimpleClass = null;
        boolean hasChanged = true;
        while (hasChanged) {
            hasChanged = false;
            G.reset();
            this.initializeSoot();
            this.createMainMethod();
            if (jimpleClass == null) {
                jimpleClass = this.callbackClasses == null ? new AnalyzeJimpleClass(this.entrypoints) : new AnalyzeJimpleClass(this.entrypoints, this.callbackClasses);
                jimpleClass.collectCallbackMethods();
                lfp.parseLayoutFile(this.apkFileLocation, this.entrypoints);
            } else {
                jimpleClass.collectCallbackMethodsIncremental();
            }
            PackManager.v().getPack("wjpp").apply();
            PackManager.v().getPack("cg").apply();
            PackManager.v().getPack("wjtp").apply();
            for (Map.Entry<String, Set<Object>> entry2 : jimpleClass.getCallbackMethods().entrySet()) {
                if (this.callbackMethods.containsKey(entry2.getKey())) {
                    if (!this.callbackMethods.get(entry2.getKey()).addAll((Collection<SootMethodAndClass>)entry2.getValue())) continue;
                    hasChanged = true;
                    continue;
                }
                this.callbackMethods.put(entry2.getKey(), new HashSet(entry2.getValue()));
                hasChanged = true;
            }
            if (!this.entrypoints.addAll(jimpleClass.getDynamicManifestComponents())) continue;
            hasChanged = true;
        }
        for (Map.Entry<String, Set<Integer>> entry3 : jimpleClass.getLayoutClasses().entrySet()) {
            SootClass callbackClass = Scene.v().getSootClass(entry3.getKey());
            for (Integer classId : entry3.getValue()) {
                ARSCFileParser.AbstractResource resource = resParser.findResource(classId);
                if (resource instanceof ARSCFileParser.StringResource) {
                    Set<LayoutControl> controls;
                    String layoutFileName = ((ARSCFileParser.StringResource)resource).getValue();
                    Set<String> callbackMethods = lfp.getCallbackMethods().get(layoutFileName);
                    if (callbackMethods != null) {
                        block4: for (String methodName : callbackMethods) {
                            String subSig = "void " + methodName + "(android.view.View)";
                            SootClass currentClass = callbackClass;
                            while (true) {
                                SootMethod callbackMethod;
                                if ((callbackMethod = currentClass.getMethodUnsafe(subSig)) != null) {
                                    this.addCallbackMethod(callbackClass.getName(), new AndroidMethod(callbackMethod));
                                    continue block4;
                                }
                                if (!currentClass.hasSuperclass()) {
                                    System.err.println("Callback method " + methodName + " not found in class " + callbackClass.getName());
                                    continue block4;
                                }
                                currentClass = currentClass.getSuperclass();
                            }
                        }
                    }
                    if ((controls = lfp.getUserControls().get(layoutFileName)) == null) continue;
                    for (LayoutControl lc : controls) {
                        this.registerCallbackMethodsForView(callbackClass, lc);
                    }
                    continue;
                }
                System.err.println("Unexpected resource type for layout class");
            }
        }
        HashSet<SootMethodAndClass> callbacksPlain = new HashSet<SootMethodAndClass>();
        for (Set<SootMethodAndClass> set2 : this.callbackMethods.values()) {
            callbacksPlain.addAll(set2);
        }
        System.out.println("Found " + callbacksPlain.size() + " callback methods for " + this.callbackMethods.size() + " components");
    }

    private void registerCallbackMethodsForView(SootClass callbackClass, LayoutControl lc) {
        if (callbackClass.getName().startsWith("android.")) {
            return;
        }
        if (lc.getViewClass().getName().startsWith("android.")) {
            return;
        }
        SootClass sc = lc.getViewClass();
        boolean isView = false;
        while (sc.hasSuperclass()) {
            if (sc.getName().equals("android.view.View")) {
                isView = true;
                break;
            }
            sc = sc.getSuperclass();
        }
        if (!isView) {
            return;
        }
        sc = lc.getViewClass();
        HashSet<String> systemMethods = new HashSet<String>(10000);
        for (SootClass parentClass : Scene.v().getActiveHierarchy().getSuperclassesOf(sc)) {
            if (!parentClass.getName().startsWith("android.")) continue;
            for (SootMethod sm : parentClass.getMethods()) {
                if (sm.isConstructor()) continue;
                systemMethods.add(sm.getSubSignature());
            }
        }
        for (SootMethod sm : sc.getMethods()) {
            if (sm.isConstructor() || !systemMethods.contains(sm.getSubSignature())) continue;
            this.addCallbackMethod(callbackClass.getName(), new AndroidMethod(sm));
        }
    }

    private void createMainMethod() {
        SootMethod entryPoint = this.createEntryPointCreator().createDummyMain();
        Scene.v().setEntryPoints(Collections.singletonList(entryPoint));
        if (Scene.v().containsClass(entryPoint.getDeclaringClass().getName())) {
            Scene.v().removeClass(entryPoint.getDeclaringClass());
        }
        Scene.v().addClass(entryPoint.getDeclaringClass());
    }

    public AccessPathBasedSourceSinkManager getSourceSinkManager() {
        return this.sourceSinkManager;
    }

    private void initializeSoot() {
        Options.v().set_no_bodies_for_excluded(true);
        Options.v().set_allow_phantom_refs(true);
        Options.v().set_output_format(12);
        Options.v().set_whole_program(true);
        if (!JadeCfg.isEnable_apklibs()) {
            Options.v().set_process_dir(Collections.singletonList(this.apkFileLocation));
        } else {
            ArrayList<String> paths = new ArrayList<String>();
            paths.add(this.apkFileLocation);
            File addtionLibPath = new File("tmplibs/");
            if (addtionLibPath.isDirectory()) {
                for (File file : addtionLibPath.listFiles()) {
                    paths.add(file.getAbsolutePath());
                }
            }
            Options.v().set_process_dir(paths);
        }
        if (JadeCfg.isEnable_apklibs()) {
            this.forceAndroidJar = true;
            if (!this.androidJar.endsWith(".jar")) {
                this.androidJar = Scene.v().getAndroidJarPath(this.androidJar, this.apkFileLocation);
            }
        }
        Options.v().set_soot_classpath(this.forceAndroidJar ? this.androidJar : Scene.v().getAndroidJarPath(this.androidJar, this.apkFileLocation));
        if (this.forceAndroidJar) {
            Options.v().set_force_android_jar(this.androidJar);
        } else {
            Options.v().set_android_jars(this.androidJar);
        }
        Options.v().set_src_prec(5);
        Main.v().autoSetOptions();
        switch (this.callgraphAlgorithm) {
            case AutomaticSelection: {
                Options.v().setPhaseOption("cg.spark", "on");
                break;
            }
            case RTA: {
                Options.v().setPhaseOption("cg.spark", "on");
                Options.v().setPhaseOption("cg.spark", "rta:true");
                break;
            }
            case VTA: {
                Options.v().setPhaseOption("cg.spark", "on");
                Options.v().setPhaseOption("cg.spark", "vta:true");
                break;
            }
            default: {
                throw new RuntimeException("Invalid callgraph algorithm");
            }
        }
        Scene.v().loadNecessaryClasses();
    }

    public InfoflowResults runInfoflow() {
        return this.runInfoflow(null);
    }

    public IInfoflowCFG getIcfg() {
        return this.icfg;
    }

    public InfoflowResults runInfoflow(ResultsAvailableHandler onResultsAvailable) {
        if (this.sourceSinkProvider == null) {
            throw new RuntimeException("Sources and/or sinks not calculated yet");
        }
        System.out.println("Running data flow analysis on " + this.apkFileLocation + " with " + this.getSources().size() + " sources and " + this.getSinks().size() + " sinks...");
        Infoflow info2 = this.cfgFactory == null ? new Infoflow(this.androidJar, this.forceAndroidJar, null, new DefaultPathBuilderFactory(this.pathBuilder, this.computeResultPaths)) : new Infoflow(this.androidJar, this.forceAndroidJar, this.cfgFactory, new DefaultPathBuilderFactory(this.pathBuilder, this.computeResultPaths));
        String path = this.forceAndroidJar ? this.androidJar : Scene.v().getAndroidJarPath(this.androidJar, this.apkFileLocation);
        info2.setTaintWrapper(this.taintWrapper);
        if (onResultsAvailable != null) {
            info2.addResultsAvailableHandler(onResultsAvailable);
        }
        System.out.println("Starting infoflow computation...");
        info2.setSootConfig(this.sootConfig);
        info2.setStopAfterFirstFlow(this.stopAfterFirstFlow);
        info2.setEnableImplicitFlows(this.enableImplicitFlows);
        info2.setEnableStaticFieldTracking(this.enableStaticFields);
        info2.setEnableExceptionTracking(this.enableExceptions);
        Infoflow.setAccessPathLength(this.accessPathLength);
        info2.setFlowSensitiveAliasing(this.flowSensitiveAliasing);
        info2.setIgnoreFlowsInSystemPackages(this.ignoreFlowsInSystemPackages);
        info2.setCodeEliminationMode(this.codeEliminationMode);
        info2.setInspectSources(false);
        info2.setInspectSinks(false);
        info2.setCallgraphAlgorithm(this.callgraphAlgorithm);
        if (null != this.ipcManager) {
            info2.setIPCManager(this.ipcManager);
        }
        info2.computeInfoflow(this.apkFileLocation, path, this.entryPointCreator, (ISourceSinkManager)this.sourceSinkManager);
        this.icfg = info2.getiCfg();
        this.maxMemoryConsumption = info2.getMaxMemoryConsumption();
        return info2.getResults();
    }

    public IInfoflowCFG generateInfoflowCFG() {
        Infoflow info2 = this.cfgFactory == null ? new Infoflow(this.androidJar, this.forceAndroidJar, null, new DefaultPathBuilderFactory(this.pathBuilder, this.computeResultPaths)) : new Infoflow(this.androidJar, this.forceAndroidJar, this.cfgFactory, new DefaultPathBuilderFactory(this.pathBuilder, this.computeResultPaths));
        String path = this.forceAndroidJar ? this.androidJar : Scene.v().getAndroidJarPath(this.androidJar, this.apkFileLocation);
        if (JadeCfg.isEnable_apklibs()) {
            try {
                path = path + File.pathSeparator + this.extractPathFromAPK(this.apkFileLocation);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        info2.setTaintWrapper(this.taintWrapper);
        info2.setSootConfig(new SootConfigForAndroid());
        System.out.println("Starting infoflow computation...");
        info2.setSootConfig(this.sootConfig);
        info2.setStopAfterFirstFlow(this.stopAfterFirstFlow);
        info2.setEnableImplicitFlows(this.enableImplicitFlows);
        info2.setEnableStaticFieldTracking(this.enableStaticFields);
        info2.setEnableExceptionTracking(this.enableExceptions);
        Infoflow.setAccessPathLength(this.accessPathLength);
        info2.setFlowSensitiveAliasing(this.flowSensitiveAliasing);
        info2.setIgnoreFlowsInSystemPackages(this.ignoreFlowsInSystemPackages);
        info2.setInspectSources(false);
        info2.setInspectSinks(false);
        info2.setCallgraphAlgorithm(this.callgraphAlgorithm);
        if (null != this.ipcManager) {
            info2.setIPCManager(this.ipcManager);
        }
        info2.prepareSimpleFlow(this.apkFileLocation, path, this.entryPointCreator);
        return info2.prepareSimpleAnalysis();
    }

    public String extractPathFromAPK(String path) throws IOException {
        String out;
        StringBuilder ret = new StringBuilder();
        File dir = new File("tmplibs/");
        if (dir.isDirectory()) {
            for (File libfile : dir.listFiles()) {
                ret.append(libfile.getAbsolutePath() + File.pathSeparator);
            }
        }
        if ((out = ret.toString()).length() == 0) {
            return out;
        }
        if (out.charAt(out.length() - 1) == File.pathSeparatorChar) {
            return out.substring(0, out.length() - 1);
        }
        return out;
    }

    private AndroidEntryPointCreator createEntryPointCreator() {
        AndroidEntryPointCreator entryPointCreator = new AndroidEntryPointCreator(new ArrayList<String>(this.entrypoints));
        HashMap<String, List<String>> callbackMethodSigs = new HashMap<String, List<String>>();
        for (String className : this.callbackMethods.keySet()) {
            ArrayList<String> methodSigs = new ArrayList<String>();
            callbackMethodSigs.put(className, methodSigs);
            for (SootMethodAndClass am : this.callbackMethods.get(className)) {
                methodSigs.add(am.getSignature());
            }
        }
        entryPointCreator.setCallbackFunctions(callbackMethodSigs);
        return entryPointCreator;
    }

    public AndroidEntryPointCreator getEntryPointCreator() {
        return this.entryPointCreator;
    }

    public void setStopAfterFirstFlow(boolean stopAfterFirstFlow) {
        this.stopAfterFirstFlow = stopAfterFirstFlow;
    }

    public void setEnableImplicitFlows(boolean enableImplicitFlows) {
        this.enableImplicitFlows = enableImplicitFlows;
    }

    public void setEnableStaticFieldTracking(boolean enableStaticFields) {
        this.enableStaticFields = enableStaticFields;
    }

    public void setEnableExceptionTracking(boolean enableExceptions) {
        this.enableExceptions = enableExceptions;
    }

    public void setIgnoreFlowsInSystemPackages(boolean ignoreFlowsInSystemPackages) {
        this.ignoreFlowsInSystemPackages = ignoreFlowsInSystemPackages;
    }

    public void setFlowSensitiveAliasing(boolean flowSensitiveAliasing) {
        this.flowSensitiveAliasing = flowSensitiveAliasing;
    }

    public void setEnableCallbacks(boolean enableCallbacks) {
        this.enableCallbacks = enableCallbacks;
    }

    public void setEnableCallbackSources(boolean enableCallbackSources) {
        this.enableCallbackSources = enableCallbackSources;
    }

    public void setAccessPathLength(int accessPathLength) {
        this.accessPathLength = accessPathLength;
    }

    public void setCallgraphAlgorithm(IInfoflow.CallgraphAlgorithm algorithm) {
        this.callgraphAlgorithm = algorithm;
    }

    public void setLayoutMatchingMode(AndroidSourceSinkManager.LayoutMatchingMode mode) {
        this.layoutMatchingMode = mode;
    }

    public IInfoflowConfig getSootConfig() {
        return this.sootConfig;
    }

    public void setSootConfig(IInfoflowConfig config) {
        this.sootConfig = config;
    }

    public void setIcfgFactory(BiDirICFGFactory factory) {
        this.cfgFactory = factory;
    }

    public void setPathBuilder(DefaultPathBuilderFactory.PathBuilder builder) {
        this.pathBuilder = builder;
    }

    public void setComputeResultPaths(boolean computeResultPaths) {
        this.computeResultPaths = computeResultPaths;
    }

    public long getMaxMemoryConsumption() {
        return this.maxMemoryConsumption;
    }

    public void setCodeEliminationMode(IInfoflow.CodeEliminationMode mode) {
        this.codeEliminationMode = mode;
    }
}

