/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow;

import heros.solver.CountingThreadPoolExecutor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.k33nteam.ConnectCallbackTransformer;
import org.k33nteam.JadeCfg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.G;
import soot.MethodOrMethodContext;
import soot.PackManager;
import soot.PatchingChain;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Transform;
import soot.Unit;
import soot.jimple.Stmt;
import soot.jimple.infoflow.AbstractInfoflow;
import soot.jimple.infoflow.IInfoflow;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.AbstractBulkAliasStrategy;
import soot.jimple.infoflow.aliasing.FlowSensitiveAliasStrategy;
import soot.jimple.infoflow.aliasing.IAliasingStrategy;
import soot.jimple.infoflow.aliasing.PtsBasedAliasStrategy;
import soot.jimple.infoflow.cfg.BiDirICFGFactory;
import soot.jimple.infoflow.cfg.LibraryClassPatcher;
import soot.jimple.infoflow.config.IInfoflowConfig;
import soot.jimple.infoflow.data.AbstractionAtSink;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.data.pathBuilders.DefaultPathBuilderFactory;
import soot.jimple.infoflow.data.pathBuilders.IAbstractionPathBuilder;
import soot.jimple.infoflow.data.pathBuilders.IPathBuilderFactory;
import soot.jimple.infoflow.entryPointCreators.IEntryPointCreator;
import soot.jimple.infoflow.handlers.PreAnalysisHandler;
import soot.jimple.infoflow.handlers.ResultsAvailableHandler;
import soot.jimple.infoflow.handlers.TaintPropagationHandler;
import soot.jimple.infoflow.ipc.DefaultIPCManager;
import soot.jimple.infoflow.ipc.IIPCManager;
import soot.jimple.infoflow.problems.BackwardsInfoflowProblem;
import soot.jimple.infoflow.problems.InfoflowProblem;
import soot.jimple.infoflow.results.InfoflowResults;
import soot.jimple.infoflow.results.ResultSinkInfo;
import soot.jimple.infoflow.results.ResultSourceInfo;
import soot.jimple.infoflow.solver.cfg.BackwardsInfoflowCFG;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.infoflow.solver.cfg.InfoflowCFG;
import soot.jimple.infoflow.solver.fastSolver.InfoflowSolver;
import soot.jimple.infoflow.source.ISourceSinkManager;
import soot.jimple.infoflow.util.InterproceduralConstantValuePropagator;
import soot.jimple.infoflow.util.SootMethodRepresentationParser;
import soot.jimple.infoflow.util.SystemClassHandler;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.jimple.toolkits.scalar.ConditionalBranchFolder;
import soot.jimple.toolkits.scalar.ConstantPropagatorAndFolder;
import soot.jimple.toolkits.scalar.DeadAssignmentEliminator;
import soot.jimple.toolkits.scalar.UnreachableCodeEliminator;
import soot.options.Options;
import soot.util.queue.QueueReader;

public class Infoflow
extends AbstractInfoflow {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static int accessPathLength = 5;
    private static boolean useRecursiveAccessPaths = true;
    private static boolean pathAgnosticResults = true;
    private static boolean oneResultPerAccessPath = false;
    private static boolean mergeNeighbors = false;
    private InfoflowResults results = null;
    private IPathBuilderFactory pathBuilderFactory;
    private final String androidPath;
    private final boolean forceAndroidJar;
    private IInfoflowConfig sootConfig;
    private IIPCManager ipcManager = new DefaultIPCManager(new ArrayList<String>());
    private IInfoflowCFG iCfg;
    private Set<ResultsAvailableHandler> onResultsAvailable = new HashSet<ResultsAvailableHandler>();
    private Set<TaintPropagationHandler> taintPropagationHandlers = new HashSet<TaintPropagationHandler>();
    private long maxMemoryConsumption = -1L;

    public IInfoflowCFG getiCfg() {
        return this.iCfg;
    }

    public Infoflow() {
        this.androidPath = "";
        this.forceAndroidJar = false;
        this.pathBuilderFactory = new DefaultPathBuilderFactory();
    }

    public Infoflow(String androidPath, boolean forceAndroidJar) {
        this.androidPath = androidPath;
        this.forceAndroidJar = forceAndroidJar;
        this.pathBuilderFactory = new DefaultPathBuilderFactory();
    }

    public Infoflow(String androidPath, boolean forceAndroidJar, BiDirICFGFactory icfgFactory, IPathBuilderFactory pathBuilderFactory) {
        super(icfgFactory);
        this.androidPath = androidPath;
        this.forceAndroidJar = forceAndroidJar;
        this.pathBuilderFactory = pathBuilderFactory;
    }

    public void setSootConfig(IInfoflowConfig config) {
        this.sootConfig = config;
    }

    private void initializeSoot(String appPath, String libPath, Collection<String> classes) {
        this.initializeSoot(appPath, libPath, classes, "");
    }

    private void initializeSoot(String appPath, String libPath, Collection<String> classes, String extraSeed) {
        this.logger.info("Resetting Soot...");
        G.reset();
        Options.v().set_no_bodies_for_excluded(true);
        Options.v().set_allow_phantom_refs(true);
        if (this.logger.isDebugEnabled()) {
            Options.v().set_output_format(1);
        } else {
            Options.v().set_output_format(12);
        }
        if (this.callgraphAlgorithm == IInfoflow.CallgraphAlgorithm.OnDemand) {
            Options.v().set_soot_classpath(libPath);
            if (appPath != null) {
                LinkedList<String> processDirs = new LinkedList<String>();
                for (String ap : appPath.split(File.pathSeparator)) {
                    processDirs.add(ap);
                }
                Options.v().set_process_dir(processDirs);
            }
        } else {
            File file;
            Object path = appPath + (libPath != null && !libPath.isEmpty() ? File.pathSeparator + libPath : "");
            if (JadeCfg.isEnable_apklibs() && (file = new File("tmplibs/")).exists() && file.isDirectory()) {
                for (File libfile : file.listFiles()) {
                    path = (String)path + File.pathSeparator + libfile.getAbsolutePath();
                }
            }
            Options.v().set_soot_classpath((String)path);
        }
        switch (this.callgraphAlgorithm) {
            case AutomaticSelection: {
                if (extraSeed == null || extraSeed.isEmpty()) {
                    Options.v().setPhaseOption("cg.spark", "on");
                    Options.v().setPhaseOption("cg.spark", "string-constants:true");
                    break;
                }
                Options.v().setPhaseOption("cg.cha", "on");
                break;
            }
            case CHA: {
                Options.v().setPhaseOption("cg.cha", "on");
                break;
            }
            case RTA: {
                Options.v().setPhaseOption("cg.spark", "on");
                Options.v().setPhaseOption("cg.spark", "rta:true");
                Options.v().setPhaseOption("cg.spark", "string-constants:true");
                break;
            }
            case VTA: {
                Options.v().setPhaseOption("cg.spark", "on");
                Options.v().setPhaseOption("cg.spark", "vta:true");
                Options.v().setPhaseOption("cg.spark", "string-constants:true");
                break;
            }
            case SPARK: {
                Options.v().setPhaseOption("cg.spark", "on");
                Options.v().setPhaseOption("cg.spark", "string-constants:true");
                if (this.aliasingAlgorithm != IInfoflow.AliasingAlgorithm.FlowSensitive) break;
                break;
            }
            case OnDemand: {
                break;
            }
            default: {
                throw new RuntimeException("Invalid callgraph algorithm");
            }
        }
        if (this.callgraphAlgorithm != IInfoflow.CallgraphAlgorithm.OnDemand) {
            Options.v().set_whole_program(true);
            Options.v().setPhaseOption("cg", "trim-clinit:false");
        }
        Options.v().setPhaseOption("jb.ulp", "off");
        if (!this.androidPath.isEmpty()) {
            Options.v().set_src_prec(5);
            if (this.forceAndroidJar || JadeCfg.isEnable_apklibs()) {
                Options.v().set_force_android_jar(this.androidPath);
            } else {
                Options.v().set_android_jars(this.androidPath);
            }
        } else {
            Options.v().set_src_prec(4);
        }
        if (this.sootConfig != null) {
            this.sootConfig.setSootOptions(Options.v());
        }
        for (String className : classes) {
            Scene.v().addBasicClass(className, 3);
        }
        Scene.v().loadNecessaryClasses();
        this.logger.info("Basic class loading done.");
        boolean hasClasses = false;
        for (String className : classes) {
            SootClass c = Scene.v().forceResolve(className, 3);
            if (c == null) continue;
            c.setApplicationClass();
            if (c.isPhantomClass() || c.isPhantom()) continue;
            hasClasses = true;
        }
        if (!hasClasses) {
            this.logger.error("Only phantom classes loaded, skipping analysis...");
            return;
        }
    }

    private String appendClasspath(String appPath, String libPath) {
        String s2;
        String string2 = s2 = appPath != null && !appPath.isEmpty() ? appPath : "";
        if (libPath != null && !libPath.isEmpty()) {
            if (!s2.isEmpty()) {
                s2 = s2 + File.pathSeparator;
            }
            s2 = s2 + libPath;
        }
        return s2;
    }

    public void prepareSimpleFlow(String appPath, String libPath, IEntryPointCreator entryPointCreator) {
        Set<String> requiredClasses = SootMethodRepresentationParser.v().parseClassNames(entryPointCreator.getRequiredClasses(), false).keySet();
        this.initializeSoot(appPath, libPath, requiredClasses);
        Scene.v().setEntryPoints(Collections.singletonList(entryPointCreator.createDummyMain()));
        this.ipcManager.updateJimpleForICC();
        AccessPath.clearBaseRegister();
        for (PreAnalysisHandler tr : this.preProcessors) {
            tr.onBeforeCallgraphConstruction();
        }
        LibraryClassPatcher patcher = new LibraryClassPatcher();
        patcher.patchLibraries();
        if (this.callgraphAlgorithm != IInfoflow.CallgraphAlgorithm.OnDemand) {
            PackManager.v().getPack("wjpp").apply();
            PackManager.v().getPack("cg").apply();
        }
        for (PreAnalysisHandler tr : this.preProcessors) {
            tr.onAfterCallgraphConstruction();
        }
    }

    public IInfoflowCFG prepareSimpleAnalysis() {
        this.iCfg = this.icfgFactory.buildBiDirICFG(this.callgraphAlgorithm);
        return this.iCfg;
    }

    @Override
    public void computeInfoflow(String appPath, String libPath, IEntryPointCreator entryPointCreator, ISourceSinkManager sourcesSinks) {
        if (sourcesSinks == null) {
            this.logger.error("Sources are empty!");
            return;
        }
        this.initializeSoot(appPath, libPath, entryPointCreator.getRequiredClasses());
        Scene.v().setEntryPoints(Collections.singletonList(entryPointCreator.createDummyMain()));
        if (JadeCfg.isEnhance_callback_body()) {
            try {
                PackManager.v().getPack("jtp").add(new Transform("jtp.connect", new ConnectCallbackTransformer()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            for (SootClass sootClass : Scene.v().getApplicationClasses()) {
                for (SootMethod sootMethod : sootClass.getMethods()) {
                    try {
                        sootMethod.retrieveActiveBody();
                        if (!sootMethod.hasActiveBody()) continue;
                        PackManager.v().getPack("jtp").apply(sootMethod.getActiveBody());
                    }
                    catch (RuntimeException e) {
                        System.err.println("cannot get method body for " + sootMethod);
                        e.printStackTrace();
                    }
                }
            }
        }
        this.runAnalysis(sourcesSinks, null);
    }

    @Override
    public void computeInfoflow(String appPath, String libPath, String entryPoint, ISourceSinkManager sourcesSinks) {
        if (sourcesSinks == null) {
            this.logger.error("Sources are empty!");
            return;
        }
        this.initializeSoot(appPath, libPath, SootMethodRepresentationParser.v().parseClassNames(Collections.singletonList(entryPoint), false).keySet(), entryPoint);
        if (!Scene.v().containsMethod(entryPoint)) {
            this.logger.error("Entry point not found: " + entryPoint);
            return;
        }
        SootMethod ep = Scene.v().getMethod(entryPoint);
        if (!ep.isConcrete()) {
            this.logger.debug("Skipping non-concrete method " + ep);
            return;
        }
        ep.retrieveActiveBody();
        Scene.v().setEntryPoints(Collections.singletonList(ep));
        Options.v().set_main_class(ep.getDeclaringClass().getName());
        Set<String> seeds = Collections.emptySet();
        if (entryPoint != null && !entryPoint.isEmpty()) {
            seeds = Collections.singleton(entryPoint);
        }
        this.ipcManager.updateJimpleForICC();
        this.runAnalysis(sourcesSinks, seeds);
    }

    /*
     * WARNING - void declaration
     */
    private void runAnalysis(ISourceSinkManager sourcesSinks, Set<String> additionalSeeds) {
        void var12_22;
        AbstractBulkAliasStrategy aliasingStrategy;
        InfoflowSolver backSolver;
        BackwardsInfoflowProblem backProblem;
        this.maxMemoryConsumption = -1L;
        this.ipcManager.updateJimpleForICC();
        if (this.enableStaticFields && accessPathLength == 0) {
            throw new RuntimeException("Static field tracking must be disabled if the access path length is zero");
        }
        if (accessPathLength < 0) {
            throw new RuntimeException("The access path length may not be negative");
        }
        AccessPath.clearBaseRegister();
        for (Object tr : this.preProcessors) {
            tr.onBeforeCallgraphConstruction();
        }
        LibraryClassPatcher patcher = new LibraryClassPatcher();
        patcher.patchLibraries();
        if (this.callgraphAlgorithm != IInfoflow.CallgraphAlgorithm.OnDemand) {
            PackManager.v().getPack("wjpp").apply();
            PackManager.v().getPack("cg").apply();
        }
        for (PreAnalysisHandler tr : this.preProcessors) {
            tr.onAfterCallgraphConstruction();
        }
        if (this.codeEliminationMode != IInfoflow.CodeEliminationMode.NoCodeElimination) {
            long currentMillis = System.nanoTime();
            this.eliminateDeadCode(sourcesSinks);
            this.logger.info("Dead code elimination took " + (double)(System.nanoTime() - currentMillis) / 1.0E9 + " seconds");
        }
        if (this.callgraphAlgorithm != IInfoflow.CallgraphAlgorithm.OnDemand) {
            this.logger.info("Callgraph has {} edges", (Object)Scene.v().getCallGraph().size());
        }
        this.iCfg = this.icfgFactory.buildBiDirICFG(this.callgraphAlgorithm);
        int numThreads = Runtime.getRuntime().availableProcessors();
        CountingThreadPoolExecutor executor = this.createExecutor(numThreads);
        switch (this.aliasingAlgorithm) {
            case FlowSensitive: {
                backProblem = new BackwardsInfoflowProblem(new BackwardsInfoflowCFG(this.iCfg), sourcesSinks);
                backProblem.setFlowSensitiveAliasing(this.flowSensitiveAliasing);
                backSolver = new InfoflowSolver(backProblem, executor);
                backSolver.setJumpPredecessors(!this.pathBuilderFactory.supportsPathReconstruction());
                aliasingStrategy = new FlowSensitiveAliasStrategy(this.iCfg, backSolver);
                break;
            }
            case PtsBased: {
                backProblem = null;
                backSolver = null;
                aliasingStrategy = new PtsBasedAliasStrategy(this.iCfg);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported aliasing algorithm");
            }
        }
        InfoflowProblem forwardProblem = new InfoflowProblem(this.iCfg, sourcesSinks, (IAliasingStrategy)aliasingStrategy);
        forwardProblem.setFlowSensitiveAliasing(this.flowSensitiveAliasing);
        if (backProblem != null) {
            forwardProblem.setZeroValue(backProblem.createZeroValue());
        }
        InfoflowSolver forwardSolver = new InfoflowSolver(forwardProblem, executor);
        aliasingStrategy.setForwardSolver(forwardSolver);
        forwardSolver.setJumpPredecessors(!this.pathBuilderFactory.supportsPathReconstruction());
        forwardProblem.setInspectSources(this.inspectSources);
        forwardProblem.setInspectSinks(this.inspectSinks);
        forwardProblem.setEnableImplicitFlows(this.enableImplicitFlows);
        forwardProblem.setEnableStaticFieldTracking(this.enableStaticFields);
        forwardProblem.setEnableExceptionTracking(this.enableExceptions);
        for (TaintPropagationHandler taintPropagationHandler : this.taintPropagationHandlers) {
            forwardProblem.addTaintPropagationHandler(taintPropagationHandler);
        }
        forwardProblem.setTaintWrapper(this.taintWrapper);
        forwardProblem.setStopAfterFirstFlow(this.stopAfterFirstFlow);
        forwardProblem.setEnableTypeChecking(this.enableTypeChecking);
        forwardProblem.setIgnoreFlowsInSystemPackages(this.ignoreFlowsInSystemPackages);
        if (backProblem != null) {
            backProblem.setForwardSolver(forwardSolver);
            backProblem.setTaintWrapper(this.taintWrapper);
            backProblem.setEnableStaticFieldTracking(this.enableStaticFields);
            backProblem.setEnableExceptionTracking(this.enableExceptions);
            for (TaintPropagationHandler taintPropagationHandler : this.taintPropagationHandlers) {
                backProblem.addTaintPropagationHandler(taintPropagationHandler);
            }
            backProblem.setTaintWrapper(this.taintWrapper);
            backProblem.setActivationUnitsToCallSites(forwardProblem);
            backProblem.setEnableTypeChecking(this.enableTypeChecking);
            backProblem.setIgnoreFlowsInSystemPackages(this.ignoreFlowsInSystemPackages);
            backProblem.setInspectSources(this.inspectSources);
            backProblem.setInspectSinks(this.inspectSinks);
        }
        if (!this.enableStaticFields) {
            this.logger.warn("Static field tracking is disabled, results may be incomplete");
        }
        if (!this.flowSensitiveAliasing || !aliasingStrategy.isFlowSensitive()) {
            this.logger.warn("Using flow-insensitive alias tracking, results may be imprecise");
        }
        if (this.enableImplicitFlows) {
            this.logger.info("Implicit flow tracking is enabled");
        } else {
            this.logger.info("Implicit flow tracking is NOT enabled");
        }
        this.logger.info("Running with a maximum access path length of {}", (Object)Infoflow.getAccessPathLength());
        if (pathAgnosticResults) {
            this.logger.info("Using path-agnostic result collection");
        } else {
            this.logger.info("Using path-sensitive result collection");
        }
        if (useRecursiveAccessPaths) {
            this.logger.info("Recursive access path shortening is enabled");
        } else {
            this.logger.info("Recursive access path shortening is NOT enabled");
        }
        int sinkCount = 0;
        this.logger.info("Looking for sources and sinks...");
        for (SootMethod sm : this.getMethodsForSeeds(this.iCfg)) {
            sinkCount += this.scanMethodForSourcesSinks(sourcesSinks, forwardProblem, sm);
        }
        if (additionalSeeds != null) {
            for (String meth : additionalSeeds) {
                SootMethod m = Scene.v().getMethod(meth);
                if (!m.hasActiveBody()) {
                    this.logger.warn("Seed method {} has no active body", (Object)m);
                    continue;
                }
                forwardProblem.addInitialSeeds((Unit)m.getActiveBody().getUnits().getFirst(), Collections.singleton(forwardProblem.zeroValue()));
            }
        }
        System.out.println("sinkCount: " + sinkCount);
        if (!forwardProblem.hasInitialSeeds() || sinkCount == 0) {
            this.logger.error("No sources or sinks found, aborting analysis");
            return;
        }
        this.logger.info("Source lookup done, found {} sources and {} sinks.", (Object)forwardProblem.getInitialSeeds().size(), (Object)sinkCount);
        if (this.taintWrapper != null) {
            this.taintWrapper.initialize(new InfoflowManager(forwardSolver, this.iCfg));
        }
        forwardSolver.solve();
        this.maxMemoryConsumption = Math.max(this.maxMemoryConsumption, this.getUsedMemory());
        boolean bl = false;
        while (!(var12_22 >= 10 || executor.getActiveCount() == 0 && executor.isTerminated())) {
            ++var12_22;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                this.logger.error("Could not wait for executor termination", e);
            }
        }
        if (executor.getActiveCount() != 0 || !executor.isTerminated()) {
            this.logger.error("Executor did not terminate gracefully");
        }
        if (this.taintWrapper != null) {
            this.logger.info("Taint wrapper hits: " + this.taintWrapper.getWrapperHits());
            this.logger.info("Taint wrapper misses: " + this.taintWrapper.getWrapperMisses());
        }
        Set<AbstractionAtSink> res = forwardProblem.getResults();
        Iterator<AbstractionAtSink> absAtSinkIt = res.iterator();
        block13: while (absAtSinkIt.hasNext()) {
            AbstractionAtSink abstractionAtSink = absAtSinkIt.next();
            for (AbstractionAtSink checkAbs : res) {
                if (checkAbs == abstractionAtSink || checkAbs.getSinkStmt() != abstractionAtSink.getSinkStmt() || checkAbs.getAbstraction().isImplicit() != abstractionAtSink.getAbstraction().isImplicit() || !checkAbs.getAbstraction().getAccessPath().entails(abstractionAtSink.getAbstraction().getAccessPath())) continue;
                absAtSinkIt.remove();
                continue block13;
            }
        }
        this.logger.info("IFDS problem with {} forward and {} backward edges solved, processing {} results...", forwardSolver.propagationCount, backSolver == null ? 0L : backSolver.propagationCount, res == null ? 0 : res.size());
        this.maxMemoryConsumption = Math.max(this.maxMemoryConsumption, this.getUsedMemory());
        forwardSolver.cleanup();
        if (backSolver != null) {
            backSolver.cleanup();
            backSolver = null;
            backProblem = null;
        }
        forwardSolver = null;
        forwardProblem = null;
        Runtime.getRuntime().gc();
        this.computeTaintPaths(res);
        if (this.results.getResults().isEmpty()) {
            this.logger.warn("No results found.");
        } else {
            for (Map.Entry entry2 : this.results.getResults().entrySet()) {
                this.logger.info("The sink {} in method {} was called with values from the following sources:", entry2.getKey(), (Object)((SootMethod)this.iCfg.getMethodOf(((ResultSinkInfo)entry2.getKey()).getSink())).getSignature());
                for (ResultSourceInfo source : (Set)entry2.getValue()) {
                    this.logger.info("- {} in method {}", (Object)source, (Object)((SootMethod)this.iCfg.getMethodOf(source.getSource())).getSignature());
                    if (source.getPath() == null || source.getPath().isEmpty()) continue;
                    this.logger.info("\ton Path: ");
                    for (Unit unit : source.getPath()) {
                        this.logger.info("\t -> " + this.iCfg.getMethodOf(unit));
                        this.logger.info("\t\t -> " + unit);
                    }
                }
            }
        }
        for (ResultsAvailableHandler resultsAvailableHandler : this.onResultsAvailable) {
            resultsAvailableHandler.onResultsAvailable(this.iCfg, this.results);
        }
        if (this.logger.isDebugEnabled()) {
            PackManager.v().writeOutput();
        }
        this.maxMemoryConsumption = Math.max(this.maxMemoryConsumption, this.getUsedMemory());
    }

    private long getUsedMemory() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.totalMemory() - runtime.freeMemory();
    }

    private void eliminateDeadCode(ISourceSinkManager sourcesSinks) {
        QueueReader<MethodOrMethodContext> rdr = Scene.v().getReachableMethods().listener();
        while (rdr.hasNext()) {
            MethodOrMethodContext sm = rdr.next();
            if (sm.method() == null || !sm.method().hasActiveBody() || Scene.v().getEntryPoints().contains(sm.method())) continue;
            List<Unit> callSites = this.getCallsInMethod(sm.method());
            ConstantPropagatorAndFolder.v().transform(sm.method().getActiveBody());
            DeadAssignmentEliminator.v().transform(sm.method().getActiveBody());
            List<Unit> newCallSites = this.getCallsInMethod(sm.method());
            if (callSites == null) continue;
            for (Unit u : callSites) {
                if (newCallSites != null && newCallSites.contains(u)) continue;
                Scene.v().getCallGraph().removeAllEdgesOutOf(u);
            }
        }
        InterproceduralConstantValuePropagator ipcvp = new InterproceduralConstantValuePropagator(new InfoflowCFG(), Scene.v().getEntryPoints(), sourcesSinks, this.taintWrapper);
        ipcvp.setRemoveSideEffectFreeMethods(this.codeEliminationMode == IInfoflow.CodeEliminationMode.RemoveSideEffectFreeCode && !this.enableImplicitFlows);
        ipcvp.transform();
        QueueReader<MethodOrMethodContext> rdr2 = Scene.v().getReachableMethods().listener();
        while (rdr2.hasNext()) {
            MethodOrMethodContext sm = rdr2.next();
            if (sm.method() == null || !sm.method().hasActiveBody() || SystemClassHandler.isClassInSystemPackage(sm.method().getDeclaringClass().getName())) continue;
            ConditionalBranchFolder.v().transform(sm.method().getActiveBody());
            List<Unit> callSites = this.getCallsInMethod(sm.method());
            UnreachableCodeEliminator.v().transform(sm.method().getActiveBody());
            List<Unit> newCallSites = this.getCallsInMethod(sm.method());
            if (callSites == null) continue;
            for (Unit u : callSites) {
                if (newCallSites != null && newCallSites.contains(u)) continue;
                Scene.v().getCallGraph().removeAllEdgesOutOf(u);
            }
        }
    }

    private List<Unit> getCallsInMethod(SootMethod method) {
        ArrayList<Unit> callSites = null;
        for (Unit u : method.getActiveBody().getUnits()) {
            if (!((Stmt)u).containsInvokeExpr()) continue;
            if (callSites == null) {
                callSites = new ArrayList<Unit>();
            }
            callSites.add(u);
        }
        return callSites;
    }

    private CountingThreadPoolExecutor createExecutor(int numThreads) {
        return new CountingThreadPoolExecutor(this.maxThreadNum == -1 ? numThreads : Math.min(this.maxThreadNum, numThreads), Integer.MAX_VALUE, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    private void computeTaintPaths(Set<AbstractionAtSink> res) {
        IAbstractionPathBuilder builder = this.pathBuilderFactory.createPathBuilder(this.maxThreadNum, this.iCfg);
        builder.computeTaintPaths(res);
        this.results = builder.getResults();
        builder.shutdown();
    }

    private Collection<SootMethod> getMethodsForSeeds(IInfoflowCFG icfg) {
        LinkedList<SootMethod> seeds = new LinkedList<SootMethod>();
        if (Scene.v().hasCallGraph()) {
            ArrayList<SootMethod> eps = new ArrayList<SootMethod>(Scene.v().getEntryPoints());
            ReachableMethods reachableMethods = new ReachableMethods(Scene.v().getCallGraph(), eps.iterator(), null);
            reachableMethods.update();
            QueueReader<MethodOrMethodContext> iter2 = reachableMethods.listener();
            while (iter2.hasNext()) {
                seeds.add(((MethodOrMethodContext)iter2.next()).method());
            }
        } else {
            long beforeSeedMethods = System.nanoTime();
            HashSet<SootMethod> doneSet = new HashSet<SootMethod>();
            for (SootMethod sm : Scene.v().getEntryPoints()) {
                this.getMethodsForSeedsIncremental(sm, doneSet, seeds, icfg);
            }
            this.logger.info("Collecting seed methods took {} seconds", (Object)((double)(System.nanoTime() - beforeSeedMethods) / 1.0E9));
        }
        return seeds;
    }

    private void getMethodsForSeedsIncremental(SootMethod sm, Set<SootMethod> doneSet, List<SootMethod> seeds, IInfoflowCFG icfg) {
        assert (Scene.v().hasFastHierarchy());
        if (!(sm.isConcrete() && sm.getDeclaringClass().isApplicationClass() && doneSet.add(sm))) {
            return;
        }
        seeds.add(sm);
        for (Unit u : sm.retrieveActiveBody().getUnits()) {
            Stmt stmt = (Stmt)u;
            if (!stmt.containsInvokeExpr()) continue;
            for (SootMethod callee : icfg.getCalleesOfCallAt(stmt)) {
                this.getMethodsForSeedsIncremental(callee, doneSet, seeds, icfg);
            }
        }
    }

    private int scanMethodForSourcesSinks(ISourceSinkManager sourcesSinks, InfoflowProblem forwardProblem, SootMethod m) {
        int sinkCount = 0;
        if (m.hasActiveBody()) {
            String className = m.getDeclaringClass().getName();
            if (this.ignoreFlowsInSystemPackages && SystemClassHandler.isClassInSystemPackage(className)) {
                return sinkCount;
            }
            PatchingChain<Unit> units = m.getActiveBody().getUnits();
            for (Unit u : units) {
                Stmt s2 = (Stmt)u;
                if (sourcesSinks.getSourceInfo(s2, this.iCfg) != null) {
                    forwardProblem.addInitialSeeds(u, Collections.singleton(forwardProblem.zeroValue()));
                    this.logger.debug("Source found: {}", (Object)u);
                }
                if (!sourcesSinks.isSink(s2, this.iCfg, null)) continue;
                this.logger.debug("Sink found: {}", (Object)u);
                ++sinkCount;
            }
        }
        return sinkCount;
    }

    @Override
    public InfoflowResults getResults() {
        return this.results;
    }

    @Override
    public boolean isResultAvailable() {
        return this.results != null;
    }

    public static int getAccessPathLength() {
        return accessPathLength;
    }

    public static void setAccessPathLength(int accessPathLength) {
        Infoflow.accessPathLength = accessPathLength;
    }

    public static void setPathAgnosticResults(boolean pathAgnosticResults) {
        Infoflow.pathAgnosticResults = pathAgnosticResults;
    }

    public static boolean getPathAgnosticResults() {
        return pathAgnosticResults;
    }

    public static boolean getUseRecursiveAccessPaths() {
        return useRecursiveAccessPaths;
    }

    public static void setUseRecursiveAccessPaths(boolean useRecursiveAccessPaths) {
        Infoflow.useRecursiveAccessPaths = useRecursiveAccessPaths;
    }

    public static boolean getOneResultPerAccessPath() {
        return oneResultPerAccessPath;
    }

    public static void setOneResultPerAccessPath(boolean oneResultPerAP) {
        oneResultPerAccessPath = oneResultPerAP;
    }

    public void addResultsAvailableHandler(ResultsAvailableHandler handler) {
        this.onResultsAvailable.add(handler);
    }

    public static boolean getMergeNeighbors() {
        return mergeNeighbors;
    }

    public static void setMergeNeighbors(boolean value2) {
        mergeNeighbors = value2;
    }

    public void addTaintPropagationHandler(TaintPropagationHandler handler) {
        this.taintPropagationHandlers.add(handler);
    }

    public void removeResultsAvailableHandler(ResultsAvailableHandler handler) {
        this.onResultsAvailable.remove(handler);
    }

    @Override
    public void setIPCManager(IIPCManager ipcManager) {
        this.ipcManager = ipcManager;
    }

    public long getMaxMemoryConsumption() {
        return this.maxMemoryConsumption;
    }

    public void setPathBuilderFactory(IPathBuilderFactory factory) {
        this.pathBuilderFactory = factory;
    }
}

