/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler.instructions;

import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.TwoRegisterInstruction;
import soot.dexpler.Debug;
import soot.dexpler.DexBody;
import soot.dexpler.instructions.DexlibAbstractInstruction;
import soot.jimple.AssignStmt;
import soot.jimple.Jimple;

public class MoveInstruction
extends DexlibAbstractInstruction {
    AssignStmt assign = null;

    public MoveInstruction(Instruction instruction, int codeAdress) {
        super(instruction, codeAdress);
    }

    @Override
    public void jimplify(DexBody body) {
        TwoRegisterInstruction i = (TwoRegisterInstruction)this.instruction;
        Debug.printDbg("moveInstruction: ", i);
        int dest = i.getRegisterA();
        int source = i.getRegisterB();
        this.assign = Jimple.v().newAssignStmt(body.getRegisterLocal(dest), body.getRegisterLocal(source));
        this.setUnit(this.assign);
        this.addTags(this.assign);
        body.add(this.assign);
    }

    @Override
    int movesRegister(int register2) {
        TwoRegisterInstruction i = (TwoRegisterInstruction)this.instruction;
        int dest = i.getRegisterA();
        int source = i.getRegisterB();
        if (register2 == source) {
            return dest;
        }
        return -1;
    }

    @Override
    int movesToRegister(int register2) {
        TwoRegisterInstruction i = (TwoRegisterInstruction)this.instruction;
        int dest = i.getRegisterA();
        int source = i.getRegisterB();
        if (register2 == dest) {
            return source;
        }
        return -1;
    }

    @Override
    boolean overridesRegister(int register2) {
        TwoRegisterInstruction i = (TwoRegisterInstruction)this.instruction;
        int dest = i.getRegisterA();
        return register2 == dest;
    }
}

