/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jf.dexlib2.DexFileFactory;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.DexFile;
import soot.ArrayType;
import soot.PrimType;
import soot.Scene;
import soot.SootClass;
import soot.SootResolver;
import soot.Type;
import soot.VoidType;
import soot.dexpler.Debug;
import soot.dexpler.DexClass;
import soot.dexpler.DexType;
import soot.dexpler.Util;
import soot.javaToJimple.IInitialResolver;

public class DexlibWrapper {
    private DexFile dexFile;
    private static final Set<String> systemAnnotationNames;
    private final File inputDexFile;

    public DexlibWrapper(File inputDexFile) {
        this.inputDexFile = inputDexFile;
    }

    public void initialize() {
        try {
            int api = 1;
            this.dexFile = DexFileFactory.loadDexFile(this.inputDexFile, api, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        if (this.dexFile instanceof DexBackedDexFile) {
            DexBackedDexFile dbdf = (DexBackedDexFile)this.dexFile;
            for (int i = 0; i < dbdf.getTypeCount(); ++i) {
                String t = dbdf.getType(i);
                Type st = DexType.toSoot(t);
                if (st instanceof ArrayType) {
                    st = ((ArrayType)st).baseType;
                }
                Debug.printDbg("Type: ", t, " soot type:", st);
                String sootTypeName = st.toString();
                if (!Scene.v().containsClass(sootTypeName)) {
                    if (st instanceof PrimType || st instanceof VoidType || systemAnnotationNames.contains(sootTypeName)) continue;
                    SootResolver.v().makeClassRef(sootTypeName);
                }
                SootResolver.v().resolveClass(sootTypeName, 2);
            }
        } else {
            System.out.println("Warning: DexFile not instance of DexBackedDexFile! Not resolving types!");
            System.out.println("type: " + this.dexFile.getClass());
        }
    }

    public IInitialResolver.Dependencies makeSootClass(SootClass sc, String className) {
        if (Util.isByteCodeClassName(className)) {
            className = Util.dottedClassName(className);
        }
        for (ClassDef classDef : this.dexFile.getClasses()) {
            String forClassName = Util.dottedClassName(classDef.getType());
            if (!className.equals(forClassName)) continue;
            return DexClass.makeSootClass(sc, classDef, this.dexFile);
        }
        throw new RuntimeException("Error: class not found in classes.dex: " + className);
    }

    static {
        HashSet<String> systemAnnotationNamesModifiable = new HashSet<String>();
        systemAnnotationNamesModifiable.add("dalvik.annotation.AnnotationDefault");
        systemAnnotationNamesModifiable.add("dalvik.annotation.EnclosingClass");
        systemAnnotationNamesModifiable.add("dalvik.annotation.EnclosingMethod");
        systemAnnotationNamesModifiable.add("dalvik.annotation.InnerClass");
        systemAnnotationNamesModifiable.add("dalvik.annotation.MemberClasses");
        systemAnnotationNamesModifiable.add("dalvik.annotation.Signature");
        systemAnnotationNamesModifiable.add("dalvik.annotation.Throws");
        systemAnnotationNames = Collections.unmodifiableSet(systemAnnotationNamesModifiable);
    }
}

