/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import soot.RefLikeType;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.dexpler.Debug;
import soot.dexpler.DexTransformer;
import soot.jimple.AssignStmt;
import soot.jimple.ConditionExpr;
import soot.jimple.EqExpr;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.IntConstant;
import soot.jimple.LongConstant;
import soot.jimple.NeExpr;
import soot.jimple.NullConstant;

public abstract class AbstractNullTransformer
extends DexTransformer {
    protected boolean isZeroComparison(ConditionExpr expr) {
        if (expr instanceof EqExpr || expr instanceof NeExpr) {
            if (expr.getOp2() instanceof IntConstant && ((IntConstant)expr.getOp2()).value == 0) {
                return true;
            }
            if (expr.getOp2() instanceof LongConstant && ((LongConstant)expr.getOp2()).value == 0L) {
                return true;
            }
        }
        return false;
    }

    protected void replaceWithNull(Unit u) {
        AssignStmt s2;
        Value v;
        if (u instanceof IfStmt) {
            ConditionExpr expr = (ConditionExpr)((IfStmt)u).getCondition();
            if (this.isZeroComparison(expr)) {
                expr.setOp2(NullConstant.v());
                Debug.printDbg("[null] replacing with null in ", u);
                Debug.printDbg(" new u: ", u);
            }
        } else if (u instanceof AssignStmt && ((v = (s2 = (AssignStmt)u).getRightOp()) instanceof IntConstant && ((IntConstant)v).value == 0 || v instanceof LongConstant && ((LongConstant)v).value == 0L) && (!(s2.getLeftOp() instanceof InstanceFieldRef) || ((InstanceFieldRef)s2.getLeftOp()).getField().getType() instanceof RefLikeType)) {
            s2.setRightOp(NullConstant.v());
            Debug.printDbg("[null] replacing with null in ", u);
            Debug.printDbg(" new u: ", u);
        }
    }

    protected boolean isObject(Type t) {
        return t instanceof RefLikeType;
    }
}

