/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.renamer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import soot.ArrayType;
import soot.Local;
import soot.RefLikeType;
import soot.SootClass;
import soot.SootField;
import soot.Type;
import soot.dava.internal.AST.ASTMethodNode;
import soot.dava.toolkits.base.renamer.heuristicSet;
import soot.util.Chain;

public class Renamer {
    public final boolean DEBUG = false;
    heuristicSet heuristics;
    List locals;
    Chain fields;
    ASTMethodNode methodNode;
    List<String> forLoopNames;
    HashMap<Local, Boolean> changedOrNot;

    public Renamer(heuristicSet info2, ASTMethodNode node) {
        this.heuristics = info2;
        this.locals = null;
        this.methodNode = node;
        this.changedOrNot = new HashMap();
        Iterator<Local> localIt = info2.getLocalsIterator();
        while (localIt.hasNext()) {
            this.changedOrNot.put(localIt.next(), new Boolean(false));
        }
        this.forLoopNames = new ArrayList<String>();
        this.forLoopNames.add("i");
        this.forLoopNames.add("j");
        this.forLoopNames.add("k");
        this.forLoopNames.add("l");
    }

    public void rename() {
        this.debug("rename", "Renaming started");
        this.mainMethodArgument();
        this.forLoopIndexing();
        this.exceptionNaming();
        this.arraysGetTypeArray();
        this.assignedFromAField();
        this.newClassName();
        this.castedObject();
        this.objectsGetClassName();
        this.removeDollarSigns();
    }

    private void arraysGetTypeArray() {
        Iterator<Local> it = this.heuristics.getLocalsIterator();
        while (it.hasNext()) {
            Local tempLocal = it.next();
            if (this.alreadyChanged(tempLocal)) continue;
            this.debug("arraysGetTypeArray", "checking " + tempLocal);
            Type type = tempLocal.getType();
            if (!(type instanceof ArrayType)) continue;
            this.debug("arraysGetTypeArray", "Local:" + tempLocal + " is an Array Type: " + type.toString());
            String tempClassName = type.toString();
            if (tempClassName.indexOf(91) >= 0) {
                tempClassName = tempClassName.substring(0, tempClassName.indexOf(91));
            }
            if (tempClassName.indexOf(46) != -1) {
                tempClassName = tempClassName.substring(tempClassName.lastIndexOf(46) + 1);
            }
            String newName = tempClassName.toLowerCase();
            newName = newName + "Array";
            int count2 = 0;
            newName = newName + count2;
            ++count2;
            while (!this.isUniqueName(newName)) {
                newName = newName.substring(0, newName.length() - 1) + count2;
                ++count2;
            }
            this.setName(tempLocal, newName);
        }
    }

    private void objectsGetClassName() {
        Iterator<Local> it = this.heuristics.getLocalsIterator();
        while (it.hasNext()) {
            Local tempLocal = it.next();
            if (this.alreadyChanged(tempLocal)) continue;
            this.debug("objectsGetClassName", "checking " + tempLocal);
            Type type = tempLocal.getType();
            if (type instanceof ArrayType || !(type instanceof RefLikeType)) continue;
            this.debug("objectsGetClassName", "Local:" + tempLocal + " Type: " + type.toString());
            String tempClassName = type.toString();
            if (tempClassName.indexOf(46) != -1) {
                tempClassName = tempClassName.substring(tempClassName.lastIndexOf(46) + 1);
            }
            String newName = tempClassName.toLowerCase();
            int count2 = 0;
            newName = newName + count2;
            ++count2;
            while (!this.isUniqueName(newName)) {
                newName = newName.substring(0, newName.length() - 1) + count2;
                ++count2;
            }
            this.setName(tempLocal, newName);
        }
    }

    private void castedObject() {
        this.debug("castedObject", "");
        Iterator<Local> it = this.heuristics.getLocalsIterator();
        while (it.hasNext()) {
            Local tempLocal = it.next();
            if (this.alreadyChanged(tempLocal)) continue;
            this.debug("castedObject", "checking " + tempLocal);
            List<String> classes = this.heuristics.getCastStrings(tempLocal);
            Iterator<String> itClass = classes.iterator();
            String classNameToUse = null;
            while (itClass.hasNext()) {
                String tempClassName = itClass.next();
                if (tempClassName.indexOf(46) != -1) {
                    tempClassName = tempClassName.substring(tempClassName.lastIndexOf(46) + 1);
                }
                if (classNameToUse == null) {
                    classNameToUse = tempClassName;
                    continue;
                }
                if (classNameToUse.equals(tempClassName)) continue;
                classNameToUse = null;
                break;
            }
            if (classNameToUse == null) continue;
            this.debug("castedObject", "found a classNametoUse through cast expr");
            String newName = classNameToUse.toLowerCase();
            int count2 = 0;
            newName = newName + count2;
            ++count2;
            while (!this.isUniqueName(newName)) {
                newName = newName.substring(0, newName.length() - 1) + count2;
                ++count2;
            }
            this.setName(tempLocal, newName);
        }
    }

    private void newClassName() {
        this.debug("newClassName", "");
        Iterator<Local> it = this.heuristics.getLocalsIterator();
        while (it.hasNext()) {
            Local tempLocal = it.next();
            if (this.alreadyChanged(tempLocal)) continue;
            this.debug("newClassName", "checking " + tempLocal);
            List<String> classes = this.heuristics.getObjectClassName(tempLocal);
            Iterator<String> itClass = classes.iterator();
            String classNameToUse = null;
            while (itClass.hasNext()) {
                String tempClassName = itClass.next();
                if (tempClassName.indexOf(46) != -1) {
                    tempClassName = tempClassName.substring(tempClassName.lastIndexOf(46) + 1);
                }
                if (classNameToUse == null) {
                    classNameToUse = tempClassName;
                    continue;
                }
                if (classNameToUse.equals(tempClassName)) continue;
                classNameToUse = null;
                break;
            }
            if (classNameToUse == null) continue;
            this.debug("newClassName", "found a classNametoUse");
            String newName = classNameToUse.toLowerCase();
            int count2 = 0;
            newName = newName + count2;
            ++count2;
            while (!this.isUniqueName(newName)) {
                newName = newName.substring(0, newName.length() - 1) + count2;
                ++count2;
            }
            this.setName(tempLocal, newName);
        }
    }

    private void assignedFromAField() {
        Iterator<Local> it = this.heuristics.getLocalsIterator();
        while (it.hasNext()) {
            Local tempLocal = it.next();
            if (this.alreadyChanged(tempLocal)) continue;
            this.debug("assignedFromField", "checking " + tempLocal);
            List<String> fieldNames = this.heuristics.getFieldName(tempLocal);
            if (fieldNames.size() > 1 || fieldNames.size() != 1) continue;
            String fieldName = fieldNames.get(0);
            int count2 = 0;
            while (!this.isUniqueName(fieldName)) {
                fieldName = count2 == 0 ? fieldName + count2 : fieldName.substring(0, fieldName.length() - 1) + count2;
                ++count2;
            }
            this.setName(tempLocal, fieldName);
        }
    }

    private void removeDollarSigns() {
        Iterator<Local> it = this.heuristics.getLocalsIterator();
        while (it.hasNext()) {
            String newName;
            Local tempLocal = it.next();
            String currentName = tempLocal.getName();
            int dollarIndex = currentName.indexOf(36);
            if (dollarIndex != 0 || !this.isUniqueName(newName = currentName.substring(1, currentName.length()))) continue;
            this.setName(tempLocal, newName);
        }
    }

    private void exceptionNaming() {
        Iterator<Local> it = this.heuristics.getLocalsIterator();
        while (it.hasNext()) {
            Local tempLocal = it.next();
            Type localType = tempLocal.getType();
            String typeString = localType.toString();
            if (typeString.indexOf("Exception") < 0) continue;
            this.debug("exceptionNaming", "Type is an exception" + tempLocal);
            String newName = "";
            for (int i = 0; i < typeString.length(); ++i) {
                char character = typeString.charAt(i);
                if (!Character.isUpperCase(character)) continue;
                newName = newName + Character.toLowerCase(character);
            }
            int count2 = 0;
            if (!this.isUniqueName(newName)) {
                ++count2;
                while (!this.isUniqueName(newName + count2)) {
                    ++count2;
                }
            }
            if (count2 != 0) {
                newName = newName + count2;
            }
            this.setName(tempLocal, newName);
        }
    }

    private void forLoopIndexing() {
        Iterator<Local> it = this.heuristics.getLocalsIterator();
        while (it.hasNext()) {
            String newName;
            Local tempLocal = it.next();
            this.debug("foeLoopIndexing", "Checking local" + tempLocal.getName());
            if (!this.heuristics.getHeuristic(tempLocal, 9)) continue;
            int count2 = -1;
            do {
                if (++count2 < this.forLoopNames.size()) continue;
                newName = null;
                break;
            } while (!this.isUniqueName(newName = this.forLoopNames.get(count2)));
            if (newName == null) continue;
            this.setName(tempLocal, newName);
        }
    }

    private void mainMethodArgument() {
        Iterator<Local> it = this.heuristics.getLocalsIterator();
        while (it.hasNext()) {
            Local tempLocal = it.next();
            if (!this.heuristics.getHeuristic(tempLocal, 7)) continue;
            String newName = "args";
            int count2 = 0;
            while (!this.isUniqueName(newName)) {
                newName = count2 == 0 ? newName + count2 : newName.substring(0, newName.length() - 1) + count2;
                ++count2;
            }
            this.setName(tempLocal, newName);
            return;
        }
    }

    private void setName(Local var, String newName) {
        Boolean truthValue = this.changedOrNot.get(var);
        if (truthValue == null) {
            this.changedOrNot.put(var, new Boolean(false));
        } else if (truthValue.booleanValue()) {
            this.debug("setName", "Var: " + var + " had already been renamed");
            return;
        }
        this.debug("setName", "Changed " + var.getName() + " to " + newName);
        var.setName(newName);
        this.changedOrNot.put(var, new Boolean(true));
    }

    private boolean alreadyChanged(Local var) {
        Boolean truthValue = this.changedOrNot.get(var);
        if (truthValue == null) {
            this.changedOrNot.put(var, new Boolean(false));
            return false;
        }
        if (truthValue.booleanValue()) {
            this.debug("alreadyChanged", "Var: " + var + " had already been renamed");
            return true;
        }
        return false;
    }

    private boolean isUniqueName(String name) {
        Iterator it = this.getScopedLocals();
        while (it.hasNext()) {
            Local tempLocal = (Local)it.next();
            if (tempLocal.getName().equals(name)) {
                this.debug("isUniqueName", "New Name " + name + " is not unique (matches some local)..changing");
                return false;
            }
            this.debug("isUniqueName", "New Name " + name + " is different from local " + tempLocal.getName());
        }
        it = this.getScopedFields();
        while (it.hasNext()) {
            SootField tempField = (SootField)it.next();
            if (tempField.getName().equals(name)) {
                this.debug("isUniqueName", "New Name " + name + " is not unique (matches field)..changing");
                return false;
            }
            this.debug("isUniqueName", "New Name " + name + " is different from field " + tempField.getName());
        }
        return true;
    }

    private Iterator getScopedFields() {
        SootClass sootClass = this.methodNode.getDavaBody().getMethod().getDeclaringClass();
        this.fields = sootClass.getFields();
        return this.fields.iterator();
    }

    private Iterator getScopedLocals() {
        Iterator<Local> it = this.heuristics.getLocalsIterator();
        this.locals = new ArrayList();
        while (it.hasNext()) {
            this.locals.add(it.next());
        }
        return this.locals.iterator();
    }

    public void debug(String methodName, String debug) {
    }
}

