/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.misc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import soot.G;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.dava.Dava;
import soot.util.IterableSet;

public class PackageNamer {
    private boolean fixed = false;
    private final ArrayList<NameHolder> appRoots = new ArrayList();
    private final ArrayList<NameHolder> otherRoots = new ArrayList();
    private final HashSet<String> keywords = new HashSet();
    private char fileSep;
    private String classPath;
    private String pathSep;

    public PackageNamer(Singletons.Global g) {
    }

    public static PackageNamer v() {
        return G.v().soot_dava_toolkits_base_misc_PackageNamer();
    }

    public boolean has_FixedNames() {
        return this.fixed;
    }

    public boolean use_ShortName(String fixedPackageName, String fixedShortClassName) {
        if (!this.fixed) {
            return false;
        }
        if (fixedPackageName.equals(Dava.v().get_CurrentPackage())) {
            return true;
        }
        IterableSet packageContext = Dava.v().get_CurrentPackageContext();
        if (packageContext == null) {
            return true;
        }
        packageContext = this.patch_PackageContext(packageContext);
        int count2 = 0;
        StringTokenizer st = new StringTokenizer(this.classPath, this.pathSep);
        while (st.hasMoreTokens()) {
            String classpathDir = st.nextToken();
            Iterator packIt = packageContext.iterator();
            while (packIt.hasNext()) {
                if (!this.package_ContainsClass(classpathDir, (String)packIt.next(), fixedShortClassName) || ++count2 <= 1) continue;
                return false;
            }
        }
        return true;
    }

    public String get_FixedClassName(String originalFullClassName) {
        if (!this.fixed) {
            return originalFullClassName;
        }
        for (NameHolder h : this.appRoots) {
            if (!h.contains_OriginalName(new StringTokenizer(originalFullClassName, "."), true)) continue;
            return h.get_FixedName(new StringTokenizer(originalFullClassName, "."), true);
        }
        return originalFullClassName.substring(originalFullClassName.lastIndexOf(".") + 1);
    }

    public String get_FixedPackageName(String originalPackageName) {
        if (!this.fixed) {
            return originalPackageName;
        }
        if (originalPackageName.equals("")) {
            return "";
        }
        for (NameHolder h : this.appRoots) {
            if (!h.contains_OriginalName(new StringTokenizer(originalPackageName, "."), false)) continue;
            return h.get_FixedName(new StringTokenizer(originalPackageName, "."), false);
        }
        return originalPackageName;
    }

    public void fixNames() {
        String[] keywordArray;
        if (this.fixed) {
            return;
        }
        for (String element2 : keywordArray = new String[]{"abstract", "default", "if", "private", "this", "boolean", "do", "implements", "protected", "throw", "break", "double", "import", "public", "throws", "byte", "else", "instanceof", "return", "transient", "case", "extends", "int", "short", "try", "catch", "final", "interface", "static", "void", "char", "finally", "long", "strictfp", "volatile", "class", "float", "native", "super", "while", "const", "for", "new", "switch", "continue", "goto", "package", "synchronized", "true", "false", "null"}) {
            this.keywords.add(element2);
        }
        Iterator<SootClass> classIt = Scene.v().getLibraryClasses().iterator();
        while (classIt.hasNext()) {
            this.add_ClassName(classIt.next().getName(), this.otherRoots);
        }
        classIt = Scene.v().getApplicationClasses().iterator();
        while (classIt.hasNext()) {
            this.add_ClassName(classIt.next().getName(), this.appRoots);
        }
        Iterator<NameHolder> arit = this.appRoots.iterator();
        while (arit.hasNext()) {
            arit.next().fix_ClassNames("");
        }
        arit = this.appRoots.iterator();
        while (arit.hasNext()) {
            arit.next().fix_PackageNames();
        }
        this.fileSep = System.getProperty("file.separator").charAt(0);
        this.pathSep = System.getProperty("path.separator");
        this.classPath = System.getProperty("java.class.path");
        this.fixed = true;
    }

    private void add_ClassName(String className, ArrayList<NameHolder> roots) {
        ArrayList<NameHolder> children2 = roots;
        NameHolder curNode = null;
        StringTokenizer st = new StringTokenizer(className, ".");
        while (st.hasMoreTokens()) {
            String curName = st.nextToken();
            NameHolder child2 = null;
            boolean found = false;
            for (NameHolder child2 : children2) {
                if (!child2.get_OriginalName().equals(curName)) continue;
                if (!st.hasMoreTokens()) {
                    child2.set_ClassAttr();
                }
                found = true;
                break;
            }
            if (!found) {
                child2 = new NameHolder(curName, curNode, !st.hasMoreTokens());
                children2.add(child2);
            }
            curNode = child2;
            children2 = child2.get_Children();
        }
    }

    public boolean package_ContainsClass(String classpathDir, String packageName, String className) {
        File p = new File(classpathDir);
        if (!p.exists()) {
            return false;
        }
        if ((packageName = packageName.replace('.', this.fileSep)).length() > 0 && packageName.charAt(packageName.length() - 1) != this.fileSep) {
            packageName = packageName + this.fileSep;
        }
        String name = packageName + className + ".class";
        if (p.isDirectory()) {
            if (classpathDir.length() > 0 && classpathDir.charAt(classpathDir.length() - 1) != this.fileSep) {
                classpathDir = classpathDir + this.fileSep;
            }
            return new File(classpathDir + name).exists();
        }
        JarFile jf = null;
        try {
            jf = new JarFile(p);
        }
        catch (IOException ioe) {
            return false;
        }
        return jf.getJarEntry(name) != null;
    }

    IterableSet patch_PackageContext(IterableSet currentContext) {
        IterableSet<String> newContext = new IterableSet<String>();
        for (String currentPackage : currentContext) {
            String newPackage = null;
            StringTokenizer st = new StringTokenizer(currentPackage, ".");
            if (!st.hasMoreTokens()) {
                newContext.add(currentPackage);
                continue;
            }
            String firstToken = st.nextToken();
            for (NameHolder h : this.appRoots) {
                if (!h.get_PackageName().equals(firstToken)) continue;
                newPackage = h.get_OriginalPackageName(st);
                break;
            }
            if (newPackage != null) {
                newContext.add(newPackage);
                continue;
            }
            newContext.add(currentPackage);
        }
        return newContext;
    }

    private class NameHolder {
        private final String originalName;
        private String packageName;
        private String className;
        private final ArrayList<NameHolder> children;
        private NameHolder parent;
        private boolean isClass;

        public NameHolder(String name, NameHolder parent, boolean isClass) {
            this.originalName = name;
            this.className = name;
            this.packageName = name;
            this.parent = parent;
            this.isClass = isClass;
            this.children = new ArrayList();
        }

        public NameHolder get_Parent() {
            return this.parent;
        }

        public void set_ClassAttr() {
            this.isClass = true;
        }

        public boolean is_Class() {
            if (this.children.isEmpty()) {
                return true;
            }
            return this.isClass;
        }

        public boolean is_Package() {
            return !this.children.isEmpty();
        }

        public String get_PackageName() {
            return this.packageName;
        }

        public String get_ClassName() {
            return this.className;
        }

        public void set_PackageName(String packageName) {
            this.packageName = packageName;
        }

        public void set_ClassName(String className) {
            this.className = className;
        }

        public String get_OriginalName() {
            return this.originalName;
        }

        public ArrayList<NameHolder> get_Children() {
            return this.children;
        }

        public String get_FixedPackageName() {
            if (this.parent == null) {
                return "";
            }
            return this.parent.retrieve_FixedPackageName();
        }

        public String retrieve_FixedPackageName() {
            if (this.parent == null) {
                return this.packageName;
            }
            return this.parent.get_FixedPackageName() + "." + this.packageName;
        }

        public String get_FixedName(StringTokenizer st, boolean forClass) {
            if (!st.nextToken().equals(this.originalName)) {
                throw new RuntimeException("Unable to resolve naming.");
            }
            return this.retrieve_FixedName(st, forClass);
        }

        private String retrieve_FixedName(StringTokenizer st, boolean forClass) {
            if (!st.hasMoreTokens()) {
                if (forClass) {
                    return this.className;
                }
                return this.packageName;
            }
            String subName = st.nextToken();
            for (NameHolder h : this.children) {
                if (!h.get_OriginalName().equals(subName)) continue;
                if (forClass) {
                    return h.retrieve_FixedName(st, forClass);
                }
                return this.packageName + "." + h.retrieve_FixedName(st, forClass);
            }
            throw new RuntimeException("Unable to resolve naming.");
        }

        public String get_OriginalPackageName(StringTokenizer st) {
            if (!st.hasMoreTokens()) {
                return this.get_OriginalName();
            }
            String subName = st.nextToken();
            for (NameHolder h : this.children) {
                if (!h.get_PackageName().equals(subName)) continue;
                String originalSubPackageName = h.get_OriginalPackageName(st);
                if (originalSubPackageName == null) {
                    return null;
                }
                return this.get_OriginalName() + "." + originalSubPackageName;
            }
            return null;
        }

        public boolean contains_OriginalName(StringTokenizer st, boolean forClass) {
            if (!this.get_OriginalName().equals(st.nextToken())) {
                return false;
            }
            return this.finds_OriginalName(st, forClass);
        }

        private boolean finds_OriginalName(StringTokenizer st, boolean forClass) {
            if (!st.hasMoreTokens()) {
                return forClass && this.is_Class() || !forClass && this.is_Package();
            }
            String subName = st.nextToken();
            for (NameHolder h : this.children) {
                if (!h.get_OriginalName().equals(subName)) continue;
                return h.finds_OriginalName(st, forClass);
            }
            return false;
        }

        public void fix_ClassNames(String curPackName) {
            if (this.is_Class() && PackageNamer.this.keywords.contains(this.className)) {
                String tClassName = this.className;
                if (Character.isLowerCase(this.className.charAt(0))) {
                    this.className = tClassName = tClassName.substring(0, 1).toUpperCase() + tClassName.substring(1);
                }
                int i = 0;
                while (PackageNamer.this.keywords.contains(this.className)) {
                    this.className = tClassName + "_c" + i;
                    ++i;
                }
            }
            Iterator<NameHolder> it = this.children.iterator();
            while (it.hasNext()) {
                it.next().fix_ClassNames(curPackName + "." + this.packageName);
            }
        }

        public void fix_PackageNames() {
            if (this.is_Package() && !this.verify_PackageName()) {
                String tPackageName = this.packageName;
                if (Character.isUpperCase(this.packageName.charAt(0))) {
                    this.packageName = tPackageName = tPackageName.substring(0, 1).toLowerCase() + tPackageName.substring(1);
                }
                int i = 0;
                while (!this.verify_PackageName()) {
                    this.packageName = tPackageName + "_p" + i;
                    ++i;
                }
            }
            Iterator<NameHolder> it = this.children.iterator();
            while (it.hasNext()) {
                it.next().fix_PackageNames();
            }
        }

        public boolean verify_PackageName() {
            return !PackageNamer.this.keywords.contains(this.packageName) && !this.siblingClashes(this.packageName) && (!this.is_Class() || !this.className.equals(this.packageName));
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean siblingClashes(String name) {
            void var2_5;
            Object var2_2 = null;
            if (this.parent == null) {
                if (!PackageNamer.this.appRoots.contains(this)) throw new RuntimeException("Unable to find package siblings.");
                Iterator iterator2 = PackageNamer.this.appRoots.iterator();
            } else {
                Iterator<NameHolder> iterator3 = this.parent.get_Children().iterator();
            }
            while (var2_5.hasNext()) {
                NameHolder sibling = (NameHolder)var2_5.next();
                if (sibling == this || (!sibling.is_Package() || !sibling.get_PackageName().equals(name)) && (!sibling.is_Class() || !sibling.get_ClassName().equals(name))) continue;
                return true;
            }
            return false;
        }

        public void dump(String indentation) {
            G.v().out.print(indentation + "\"" + this.originalName + "\", \"" + this.packageName + "\", \"" + this.className + "\" (");
            if (this.is_Class()) {
                G.v().out.print("c");
            }
            if (this.is_Package()) {
                G.v().out.print("p");
            }
            G.v().out.println(")");
            Iterator<NameHolder> it = this.children.iterator();
            while (it.hasNext()) {
                it.next().dump(indentation + "  ");
            }
        }
    }
}

