/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.AST.traversals;

import java.util.ArrayList;
import java.util.HashMap;
import soot.G;
import soot.Singletons;
import soot.dava.internal.AST.ASTDoWhileNode;
import soot.dava.internal.AST.ASTForLoopNode;
import soot.dava.internal.AST.ASTLabeledNode;
import soot.dava.internal.AST.ASTNode;
import soot.dava.internal.AST.ASTSwitchNode;
import soot.dava.internal.AST.ASTUnconditionalLoopNode;
import soot.dava.internal.AST.ASTWhileNode;
import soot.dava.internal.SET.SETNodeLabel;
import soot.dava.internal.javaRep.DAbruptStmt;
import soot.dava.toolkits.base.AST.analysis.DepthFirstAdapter;
import soot.jimple.Stmt;

public class ClosestAbruptTargetFinder
extends DepthFirstAdapter {
    HashMap<DAbruptStmt, ASTNode> closestNode = new HashMap();
    ArrayList<ASTLabeledNode> nodeStack = new ArrayList();

    public ClosestAbruptTargetFinder(Singletons.Global g) {
    }

    public static ClosestAbruptTargetFinder v() {
        return G.v().soot_dava_toolkits_base_AST_traversals_ClosestAbruptTargetFinder();
    }

    public ASTNode getTarget(DAbruptStmt ab) {
        ASTNode node = this.closestNode.get(ab);
        if (node != null) {
            return node;
        }
        throw new RuntimeException("Unable to find target for AbruptStmt");
    }

    @Override
    public void inASTWhileNode(ASTWhileNode node) {
        this.nodeStack.add(node);
    }

    @Override
    public void inASTDoWhileNode(ASTDoWhileNode node) {
        this.nodeStack.add(node);
    }

    @Override
    public void inASTUnconditionalLoopNode(ASTUnconditionalLoopNode node) {
        this.nodeStack.add(node);
    }

    @Override
    public void inASTForLoopNode(ASTForLoopNode node) {
        this.nodeStack.add(node);
    }

    @Override
    public void inASTSwitchNode(ASTSwitchNode node) {
        this.nodeStack.add(node);
    }

    @Override
    public void outASTWhileNode(ASTWhileNode node) {
        if (this.nodeStack.isEmpty()) {
            throw new RuntimeException("trying to remove node from empty stack: ClosestBreakTargetFinder");
        }
        this.nodeStack.remove(this.nodeStack.size() - 1);
    }

    @Override
    public void outASTDoWhileNode(ASTDoWhileNode node) {
        if (this.nodeStack.isEmpty()) {
            throw new RuntimeException("trying to remove node from empty stack: ClosestBreakTargetFinder");
        }
        this.nodeStack.remove(this.nodeStack.size() - 1);
    }

    @Override
    public void outASTUnconditionalLoopNode(ASTUnconditionalLoopNode node) {
        if (this.nodeStack.isEmpty()) {
            throw new RuntimeException("trying to remove node from empty stack: ClosestBreakTargetFinder");
        }
        this.nodeStack.remove(this.nodeStack.size() - 1);
    }

    @Override
    public void outASTForLoopNode(ASTForLoopNode node) {
        if (this.nodeStack.isEmpty()) {
            throw new RuntimeException("trying to remove node from empty stack: ClosestBreakTargetFinder");
        }
        this.nodeStack.remove(this.nodeStack.size() - 1);
    }

    @Override
    public void outASTSwitchNode(ASTSwitchNode node) {
        if (this.nodeStack.isEmpty()) {
            throw new RuntimeException("trying to remove node from empty stack: ClosestBreakTargetFinder");
        }
        this.nodeStack.remove(this.nodeStack.size() - 1);
    }

    @Override
    public void inStmt(Stmt s2) {
        if (s2 instanceof DAbruptStmt) {
            DAbruptStmt ab = (DAbruptStmt)s2;
            SETNodeLabel label = ab.getLabel();
            if (label != null && label.toString() != null) {
                return;
            }
            if (ab.is_Break()) {
                int index = this.nodeStack.size() - 1;
                if (index < 0) {
                    throw new RuntimeException("nodeStack empty??" + this.nodeStack.toString());
                }
                ASTNode currentNode = this.nodeStack.get(this.nodeStack.size() - 1);
                this.closestNode.put(ab, currentNode);
            } else if (ab.is_Continue()) {
                int index = this.nodeStack.size() - 1;
                if (index < 0) {
                    throw new RuntimeException("nodeStack empty??" + this.nodeStack.toString());
                }
                ASTNode currentNode = this.nodeStack.get(index);
                while (currentNode instanceof ASTSwitchNode) {
                    if (index > 0) {
                        currentNode = this.nodeStack.get(--index);
                        continue;
                    }
                    throw new RuntimeException("Unable to find closest break Target");
                }
                this.closestNode.put(ab, currentNode);
            }
        }
    }
}

