/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.AST.transformations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Local;
import soot.RefType;
import soot.SootClass;
import soot.dava.internal.AST.ASTNode;
import soot.dava.internal.AST.ASTStatementSequenceNode;
import soot.dava.internal.AST.ASTSwitchNode;
import soot.dava.internal.AST.ASTTryNode;
import soot.dava.internal.asg.AugmentedStmt;
import soot.dava.toolkits.base.AST.analysis.DepthFirstAdapter;
import soot.dava.toolkits.base.AST.structuredAnalysis.UnreachableCodeFinder;
import soot.jimple.Stmt;

public class UnreachableCodeEliminator
extends DepthFirstAdapter {
    public boolean DUBUG = true;
    ASTNode AST;
    UnreachableCodeFinder codeFinder;

    public UnreachableCodeEliminator(ASTNode AST2) {
        this.AST = AST2;
        this.setup();
    }

    public UnreachableCodeEliminator(boolean verbose, ASTNode AST2) {
        super(verbose);
        this.AST = AST2;
        this.setup();
    }

    private void setup() {
        this.codeFinder = new UnreachableCodeFinder(this.AST);
    }

    @Override
    public void inASTStatementSequenceNode(ASTStatementSequenceNode node) {
        ArrayList<AugmentedStmt> toRemove = new ArrayList<AugmentedStmt>();
        List<Object> stmts = node.getStatements();
        for (AugmentedStmt augmentedStmt : stmts) {
            Stmt s2 = augmentedStmt.get_Stmt();
            if (this.codeFinder.isConstructReachable(s2)) continue;
            toRemove.add(augmentedStmt);
        }
        Iterator<Object> it = toRemove.iterator();
        while (it.hasNext()) {
            stmts.remove(it.next());
        }
    }

    @Override
    public void normalRetrieving(ASTNode node) {
        if (node instanceof ASTSwitchNode) {
            this.dealWithSwitchNode((ASTSwitchNode)node);
            return;
        }
        ArrayList<ASTNode> toReturn = new ArrayList<ASTNode>();
        for (Object subBody : node.get_SubBodies()) {
            for (ASTNode temp : (List)subBody) {
                if (!this.codeFinder.isConstructReachable(temp)) {
                    toReturn.add(temp);
                    continue;
                }
                temp.apply(this);
            }
            Iterator it = toReturn.iterator();
            while (it.hasNext()) {
                ((List)subBody).remove(it.next());
            }
        }
    }

    @Override
    public void caseASTTryNode(ASTTryNode node) {
        List<Object> tryBody = node.get_TryBody();
        Iterator<Object> it = tryBody.iterator();
        ArrayList<ASTNode> toReturn = new ArrayList<ASTNode>();
        while (it.hasNext()) {
            ASTNode temp = (ASTNode)it.next();
            if (!this.codeFinder.isConstructReachable(temp)) {
                toReturn.add(temp);
                continue;
            }
            temp.apply(this);
        }
        it = toReturn.iterator();
        while (it.hasNext()) {
            tryBody.remove(it.next());
        }
        Map<Object, Object> exceptionMap = node.get_ExceptionMap();
        Map<Object, Object> paramMap = node.get_ParamMap();
        List<Object> catchList = node.get_CatchList();
        Iterator itBody = null;
        for (ASTTryNode.container container2 : catchList) {
            SootClass sootClass = (SootClass)exceptionMap.get(container2);
            RefType type = sootClass.getType();
            this.caseType(type);
            Local local = (Local)paramMap.get(container2);
            this.decideCaseExprOrRef(local);
            List body = (List)container2.o;
            toReturn = new ArrayList();
            for (ASTNode temp : body) {
                if (!this.codeFinder.isConstructReachable(temp)) {
                    toReturn.add(temp);
                    continue;
                }
                temp.apply(this);
            }
            itBody = toReturn.iterator();
            while (itBody.hasNext()) {
                body.remove(itBody.next());
            }
        }
    }

    private void dealWithSwitchNode(ASTSwitchNode node) {
        List<Object> indexList = node.getIndexList();
        Map<Object, List<Object>> index2BodyList = node.getIndex2BodyList();
        for (Object currentIndex : indexList) {
            List<Object> body = index2BodyList.get(currentIndex);
            if (body == null) continue;
            ArrayList<ASTNode> toReturn = new ArrayList<ASTNode>();
            for (ASTNode aSTNode : body) {
                if (!this.codeFinder.isConstructReachable(aSTNode)) {
                    toReturn.add(aSTNode);
                    continue;
                }
                aSTNode.apply(this);
            }
            Iterator iterator2 = toReturn.iterator();
            while (iterator2.hasNext()) {
                body.remove(iterator2.next());
            }
        }
    }
}

