/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.internal.AST;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.Local;
import soot.Type;
import soot.UnitPrinter;
import soot.Value;
import soot.dava.DavaBody;
import soot.dava.DavaUnitPrinter;
import soot.dava.internal.AST.ASTNode;
import soot.dava.internal.AST.ASTStatementSequenceNode;
import soot.dava.internal.asg.AugmentedStmt;
import soot.dava.internal.javaRep.DVariableDeclarationStmt;
import soot.dava.toolkits.base.AST.ASTAnalysis;
import soot.dava.toolkits.base.AST.analysis.Analysis;
import soot.dava.toolkits.base.renamer.RemoveFullyQualifiedName;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.Stmt;
import soot.util.DeterministicHashMap;
import soot.util.IterableSet;

public class ASTMethodNode
extends ASTNode {
    private List<Object> body;
    private DavaBody davaBody;
    private ASTStatementSequenceNode declarations;
    private List<Local> dontPrintLocals = new ArrayList<Local>();
    private Map<Type, List> typeToLocals;

    public ASTStatementSequenceNode getDeclarations() {
        return this.declarations;
    }

    public void setDeclarations(ASTStatementSequenceNode decl) {
        this.declarations = decl;
    }

    public void setDavaBody(DavaBody bod) {
        this.davaBody = bod;
    }

    public DavaBody getDavaBody() {
        return this.davaBody;
    }

    public void storeLocals(Body OrigBody) {
        if (!(OrigBody instanceof DavaBody)) {
            throw new RuntimeException("Only DavaBodies should invoke this method");
        }
        this.davaBody = (DavaBody)OrigBody;
        this.typeToLocals = new DeterministicHashMap<Type, List>(OrigBody.getLocalCount() * 2 + 1, 0.7f);
        HashSet<Value> params = new HashSet<Value>();
        params.addAll(this.davaBody.get_ParamMap().values());
        params.addAll(this.davaBody.get_CaughtRefs());
        HashSet<Object> thisLocals = this.davaBody.get_ThisLocals();
        for (Local local : OrigBody.getLocals()) {
            List<Local> localList;
            if (params.contains(local) || thisLocals.contains(local)) continue;
            Type t = local.getType();
            String typeName = t.toString();
            if (this.typeToLocals.containsKey(t)) {
                localList = this.typeToLocals.get(t);
            } else {
                localList = new ArrayList();
                this.typeToLocals.put(t, localList);
            }
            localList.add(local);
        }
        ArrayList<Object> statementSequence = new ArrayList<Object>();
        for (Type typeObject : this.typeToLocals.keySet()) {
            String type = typeObject.toString();
            List localList = this.typeToLocals.get(typeObject);
            Object[] locals = localList.toArray();
            DVariableDeclarationStmt varStmt = null;
            varStmt = new DVariableDeclarationStmt(typeObject, this.davaBody);
            for (Object element2 : locals) {
                varStmt.addLocal((Local)element2);
            }
            AugmentedStmt as = new AugmentedStmt(varStmt);
            statementSequence.add(as);
        }
        this.declarations = new ASTStatementSequenceNode(statementSequence);
        this.body.add(0, this.declarations);
        this.subBodies = new ArrayList();
        this.subBodies.add(this.body);
    }

    public ASTMethodNode(List<Object> body) {
        this.body = body;
        this.subBodies.add(body);
    }

    public List getDeclaredLocals() {
        ArrayList toReturn = new ArrayList();
        Iterator<Object> it = this.declarations.getStatements().iterator();
        while (it.hasNext()) {
            Stmt s2 = ((AugmentedStmt)it.next()).get_Stmt();
            if (!(s2 instanceof DVariableDeclarationStmt)) continue;
            DVariableDeclarationStmt varStmt = (DVariableDeclarationStmt)s2;
            List declarations = varStmt.getDeclarations();
            Iterator decIt = declarations.iterator();
            while (decIt.hasNext()) {
                toReturn.add(decIt.next());
            }
        }
        return toReturn;
    }

    public void removeDeclaredLocal(Local local) {
        Stmt s2 = null;
        Iterator<Object> it = this.declarations.getStatements().iterator();
        while (it.hasNext()) {
            s2 = ((AugmentedStmt)it.next()).get_Stmt();
            if (!(s2 instanceof DVariableDeclarationStmt)) continue;
            DVariableDeclarationStmt varStmt = (DVariableDeclarationStmt)s2;
            List list = varStmt.getDeclarations();
            Iterator decIt = list.iterator();
            boolean foundIt = false;
            while (decIt.hasNext()) {
                Local temp = (Local)decIt.next();
                if (temp.getName().compareTo(local.getName()) != 0) continue;
                foundIt = true;
                break;
            }
            if (!foundIt) continue;
            varStmt.removeLocal(local);
            break;
        }
        ArrayList<Object> newSequence = new ArrayList<Object>();
        for (AugmentedStmt augmentedStmt : this.declarations.getStatements()) {
            DVariableDeclarationStmt varStmt;
            s2 = augmentedStmt.get_Stmt();
            if (!(s2 instanceof DVariableDeclarationStmt) || (varStmt = (DVariableDeclarationStmt)s2).getDeclarations().size() == 0) continue;
            newSequence.add(augmentedStmt);
        }
        this.declarations.setStatements(newSequence);
    }

    public void replaceBody(List<Object> body) {
        this.body = body;
        this.subBodies = new ArrayList();
        this.subBodies.add(body);
    }

    @Override
    public Object clone() {
        ASTMethodNode toReturn = new ASTMethodNode(this.body);
        toReturn.setDeclarations((ASTStatementSequenceNode)this.declarations.clone());
        toReturn.setDontPrintLocals(this.dontPrintLocals);
        return toReturn;
    }

    public void setDontPrintLocals(List<Local> list) {
        this.dontPrintLocals = list;
    }

    public void addToDontPrintLocalsList(Local toAdd) {
        this.dontPrintLocals.add(toAdd);
    }

    @Override
    public void perform_Analysis(ASTAnalysis a2) {
        this.perform_AnalysisOnSubBodies(a2);
    }

    @Override
    public void toString(UnitPrinter up) {
        if (!(up instanceof DavaUnitPrinter)) {
            throw new RuntimeException("Only DavaUnitPrinter should be used to print DavaBody");
        }
        DavaUnitPrinter dup = (DavaUnitPrinter)up;
        if (this.davaBody != null) {
            InstanceInvokeExpr constructorExpr = this.davaBody.get_ConstructorExpr();
            if (constructorExpr != null) {
                boolean printCloseBrace = true;
                if (this.davaBody.getMethod().getDeclaringClass().getName().equals(constructorExpr.getMethodRef().declaringClass().toString())) {
                    dup.printString("        this(");
                } else if (constructorExpr.getArgCount() > 0) {
                    dup.printString("        super(");
                } else {
                    printCloseBrace = false;
                }
                Iterator<Value> ait = constructorExpr.getArgs().iterator();
                while (ait.hasNext()) {
                    Value arg = ait.next();
                    if (arg instanceof Value) {
                        dup.noIndent();
                        arg.toString(dup);
                    } else {
                        dup.printString(arg.toString());
                    }
                    if (!ait.hasNext()) continue;
                    dup.printString(", ");
                }
                if (printCloseBrace) {
                    dup.printString(");\n");
                }
            }
            up.newline();
        }
        this.printDeclarationsFollowedByBody(up, this.body);
    }

    public void printDeclarationsFollowedByBody(UnitPrinter up, List<Object> body) {
        boolean bl;
        AugmentedStmt tempas;
        Stmt temps;
        List<Object> tempstmts;
        ASTNode firstNode;
        List<Object> stmts = this.declarations.getStatements();
        for (AugmentedStmt augmentedStmt : stmts) {
            Stmt u = augmentedStmt.get_Stmt();
            if (u instanceof DVariableDeclarationStmt) {
                DVariableDeclarationStmt declStmt = (DVariableDeclarationStmt)u;
                List localDeclarations = declStmt.getDeclarations();
                boolean shouldContinue = false;
                Iterator declsIt = localDeclarations.iterator();
                while (declsIt.hasNext()) {
                    if (this.dontPrintLocals.contains(declsIt.next())) continue;
                    shouldContinue = true;
                    break;
                }
                if (!shouldContinue || localDeclarations.size() == 0) continue;
                if (!(up instanceof DavaUnitPrinter)) {
                    throw new RuntimeException("DavaBody should always be printed using the DavaUnitPrinter");
                }
                DavaUnitPrinter dup = (DavaUnitPrinter)up;
                dup.startUnit(u);
                String type = declStmt.getType().toString();
                if (type.equals("null_type")) {
                    dup.printString("Object");
                } else {
                    IterableSet<String> importSet = this.davaBody.getImportList();
                    if (!importSet.contains(type)) {
                        this.davaBody.addToImportList(type);
                    }
                    type = RemoveFullyQualifiedName.getReducedName(this.davaBody.getImportList(), type, declStmt.getType());
                    dup.printString(type);
                }
                dup.printString(" ");
                int number = 0;
                for (Local tempDec : localDeclarations) {
                    if (this.dontPrintLocals.contains(tempDec)) continue;
                    if (number != 0) {
                        dup.printString(", ");
                    }
                    ++number;
                    dup.printString(tempDec.getName());
                }
                up.literal(";");
                up.endUnit(u);
                up.newline();
                continue;
            }
            up.startUnit(u);
            u.toString(up);
            up.literal(";");
            up.endUnit(u);
            up.newline();
        }
        boolean bl2 = false;
        if (body.size() > 0 && (firstNode = (ASTNode)body.get(0)) instanceof ASTStatementSequenceNode && (tempstmts = ((ASTStatementSequenceNode)firstNode).getStatements()).size() != 0 && (temps = (tempas = (AugmentedStmt)tempstmts.get(0)).get_Stmt()) instanceof DVariableDeclarationStmt) {
            bl = true;
            this.body_toString(up, body.subList(1, body.size()));
        }
        if (!bl) {
            this.body_toString(up, body);
        }
    }

    public String toString() {
        InstanceInvokeExpr constructorExpr;
        StringBuffer b = new StringBuffer();
        if (this.davaBody != null && (constructorExpr = this.davaBody.get_ConstructorExpr()) != null) {
            if (this.davaBody.getMethod().getDeclaringClass().getName().equals(constructorExpr.getMethodRef().declaringClass().toString())) {
                b.append("        this(");
            } else {
                b.append("        super(");
            }
            Iterator<Value> ait = constructorExpr.getArgs().iterator();
            while (ait.hasNext()) {
                b.append(ait.toString());
                if (!ait.hasNext()) continue;
                b.append(", ");
            }
            b.append(");\n\n");
        }
        b.append(this.body_toString(this.body));
        return b.toString();
    }

    @Override
    public void apply(Analysis a2) {
        a2.caseASTMethodNode(this);
    }
}

