/*
 * Decompiled with CFR 0.152.
 */
package soot.coffi;

import java.io.PrintStream;
import soot.ArrayType;
import soot.RefType;
import soot.Type;
import soot.coffi.UnusuableType;

class TypeArray {
    private Type[] types;

    private TypeArray() {
    }

    public static TypeArray v(int size2) {
        TypeArray newArray = new TypeArray();
        newArray.types = new Type[size2];
        for (int i = 0; i < size2; ++i) {
            newArray.types[i] = UnusuableType.v();
        }
        return newArray;
    }

    public Type get(int index) {
        return this.types[index];
    }

    public TypeArray set(int index, Type type) {
        TypeArray newArray = new TypeArray();
        newArray.types = (Type[])this.types.clone();
        newArray.types[index] = type;
        return newArray;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TypeArray) {
            TypeArray other = (TypeArray)obj;
            if (this.types.length != other.types.length) {
                return false;
            }
            for (Type element2 : this.types) {
                if (element2.equals(element2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public TypeArray merge(TypeArray otherArray) {
        TypeArray newArray = new TypeArray();
        if (this.types.length != otherArray.types.length) {
            throw new RuntimeException("Merging of type arrays failed; unequal array length");
        }
        newArray.types = new Type[this.types.length];
        for (int i = 0; i < this.types.length; ++i) {
            newArray.types[i] = this.types[i].equals(otherArray.types[i]) ? this.types[i] : (!(!(this.types[i] instanceof ArrayType) && !(this.types[i] instanceof RefType) || !(otherArray.types[i] instanceof ArrayType) && !(otherArray.types[i] instanceof RefType)) ? RefType.v("java.lang.Object") : UnusuableType.v());
        }
        return newArray;
    }

    public void print(PrintStream out) {
        for (int i = 0; i < this.types.length; ++i) {
            out.println(i + ": " + this.types[i].toString());
        }
    }
}

