/*
 * Decompiled with CFR 0.152.
 */
package soot.baf.internal;

import java.util.Collections;
import java.util.List;
import soot.Unit;
import soot.UnitBox;
import soot.UnitPrinter;
import soot.baf.internal.AbstractInst;
import soot.util.Switch;

public abstract class AbstractBranchInst
extends AbstractInst {
    UnitBox targetBox;
    final List<UnitBox> targetBoxes;

    AbstractBranchInst(UnitBox targetBox) {
        this.targetBox = targetBox;
        this.targetBoxes = Collections.singletonList(targetBox);
    }

    @Override
    public abstract String getName();

    @Override
    public String toString() {
        String target = "";
        Unit targetUnit = this.getTarget();
        target = this == targetUnit ? this.getName() : this.getTarget().toString();
        return this.getName() + " " + target;
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal(this.getName());
        up.literal(" ");
        this.targetBox.toString(up);
    }

    public Unit getTarget() {
        return this.targetBox.getUnit();
    }

    public void setTarget(Unit target) {
        this.targetBox.setUnit(target);
    }

    public UnitBox getTargetBox() {
        return this.targetBox;
    }

    @Override
    public List<UnitBox> getUnitBoxes() {
        return this.targetBoxes;
    }

    @Override
    public abstract void apply(Switch var1);

    @Override
    public boolean branches() {
        return true;
    }
}

