/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import soot.AbstractUnitPrinter;
import soot.Body;
import soot.PatchingChain;
import soot.SootFieldRef;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.UnitBox;
import soot.jimple.IdentityRef;

public abstract class LabeledUnitPrinter
extends AbstractUnitPrinter {
    protected Map<Unit, String> labels;
    protected Map<Unit, String> references;
    protected String labelIndent = "     ";

    public LabeledUnitPrinter(Body b) {
        this.createLabelMaps(b);
    }

    public Map<Unit, String> labels() {
        return this.labels;
    }

    public Map<Unit, String> references() {
        return this.references;
    }

    @Override
    public abstract void literal(String var1);

    @Override
    public abstract void methodRef(SootMethodRef var1);

    @Override
    public abstract void fieldRef(SootFieldRef var1);

    @Override
    public abstract void identityRef(IdentityRef var1);

    @Override
    public abstract void type(Type var1);

    @Override
    public void unitRef(Unit u, boolean branchTarget) {
        String oldIndent = this.getIndent();
        if (branchTarget) {
            this.setIndent(this.labelIndent);
            this.handleIndent();
            this.setIndent(oldIndent);
            String label = this.labels.get(u);
            if (label == null || "<unnamed>".equals(label)) {
                label = "[?= " + u + "]";
            }
            this.output.append(label);
        } else {
            String ref = this.references.get(u);
            if (this.startOfLine) {
                String newIndent = "(" + ref + ")" + this.indent.substring(ref.length() + 2);
                this.setIndent(newIndent);
                this.handleIndent();
                this.setIndent(oldIndent);
            } else {
                this.output.append(ref);
            }
        }
    }

    private void createLabelMaps(Body body) {
        PatchingChain<Unit> units = body.getUnits();
        this.labels = new HashMap<Unit, String>(units.size() * 2 + 1, 0.7f);
        this.references = new HashMap<Unit, String>(units.size() * 2 + 1, 0.7f);
        HashSet<Unit> labelStmts = new HashSet<Unit>();
        HashSet<Unit> refStmts = new HashSet<Unit>();
        for (UnitBox box : body.getAllUnitBoxes()) {
            Unit stmt = box.getUnit();
            if (box.isBranchTarget()) {
                labelStmts.add(stmt);
                continue;
            }
            refStmts.add(stmt);
        }
        int maxDigits = 1 + (int)Math.log10(labelStmts.size());
        String formatString = "label%0" + maxDigits + "d";
        int labelCount = 0;
        int refCount = 0;
        for (Unit s2 : units) {
            if (labelStmts.contains(s2)) {
                this.labels.put(s2, String.format(formatString, ++labelCount));
            }
            if (!refStmts.contains(s2)) continue;
            this.references.put(s2, Integer.toString(refCount++));
        }
    }
}

