/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import soot.ClassSource;
import soot.G;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.javaToJimple.IInitialResolver;
import soot.jimple.JimpleMethodSource;
import soot.jimple.parser.JimpleAST;
import soot.jimple.parser.lexer.LexerException;
import soot.jimple.parser.parser.ParserException;
import soot.options.Options;

public class JimpleClassSource
extends ClassSource {
    protected InputStream classFile;

    public JimpleClassSource(String className, InputStream classFile) {
        super(className);
        this.classFile = classFile;
    }

    @Override
    public IInitialResolver.Dependencies resolve(SootClass sc) {
        if (Options.v().verbose()) {
            G.v().out.println("resolving [from .jimple]: " + this.className);
        }
        try {
            JimpleAST jimpAST = new JimpleAST(this.classFile);
            jimpAST.getSkeleton(sc);
            JimpleMethodSource mtdSrc = new JimpleMethodSource(jimpAST);
            Iterator<SootMethod> mtdIt = sc.methodIterator();
            while (mtdIt.hasNext()) {
                SootMethod sm = mtdIt.next();
                sm.setSource(mtdSrc);
            }
            IInitialResolver.Dependencies deps = new IInitialResolver.Dependencies();
            for (String t : jimpAST.getCstPool()) {
                deps.typesToSignature.add(RefType.v(t));
            }
            this.classFile.close();
            return deps;
        }
        catch (IOException e) {
            throw new RuntimeException("!?", e);
        }
        catch (ParserException e) {
            throw new RuntimeException("Error parsing class " + this.className + " " + e.getMessage(), e);
        }
        catch (LexerException e) {
            throw new RuntimeException("Error lexing class " + this.className + " " + e.getMessage(), e);
        }
    }
}

