/*
 * Decompiled with CFR 0.152.
 */
package soot;

import soot.ClassProvider;
import soot.ClassSource;
import soot.JavaClassSource;
import soot.SourceLocator;
import soot.javaToJimple.InitialResolver;
import soot.options.Options;

public class JavaClassProvider
implements ClassProvider {
    @Override
    public ClassSource find(String className) {
        if (Options.v().polyglot() && InitialResolver.v().hasASTForSootName(className)) {
            InitialResolver.v().setASTForSootName(className);
            return new JavaClassSource(className);
        }
        boolean checkAgain = className.indexOf(36) >= 0;
        String javaClassName = SourceLocator.v().getSourceForClass(className);
        String fileName = javaClassName.replace('.', '/') + ".java";
        SourceLocator.FoundFile file = SourceLocator.v().lookupInClassPath(fileName);
        if (file == null && checkAgain) {
            fileName = className.replace('.', '/') + ".java";
            file = SourceLocator.v().lookupInClassPath(fileName);
        }
        if (file == null) {
            return null;
        }
        if (file.file == null) {
            throw new JarException(className);
        }
        return new JavaClassSource(className, file.file);
    }

    public static class JarException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public JarException(String className) {
            super("Class " + className + " was found in an archive, but Soot doesn't support reading source files out of an archive");
        }
    }
}

