/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipFile;
import soot.JastAddJ.CompilationUnit;
import soot.JastAddJ.FolderPart;
import soot.JastAddJ.Program;
import soot.JastAddJ.ZipFilePart;

public class PathPart {
    public InputStream is;
    protected String pathName;
    protected String relativeName;
    protected String fullName;
    long age;
    Program program;
    protected boolean isSource;

    protected PathPart() {
    }

    protected String fileSuffix() {
        return this.isSource ? ".java" : ".class";
    }

    public static PathPart createSourcePath(String fileName, Program program) {
        PathPart p = PathPart.createPathPart(fileName);
        if (p != null) {
            p.isSource = true;
            p.program = program;
        }
        return p;
    }

    public static PathPart createClassPath(String fileName, Program program) {
        PathPart p = PathPart.createPathPart(fileName);
        if (p != null) {
            p.isSource = false;
            p.program = program;
        }
        return p;
    }

    private static PathPart createPathPart(String s2) {
        try {
            File f = new File(s2);
            if (f.isDirectory()) {
                return new FolderPart(f);
            }
            if (f.isFile()) {
                return new ZipFilePart(new ZipFile(f));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public boolean hasPackage(String name) {
        return false;
    }

    public boolean selectCompilationUnit(String canonicalName) throws IOException {
        return false;
    }

    public CompilationUnit getCompilationUnit() {
        long startTime = System.currentTimeMillis();
        if (!this.isSource) {
            try {
                if (this.program.options().verbose()) {
                    System.out.print("Loading .class file: " + this.fullName + " ");
                }
                CompilationUnit u = this.program.bytecodeReader.read(this.is, this.fullName, this.program);
                u.setPathName(this.pathName);
                u.setRelativeName(this.relativeName);
                u.setFromSource(false);
                this.is.close();
                this.is = null;
                if (this.program.options().verbose()) {
                    System.out.println("from " + this.pathName + " in " + (System.currentTimeMillis() - startTime) + " ms");
                }
                return u;
            }
            catch (Exception e) {
                throw new Error("Error loading " + this.fullName, e);
            }
        }
        try {
            if (this.program.options().verbose()) {
                System.out.print("Loading .java file: " + this.fullName + " ");
            }
            CompilationUnit u = this.program.javaParser.parse(this.is, this.fullName);
            this.is.close();
            this.is = null;
            u.setPathName(this.pathName);
            u.setRelativeName(this.relativeName);
            u.setFromSource(true);
            if (this.program.options().verbose()) {
                System.out.println("in " + (System.currentTimeMillis() - startTime) + " ms");
            }
            return u;
        }
        catch (Exception e) {
            System.err.println("Unexpected error of kind " + e.getClass().getName());
            throw new Error(this.fullName + ": " + e.getMessage(), e);
        }
    }
}

