/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import java.util.Iterator;
import soot.JastAddJ.Access;
import soot.JastAddJ.Attributes;
import soot.JastAddJ.BodyDecl;
import soot.JastAddJ.BytecodeParser;
import soot.JastAddJ.CONSTANT_Utf8_Info;
import soot.JastAddJ.EnumConstant;
import soot.JastAddJ.Expr;
import soot.JastAddJ.FieldDeclaration;
import soot.JastAddJ.FieldDescriptor;
import soot.JastAddJ.List;
import soot.JastAddJ.Modifier;
import soot.JastAddJ.Opt;
import soot.JastAddJ.Signatures;

public class FieldInfo {
    private BytecodeParser p;
    String name;
    int flags;
    private FieldDescriptor fieldDescriptor;
    private Attributes.FieldAttributes attributes;

    public FieldInfo(BytecodeParser parser2) {
        this.p = parser2;
        this.flags = this.p.u2();
        int name_index = this.p.u2();
        this.name = ((CONSTANT_Utf8_Info)this.p.constantPool[name_index]).string();
        this.fieldDescriptor = new FieldDescriptor(this.p, this.name);
        this.attributes = new Attributes.FieldAttributes(this.p);
    }

    public BodyDecl bodyDecl() {
        FieldDeclaration f;
        if ((this.flags & 0x4000) != 0) {
            f = new EnumConstant(BytecodeParser.modifiers(this.flags), this.name, new List<Expr>(), new List<BodyDecl>());
        } else {
            Signatures.FieldSignature s2 = this.attributes.fieldSignature;
            Access type = s2 != null ? s2.fieldTypeAccess() : this.fieldDescriptor.type();
            f = new FieldDeclaration(BytecodeParser.modifiers(this.flags), type, this.name, new Opt<Expr>());
        }
        if (this.attributes.constantValue() != null) {
            if (this.fieldDescriptor.isBoolean()) {
                f.setInit(this.attributes.constantValue().exprAsBoolean());
            } else {
                f.setInit(this.attributes.constantValue().expr());
            }
        }
        if (this.attributes.annotations != null) {
            Iterator iter2 = this.attributes.annotations.iterator();
            while (iter2.hasNext()) {
                f.getModifiersNoTransform().addModifier((Modifier)iter2.next());
            }
        }
        return f;
    }

    public boolean isSynthetic() {
        return this.attributes.isSynthetic();
    }
}

