/*
 * Decompiled with CFR 0.152.
 */
package ppg.atoms;

import java.util.Vector;
import ppg.atoms.GrammarPart;
import ppg.atoms.Nonterminal;
import ppg.atoms.SemanticAction;
import ppg.parse.Unparse;
import ppg.util.CodeWriter;

public class Production
implements Unparse {
    private Nonterminal lhs;
    private Vector rhs;
    private static String HEADER = "ppg [nterm]: ";

    public Production(Nonterminal lhs, Vector rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public Nonterminal getLHS() {
        return this.lhs;
    }

    public void setLHS(Nonterminal nt) {
        this.lhs = nt;
    }

    public Vector getRHS() {
        return this.rhs;
    }

    public Object clone() {
        return new Production((Nonterminal)this.lhs.clone(), (Vector)this.rhs.clone());
    }

    public void drop(Production prod) {
        Vector toDrop = prod.getRHS();
        block0: for (int i = 0; i < toDrop.size(); ++i) {
            Vector target = (Vector)toDrop.elementAt(i);
            for (int j = 0; j < this.rhs.size(); ++j) {
                Vector source = (Vector)this.rhs.elementAt(j);
                if (Production.isSameProduction(target, source)) {
                    this.rhs.removeElementAt(j);
                    continue block0;
                }
                if (j != this.rhs.size() - 1) continue;
                System.err.println(HEADER + "no match found for production:");
                System.err.print(prod.getLHS() + " ::= ");
                for (int k = 0; k < target.size(); ++k) {
                    System.err.print(target.elementAt(k) + " ");
                }
                System.exit(1);
            }
        }
    }

    public static boolean isSameProduction(Vector u, Vector v) {
        int uIdx = 0;
        int vIdx = 0;
        GrammarPart ug = null;
        GrammarPart vg = null;
        while (uIdx < u.size() && vIdx < v.size()) {
            ug = (GrammarPart)u.elementAt(uIdx);
            if (ug instanceof SemanticAction) {
                ++uIdx;
                continue;
            }
            vg = (GrammarPart)v.elementAt(vIdx);
            if (vg instanceof SemanticAction) {
                ++vIdx;
                continue;
            }
            if (!ug.equals(vg)) {
                return false;
            }
            ++uIdx;
            ++vIdx;
        }
        if (uIdx == u.size() && vIdx == v.size()) {
            return true;
        }
        if (uIdx < u.size()) {
            while (uIdx < u.size()) {
                ug = (GrammarPart)u.elementAt(uIdx);
                if (!(ug instanceof SemanticAction)) {
                    return false;
                }
                ++uIdx;
            }
            return true;
        }
        while (vIdx < v.size()) {
            vg = (GrammarPart)v.elementAt(vIdx);
            if (!(vg instanceof SemanticAction)) {
                return false;
            }
            ++vIdx;
        }
        return true;
    }

    public void union(Production prod) {
        Vector additional = prod.getRHS();
        this.union(additional);
    }

    public void union(Vector prodList) {
        for (int i = 0; i < prodList.size(); ++i) {
            Vector current;
            Vector toAdd = (Vector)prodList.elementAt(i);
            for (int j = 0; j < this.rhs.size() && !Production.isSameProduction(toAdd, current = (Vector)this.rhs.elementAt(i)); ++j) {
                if (j != this.rhs.size() - 1) continue;
                this.rhs.addElement(toAdd);
            }
        }
    }

    public void add(Production prod) {
        Vector additional = prod.getRHS();
        for (int i = 0; i < additional.size(); ++i) {
            this.rhs.addElement(additional.elementAt(i));
        }
    }

    public void addToRHS(Vector rhsPart) {
        this.rhs.addElement(rhsPart);
    }

    private void assertSameLHS(Production prod, String function) {
        if (!prod.getLHS().equals(this.lhs)) {
            System.err.println(HEADER + "nonterminals do not match in Production." + function + "(): current is " + this.lhs + ", given: " + prod.getLHS());
            System.exit(1);
        }
    }

    public void unparse(CodeWriter cw) {
        cw.begin(0);
        cw.write(this.lhs.toString() + " ::=");
        cw.allowBreak(3);
        for (int i = 0; i < this.rhs.size(); ++i) {
            Vector rhs_part = (Vector)this.rhs.elementAt(i);
            for (int j = 0; j < rhs_part.size(); ++j) {
                cw.write(" ");
                ((GrammarPart)rhs_part.elementAt(j)).unparse(cw);
            }
            if (i >= this.rhs.size() - 1) continue;
            cw.allowBreak(0);
            cw.write(" | ");
        }
        cw.write(";");
        cw.newline();
        cw.newline();
        cw.end();
    }

    public String toString() {
        String result2 = this.lhs.toString();
        result2 = result2 + " ::=";
        for (int i = 0; i < this.rhs.size(); ++i) {
            Vector rhs_part = (Vector)this.rhs.elementAt(i);
            for (int j = 0; j < rhs_part.size(); ++j) {
                result2 = result2 + " " + rhs_part.elementAt(j).toString();
            }
            if (i >= this.rhs.size() - 1) continue;
            result2 = result2 + " | ";
        }
        return result2 + ";";
    }
}

