/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import polyglot.ast.Block;
import polyglot.ast.CompoundStmt;
import polyglot.ast.Initializer;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt;
import polyglot.ast.Term;
import polyglot.frontend.Job;
import polyglot.main.Report;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.visit.DataFlow;
import polyglot.visit.FlowGraph;

public class ReachChecker
extends DataFlow {
    public ReachChecker(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf, true, true);
    }

    public DataFlow.Item createInitialItem(FlowGraph graph, Term node) {
        if (node == graph.entryNode()) {
            return DataFlowItem.REACHABLE;
        }
        return DataFlowItem.NOT_REACHABLE;
    }

    public Map flow(DataFlow.Item in, FlowGraph graph, Term n, Set succEdgeKeys) {
        if (in == DataFlowItem.NOT_REACHABLE) {
            return ReachChecker.itemToMap(in, succEdgeKeys);
        }
        Map m = ReachChecker.itemToMap(DataFlowItem.REACHABLE_EX_ONLY, succEdgeKeys);
        if (succEdgeKeys.contains(FlowGraph.EDGE_KEY_OTHER)) {
            m.put(FlowGraph.EDGE_KEY_OTHER, DataFlowItem.REACHABLE);
        }
        if (succEdgeKeys.contains(FlowGraph.EDGE_KEY_TRUE)) {
            m.put(FlowGraph.EDGE_KEY_TRUE, DataFlowItem.REACHABLE);
        }
        if (succEdgeKeys.contains(FlowGraph.EDGE_KEY_FALSE)) {
            m.put(FlowGraph.EDGE_KEY_FALSE, DataFlowItem.REACHABLE);
        }
        return m;
    }

    public DataFlow.Item confluence(List inItems, Term node, FlowGraph graph) {
        throw new InternalCompilerError("Should never be called.");
    }

    public DataFlow.Item confluence(List inItems, List itemKeys, Term node, FlowGraph graph) {
        List l = this.filterItemsNonException(inItems, itemKeys);
        Iterator i = l.iterator();
        while (i.hasNext()) {
            if (i.next() != DataFlowItem.REACHABLE) continue;
            return DataFlowItem.REACHABLE;
        }
        i = inItems.iterator();
        while (i.hasNext()) {
            if (!((DataFlowItem)i.next()).reachable) continue;
            return DataFlowItem.REACHABLE_EX_ONLY;
        }
        return DataFlowItem.NOT_REACHABLE;
    }

    public Node leaveCall(Node n) throws SemanticException {
        if (n instanceof Term) {
            n = this.checkReachability((Term)n);
        }
        return super.leaveCall(n);
    }

    protected Node checkReachability(Term n) throws SemanticException {
        Collection peers;
        FlowGraph g = this.currentFlowGraph();
        if (g != null && (peers = g.peers(n)) != null && !peers.isEmpty()) {
            boolean isInitializer = n instanceof Initializer;
            Iterator iter2 = peers.iterator();
            while (iter2.hasNext()) {
                FlowGraph.Peer p = (FlowGraph.Peer)iter2.next();
                if (p.inItem() != null) {
                    DataFlowItem dfi = (DataFlowItem)p.inItem();
                    if (isInitializer && !dfi.normalReachable) {
                        throw new SemanticException("Initializers must be able to complete normally.", n.position());
                    }
                    if (dfi.reachable) {
                        return n.reachable(true);
                    }
                }
                if (p.outItems == null) continue;
                Iterator k = p.outItems.values().iterator();
                while (k.hasNext()) {
                    DataFlowItem item = (DataFlowItem)k.next();
                    if (item == null || !item.reachable) continue;
                    return n.reachable(true);
                }
            }
            if ((n = n.reachable(false)) instanceof Block && ((Block)n).statements().isEmpty() || n instanceof Stmt && !(n instanceof CompoundStmt)) {
                throw new SemanticException("Unreachable statement.", n.position());
            }
        }
        return n;
    }

    public void post(FlowGraph graph, Term root) throws SemanticException {
        if (Report.should_report("cfg", 2)) {
            this.dumpFlowGraph(graph, root);
        }
    }

    public void check(FlowGraph graph, Term n, DataFlow.Item inItem, Map outItems) throws SemanticException {
        throw new InternalCompilerError("ReachChecker.check should never be called.");
    }

    protected static class DataFlowItem
    extends DataFlow.Item {
        final boolean reachable;
        final boolean normalReachable;
        public static final DataFlowItem REACHABLE = new DataFlowItem(true, true);
        public static final DataFlowItem REACHABLE_EX_ONLY = new DataFlowItem(true, false);
        public static final DataFlowItem NOT_REACHABLE = new DataFlowItem(false, false);

        protected DataFlowItem(boolean reachable, boolean normalReachable) {
            this.reachable = reachable;
            this.normalReachable = normalReachable;
        }

        public String toString() {
            return (this.reachable ? "" : "not ") + "reachable" + (this.normalReachable ? "" : " by exceptions only");
        }

        public boolean equals(Object o) {
            if (o instanceof DataFlowItem) {
                return this.reachable == ((DataFlowItem)o).reachable && this.normalReachable == ((DataFlowItem)o).normalReachable;
            }
            return false;
        }

        public int hashCode() {
            return (this.reachable ? 5423 : 5753) + (this.normalReachable ? 31 : -2);
        }
    }
}

