/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import polyglot.ast.CodeDecl;
import polyglot.ast.MethodDecl;
import polyglot.ast.NodeFactory;
import polyglot.ast.Return;
import polyglot.ast.Term;
import polyglot.frontend.Job;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.visit.DataFlow;
import polyglot.visit.FlowGraph;

public class ExitChecker
extends DataFlow {
    protected CodeDecl code;

    public ExitChecker(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf, false);
    }

    protected FlowGraph initGraph(CodeDecl code, Term root) {
        MethodDecl d;
        this.code = code;
        if (code instanceof MethodDecl && !(d = (MethodDecl)code).methodInstance().returnType().isVoid()) {
            return super.initGraph(code, root);
        }
        return null;
    }

    public DataFlow.Item createInitialItem(FlowGraph graph, Term node) {
        return DataFlowItem.EXITS;
    }

    public Map flow(DataFlow.Item in, FlowGraph graph, Term n, Set succEdgeKeys) {
        if (n instanceof Return) {
            return ExitChecker.itemToMap(DataFlowItem.EXITS, succEdgeKeys);
        }
        if (n == graph.exitNode()) {
            Map m = ExitChecker.itemToMap(DataFlowItem.EXITS, succEdgeKeys);
            if (succEdgeKeys.contains(FlowGraph.EDGE_KEY_OTHER)) {
                m.put(FlowGraph.EDGE_KEY_OTHER, DataFlowItem.DOES_NOT_EXIT);
            }
            if (succEdgeKeys.contains(FlowGraph.EDGE_KEY_TRUE)) {
                m.put(FlowGraph.EDGE_KEY_TRUE, DataFlowItem.DOES_NOT_EXIT);
            }
            if (succEdgeKeys.contains(FlowGraph.EDGE_KEY_FALSE)) {
                m.put(FlowGraph.EDGE_KEY_FALSE, DataFlowItem.DOES_NOT_EXIT);
            }
            return m;
        }
        return ExitChecker.itemToMap(in, succEdgeKeys);
    }

    public DataFlow.Item confluence(List inItems, Term node, FlowGraph graph) {
        Iterator i = inItems.iterator();
        while (i.hasNext()) {
            if (((DataFlowItem)i.next()).exits) continue;
            return DataFlowItem.DOES_NOT_EXIT;
        }
        return DataFlowItem.EXITS;
    }

    public void check(FlowGraph graph, Term n, DataFlow.Item inItem, Map outItems) throws SemanticException {
        DataFlowItem outItem;
        if (n == graph.entryNode() && outItems != null && !outItems.isEmpty() && (outItem = (DataFlowItem)outItems.values().iterator().next()) != null && !outItem.exits) {
            throw new SemanticException("Missing return statement.", this.code.position());
        }
    }

    protected static class DataFlowItem
    extends DataFlow.Item {
        final boolean exits;
        public static final DataFlowItem EXITS = new DataFlowItem(true);
        public static final DataFlowItem DOES_NOT_EXIT = new DataFlowItem(false);

        protected DataFlowItem(boolean exits) {
            this.exits = exits;
        }

        public String toString() {
            return "exits=" + this.exits;
        }

        public boolean equals(Object o) {
            if (o instanceof DataFlowItem) {
                return this.exits == ((DataFlowItem)o).exits;
            }
            return false;
        }

        public int hashCode() {
            return this.exits ? 5235 : 8673;
        }
    }
}

