/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

public class StringUtil {
    public static String getPackageComponent(String fullName) {
        int lastDot = fullName.lastIndexOf(46);
        return lastDot >= 0 ? fullName.substring(0, lastDot) : "";
    }

    public static String getShortNameComponent(String fullName) {
        int lastDot = fullName.lastIndexOf(46);
        return lastDot >= 0 ? fullName.substring(lastDot + 1) : fullName;
    }

    public static boolean isNameShort(String name) {
        return name.indexOf(46) < 0;
    }

    public static String getFirstComponent(String fullName) {
        int firstDot = fullName.indexOf(46);
        return firstDot >= 0 ? fullName.substring(0, firstDot) : fullName;
    }

    public static String removeFirstComponent(String fullName) {
        int firstDot = fullName.indexOf(46);
        return firstDot >= 0 ? fullName.substring(firstDot + 1) : "";
    }

    public static String escape(String s2) {
        return StringUtil.escape(s2, false);
    }

    public static String escape(char c) {
        return StringUtil.escape(String.valueOf(c), false);
    }

    public static String unicodeEscape(String s2) {
        return StringUtil.escape(s2, true);
    }

    public static String unicodeEscape(char c) {
        return StringUtil.escape(String.valueOf(c), true);
    }

    public static String escape(String s2, boolean unicode) {
        StringBuffer sb = new StringBuffer(s2.length());
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            StringUtil.escape(sb, c, unicode);
        }
        return sb.toString();
    }

    private static void escape(StringBuffer sb, char c, boolean unicode) {
        if (c > '\u00ff') {
            if (unicode) {
                String s2 = Integer.toHexString(c);
                while (s2.length() < 4) {
                    s2 = "0" + s2;
                }
                sb.append("\\u" + s2);
            } else {
                sb.append(c);
            }
            return;
        }
        switch (c) {
            case '\b': {
                sb.append("\\b");
                return;
            }
            case '\t': {
                sb.append("\\t");
                return;
            }
            case '\n': {
                sb.append("\\n");
                return;
            }
            case '\f': {
                sb.append("\\f");
                return;
            }
            case '\r': {
                sb.append("\\r");
                return;
            }
            case '\"': {
                sb.append("\\" + c);
                return;
            }
            case '\'': {
                sb.append("\\" + c);
                return;
            }
            case '\\': {
                sb.append("\\" + c);
                return;
            }
        }
        if (c >= ' ' && c < '\u007f') {
            sb.append(c);
            return;
        }
        sb.append("\\" + (char)(48 + c / 64) + (char)(48 + (c & 0x3F) / 8) + (char)(48 + (c & 7)));
    }

    public static String nth(int n) {
        StringBuffer s2 = new StringBuffer(String.valueOf(n));
        if (s2.length() > 1 && s2.charAt(s2.length() - 2) == '1') {
            s2.append("th");
            return s2.toString();
        }
        char last2 = s2.charAt(s2.length() - 1);
        switch (last2) {
            case '1': {
                s2.append("st");
                break;
            }
            case '2': {
                s2.append("nd");
                break;
            }
            case '3': {
                s2.append("rd");
                break;
            }
            default: {
                s2.append("th");
            }
        }
        return s2.toString();
    }
}

