/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.io.IOException;
import java.io.PrintWriter;
import polyglot.util.FormatResult;
import polyglot.util.Item;
import polyglot.util.MaxLevels;
import polyglot.util.Overrun;

class AllowBreak
extends Item {
    final int indent;
    final int level;
    final boolean unified;
    final String alt;
    final int altlen;
    boolean broken = false;

    AllowBreak(int n_, int level_, String alt_, int altlen_, boolean u) {
        this.indent = n_;
        this.alt = alt_;
        this.altlen = altlen_;
        this.level = level_;
        this.unified = u;
    }

    FormatResult formatN(int lmargin, int pos, int rmargin, int fin, MaxLevels m, int minLevel, int minLevelUnified) throws Overrun {
        block6: {
            if (this.canLeaveUnbroken(minLevel, minLevelUnified)) {
                try {
                    this.broken = false;
                    return AllowBreak.format(this.next, lmargin, pos + this.altlen, rmargin, fin, new MaxLevels(Math.min(this.unified ? this.level - 1 : this.level, m.maxLevel), Math.min(this.level - 1, m.maxLevelInner)), minLevel, minLevelUnified);
                }
                catch (Overrun o) {
                    if (this.level <= m.maxLevel) break block6;
                    throw o;
                }
            }
        }
        if (this.canBreak(m)) {
            this.broken = true;
            try {
                return AllowBreak.format(this.next, lmargin, lmargin + this.indent, rmargin, fin, m, Math.max(this.level - 1, minLevel), Math.max(this.level, minLevelUnified));
            }
            catch (Overrun o) {
                o.type = 1;
                throw o;
            }
        }
        throw new IllegalArgumentException("could not either break or not break");
    }

    int sendOutput(PrintWriter o, int lmargin, int pos, boolean success2, Item last2) throws IOException {
        if (this.broken || !success2) {
            o.println();
            for (int i = 0; i < lmargin + this.indent; ++i) {
                o.print(" ");
            }
            return lmargin + this.indent;
        }
        o.print(this.alt);
        return pos + this.altlen;
    }

    boolean canBreak(MaxLevels m) {
        return this.level <= m.maxLevel;
    }

    boolean canLeaveUnbroken(int minLevel, int minLevelUnified) {
        return this.level > minLevelUnified || !this.unified && this.level > minLevel;
    }

    int selfMinIndent(MaxLevels m) {
        if (this.canBreak(m)) {
            return this.indent;
        }
        return -9999;
    }

    int selfMinPosWidth(MaxLevels m) {
        if (this.canBreak(m)) {
            return 0;
        }
        return this.altlen;
    }

    int selfMinWidth(MaxLevels m) {
        if (this.canBreak(m)) {
            return this.indent;
        }
        return -9999;
    }

    boolean selfContainsBreaks(MaxLevels m) {
        return this.canBreak(m);
    }

    String selfToString() {
        if (this.indent == 0) {
            return " ";
        }
        return "^" + this.indent;
    }
}

