/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import polyglot.frontend.ExtensionInfo;
import polyglot.main.Report;

public class Stats {
    protected ExtensionInfo ext;
    protected Map passTimes = new HashMap();
    protected List keys = new ArrayList(20);

    public Stats(ExtensionInfo ext) {
        this.ext = ext;
    }

    public void resetPassTimes(Object key2) {
        this.passTimes.remove(key2);
    }

    public long passTime(Object key2, boolean inclusive2) {
        Times t = (Times)this.passTimes.get(key2);
        if (t == null) {
            return 0L;
        }
        return inclusive2 ? t.inclusive : t.exclusive;
    }

    public void accumPassTimes(Object key2, long in, long ex) {
        Times t = (Times)this.passTimes.get(key2);
        if (t == null) {
            this.keys.add(key2);
            t = new Times();
            this.passTimes.put(key2, t);
        }
        t.inclusive += in;
        t.exclusive += ex;
    }

    public void report() {
        if (Report.should_report("time", 1)) {
            Report.report(1, "\nStatistics for " + this.ext.compilerName() + " (" + this.ext.getClass().getName() + ")");
            Report.report(1, "Pass Inclusive Exclusive");
            Report.report(1, "---- --------- ---------");
            Iterator i = this.keys.iterator();
            while (i.hasNext()) {
                Object key2 = i.next();
                Times t = (Times)this.passTimes.get(key2);
                Report.report(1, key2.toString() + " " + t.inclusive + " " + t.exclusive);
            }
        }
    }

    protected static class Times {
        long inclusive;
        long exclusive;

        protected Times() {
        }
    }
}

