/*
 * Decompiled with CFR 0.152.
 */
package org.k33nteam.jade.solver;

import com.bpodgursky.jbool_expressions.And;
import com.bpodgursky.jbool_expressions.Expression;
import com.bpodgursky.jbool_expressions.Literal;
import com.bpodgursky.jbool_expressions.NExpression;
import com.bpodgursky.jbool_expressions.Not;
import com.bpodgursky.jbool_expressions.Or;
import com.bpodgursky.jbool_expressions.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.k33nteam.jade.solver.ConstrainInfo;
import org.k33nteam.jade.solver.DataObject;
import org.k33nteam.jade.solver.ForwardIntentTaintAnalysis;
import org.k33nteam.jade.solver.IntentTaintFact;
import org.k33nteam.jade.solver.LocalConstraintFlowAnalysis;
import org.k33nteam.jade.solver.model.IntentSource;
import soot.Body;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.ConditionExpr;
import soot.jimple.IfStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.IntConstant;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;
import soot.jimple.internal.JEqExpr;
import soot.jimple.internal.JNeExpr;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.scalar.Pair;

public class NPEDetector {
    private static int processExpression(Expression expression, ForwardIntentTaintAnalysis taintAnalysis, Pair<IntentSource, DataObject> query) {
        if (expression instanceof Variable || expression instanceof Not) {
            return NPEDetector.evaluateSingleExpressionMayNPE(expression, taintAnalysis, query);
        }
        if (expression instanceof Literal) {
            int ret = ((Literal)expression).getValue() ? 1 : 0;
            DataObject object = query.getO2();
            if (object.status == 2) {
                ret = 0;
            } else if (object.status == 1) {
                ret = 1;
            }
            return ret;
        }
        if (expression instanceof NExpression) {
            NExpression nExpression = (NExpression)expression;
            if (nExpression instanceof And) {
                boolean tmp = true;
                boolean modified = false;
                DataObject object = query.getO2();
                if (object.status == 2) {
                    tmp = false;
                } else if (object.status == 1) {
                    tmp = true;
                }
                for (int i = 0; i < nExpression.expressions.length; ++i) {
                    int tmpvar = NPEDetector.processExpression(((NExpression)expression).expressions[i], taintAnalysis, query);
                    if (tmpvar == -1) continue;
                    tmp &= tmpvar == 1;
                    modified = true;
                }
                return modified ? (tmp ? 1 : 0) : -1;
            }
            if (nExpression instanceof Or) {
                boolean tmp = false;
                boolean modified = false;
                DataObject object = query.getO2();
                if (object.status == 2) {
                    tmp = false;
                } else if (object.status == 1) {
                    tmp = true;
                }
                for (int i = 0; i < nExpression.expressions.length; ++i) {
                    int tmpvar = NPEDetector.processExpression(nExpression.expressions[i], taintAnalysis, query);
                    if (tmpvar == -1) continue;
                    tmp |= tmpvar == 1;
                    modified = true;
                }
                return modified ? (tmp ? 1 : 0) : -1;
            }
            throw new RuntimeException();
        }
        throw new RuntimeException();
    }

    public static List<List<Pair<Stmt, SootMethod>>> checkPotentialNPE(SootMethod method) {
        ArrayList<Pair<Stmt, SootMethod>> npeList = new ArrayList<Pair<Stmt, SootMethod>>();
        ArrayList<Pair<Stmt, SootMethod>> indexOOBList = new ArrayList<Pair<Stmt, SootMethod>>();
        IntentTaintFact.reset();
        Body body = method.getActiveBody();
        BriefUnitGraph unitGraph = new BriefUnitGraph(body);
        ForwardIntentTaintAnalysis taintAnalysis = new ForwardIntentTaintAnalysis(unitGraph, body);
        LocalConstraintFlowAnalysis constraintFlowAnalysis = new LocalConstraintFlowAnalysis(unitGraph, true);
        for (Unit unit : body.getUnits()) {
            IntentTaintFact fact;
            Stmt stmt = (Stmt)unit;
            if (stmt.containsInvokeExpr() && stmt.getInvokeExpr() instanceof InstanceInvokeExpr) {
                InstanceInvokeExpr instanceInvokeExpr = (InstanceInvokeExpr)stmt.getInvokeExpr();
                Value value2 = instanceInvokeExpr.getBase();
                fact = (IntentTaintFact)taintAnalysis.getFlowBefore(stmt);
                if (fact.getPairFromValue(value2) == null) continue;
                ConstrainInfo info2 = (ConstrainInfo)constraintFlowAnalysis.getFlowBefore(stmt);
                Expression<IfStmt> expression = info2.expression;
                Pair<IntentSource, DataObject> query = fact.getPairFromValue(value2);
                int ret = NPEDetector.processExpression(expression, taintAnalysis, query);
                if (ret == 1) {
                    npeList.add(new Pair<Stmt, SootMethod>(stmt, body.getMethod()));
                }
                if (!instanceInvokeExpr.getMethod().getName().equals("get") || instanceInvokeExpr.getArgCount() != 1) continue;
                indexOOBList.add(new Pair<Stmt, SootMethod>(stmt, body.getMethod()));
                continue;
            }
            if (!stmt.containsArrayRef()) continue;
            ArrayRef arrayRef = stmt.getArrayRef();
            Value arrayBase = arrayRef.getBase();
            fact = (IntentTaintFact)taintAnalysis.getFlowBefore(stmt);
            if (fact.getPairFromValue(arrayBase) == null) continue;
            indexOOBList.add(new Pair<Stmt, SootMethod>(stmt, body.getMethod()));
        }
        return Arrays.asList(npeList, indexOOBList);
    }

    private static int compareDataObj(DataObject src, DataObject dest) {
        DataObject lptr = src;
        DataObject rptr = dest;
        while (rptr != null) {
            if (lptr == null) {
                return 1;
            }
            if (rptr.status == 2) {
                return 0;
            }
            if (Objects.equals(lptr.key, rptr.key) || lptr.key != null && lptr.key.equals(rptr.key)) {
                if (lptr.status == 2) {
                    return 0;
                }
                if (lptr.status == 1) {
                    return 1;
                }
                rptr = rptr.getData();
                lptr = lptr.getData();
                continue;
            }
            return 1;
        }
        return 0;
    }

    public static int evaluateSingleExpressionMayNPE(Expression expression, ForwardIntentTaintAnalysis analysis, Pair<IntentSource, DataObject> currentInst) {
        DataObject query = currentInst.getO2();
        if (expression instanceof Variable) {
            Variable variable = (Variable)expression;
            IfStmt stmt = (IfStmt)variable.getValue();
            ConditionExpr expr = (ConditionExpr)stmt.getCondition();
            IntentTaintFact fact = (IntentTaintFact)analysis.getFlowBefore(stmt);
            Value left = expr.getOp1();
            Value right = expr.getOp2();
            if (fact.getPairFromValue(left) == null) {
                return -1;
            }
            if (expr.getOp1() == NullConstant.v() || expr.getOp2() == NullConstant.v()) {
                Pair<IntentSource, DataObject> pair;
                if (expr.getOp1() == NullConstant.v()) {
                    Value mid = right;
                    right = left;
                    left = mid;
                }
                if (fact.getPairFromValue(left) != null && (pair = fact.getPairFromValue(left)).getO1().equals(currentInst.getO1())) {
                    DataObject accessData = pair.getO2();
                    DataObject root = accessData = accessData.clone();
                    DataObject tail = DataObject.getRecurTail(accessData);
                    if (expr instanceof JNeExpr) {
                        tail.setStatus(2);
                    } else if (expr instanceof JEqExpr) {
                        tail.setStatus(1);
                    }
                    return NPEDetector.compareDataObj(root, query);
                }
            } else if (expr.getOp1() instanceof IntConstant || expr.getOp2() instanceof IntConstant) {
                Pair<IntentSource, DataObject> pair;
                if (expr.getOp1() instanceof IntConstant) {
                    Value mid = right;
                    right = left;
                    left = mid;
                }
                if (fact.getPairFromValue(left) != null && (pair = fact.getPairFromValue(left)).getO1().equals(currentInst.getO1())) {
                    DataObject accessData = pair.getO2();
                    DataObject root = accessData = accessData.clone();
                    if ((accessData = DataObject.getRecurThirdTail(root)) == null) {
                        return -1;
                    }
                    if (expr instanceof JNeExpr) {
                        if (((IntConstant)right).value == 0) {
                            accessData.setStatus(1);
                        } else if (((IntConstant)right).value == 1) {
                            accessData.setStatus(2);
                        }
                    } else if (expr instanceof JEqExpr) {
                        if (((IntConstant)right).value == 0) {
                            accessData.setStatus(2);
                        } else if (((IntConstant)right).value == 1) {
                            accessData.setStatus(1);
                        }
                    }
                    return NPEDetector.compareDataObj(root, query);
                }
            }
            return -1;
        }
        if (expression instanceof Not) {
            Not not = (Not)expression;
            Expression expression2 = not.getE();
            if (expression2 instanceof Variable) {
                Variable variable = (Variable)expression2;
                IfStmt stmt = (IfStmt)variable.getValue();
                ConditionExpr expr = (ConditionExpr)stmt.getCondition();
                Value left = expr.getOp1();
                Value right = expr.getOp2();
                IntentTaintFact fact = (IntentTaintFact)analysis.getFlowBefore(stmt);
                if (fact.getPairFromValue(left) == null) {
                    return -1;
                }
                if (expr.getOp1() == NullConstant.v() || expr.getOp2() == NullConstant.v()) {
                    Pair<IntentSource, DataObject> pair;
                    if (expr.getOp1() == NullConstant.v()) {
                        Value mid = right;
                        right = left;
                        left = mid;
                    }
                    if (fact.getPairFromValue(left) != null && (pair = fact.getPairFromValue(left)).getO1().equals(currentInst.getO1())) {
                        DataObject accessData = pair.getO2();
                        DataObject root = accessData = accessData.clone();
                        DataObject tail = DataObject.getRecurTail(accessData);
                        if (expr instanceof JNeExpr) {
                            tail.setStatus(1);
                        } else if (expr instanceof JEqExpr) {
                            tail.setStatus(2);
                        }
                        return NPEDetector.compareDataObj(root, query);
                    }
                } else if (expr.getOp1() instanceof IntConstant || expr.getOp2() instanceof IntConstant) {
                    Pair<IntentSource, DataObject> pair;
                    if (expr.getOp1() instanceof IntConstant) {
                        Value mid = right;
                        right = left;
                        left = mid;
                    }
                    if (fact.getPairFromValue(left) != null && (pair = fact.getPairFromValue(left)).getO1().equals(currentInst.getO1())) {
                        DataObject accessData = pair.getO2();
                        DataObject root = accessData = accessData.clone();
                        if ((accessData = DataObject.getRecurThirdTail(root)) == null) {
                            return -1;
                        }
                        if (expr instanceof JNeExpr) {
                            if (((IntConstant)right).value == 0) {
                                accessData.setStatus(2);
                            } else if (((IntConstant)right).value == 1) {
                                accessData.setStatus(1);
                            }
                        } else if (expr instanceof JEqExpr) {
                            if (((IntConstant)right).value == 0) {
                                accessData.setStatus(1);
                            } else if (((IntConstant)right).value == 1) {
                                accessData.setStatus(2);
                            }
                        }
                        return NPEDetector.compareDataObj(root, query);
                    }
                }
            }
            return -1;
        }
        System.out.println(expression.getClass());
        return -1;
    }
}

